/*
 * Decompiled with CFR 0.152.
 */
package au.id.jericho.lib.html;

import au.id.jericho.lib.html.BasicLogFormatter;
import au.id.jericho.lib.html.Logger;
import java.io.IOException;
import java.io.Writer;

public class WriterLogger
implements Logger {
    private final Writer writer;
    private final String name;
    private boolean errorEnabled = true;
    private boolean warnEnabled = true;
    private boolean infoEnabled = true;
    private boolean debugEnabled = true;

    public WriterLogger(Writer writer) {
        this(writer, "net.htmlparser.jericho");
    }

    public WriterLogger(Writer writer, String name) {
        this.writer = writer;
        this.name = name;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getName() {
        return this.name;
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.log("ERROR", message);
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.log("WARN", message);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.log("INFO", message);
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.log("DEBUG", message);
        }
    }

    public boolean isErrorEnabled() {
        return this.errorEnabled;
    }

    public void setErrorEnabled(boolean errorEnabled) {
        this.errorEnabled = errorEnabled;
    }

    public boolean isWarnEnabled() {
        return this.warnEnabled;
    }

    public void setWarnEnabled(boolean warnEnabled) {
        this.warnEnabled = warnEnabled;
    }

    public boolean isInfoEnabled() {
        return this.infoEnabled;
    }

    public void setInfoEnabled(boolean infoEnabled) {
        this.infoEnabled = infoEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    private void log(String level, String message) {
        try {
            this.writer.write(BasicLogFormatter.format(level, message, this.name));
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

