/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletException;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.ext.realms.CarbonTomcatRealm;
import org.wso2.carbon.tomcat.ext.saas.TenantSaaSRules;
import org.wso2.carbon.tomcat.ext.valves.TomcatValveContainer;

public class CompositeValve
extends ValveBase {
    private static Log log = LogFactory.getLog(CompositeValve.class);
    public static final String ENABLE_SAAS = "carbon.enable.saas";

    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            String enableSaaSParam = request.getContext().findParameter(ENABLE_SAAS);
            Realm realm = request.getContext().getRealm();
            if (enableSaaSParam != null) {
                if (realm instanceof CarbonTomcatRealm) {
                    String[] enableSaaSParams = enableSaaSParam.replaceAll("\\s", "").split(";");
                    HashMap<String, TenantSaaSRules> tenantSaaSRulesMap = new HashMap<String, TenantSaaSRules>();
                    for (String saaSParam : enableSaaSParams) {
                        String[] saaSSubParams = saaSParam.split(":");
                        String tenant = saaSSubParams[0];
                        TenantSaaSRules tenantSaaSRules = new TenantSaaSRules();
                        ArrayList<String> users = null;
                        ArrayList<String> roles = null;
                        if (saaSSubParams.length > 1) {
                            tenantSaaSRules.setTenant(tenant);
                            for (int i = 1; i < saaSSubParams.length; ++i) {
                                String[] saaSTypes = saaSSubParams[i].split("=");
                                if ("users".equals(saaSTypes[0]) && saaSTypes.length == 2) {
                                    users = new ArrayList<String>();
                                    users.addAll(Arrays.asList(saaSTypes[1].split(",")));
                                    continue;
                                }
                                if (!"roles".equals(saaSTypes[0]) || saaSTypes.length != 2) continue;
                                roles = new ArrayList<String>();
                                roles.addAll(Arrays.asList(saaSTypes[1].split(",")));
                            }
                        }
                        if (users != null) {
                            tenantSaaSRules.setUsers(users);
                        }
                        if (roles != null) {
                            tenantSaaSRules.setRoles(roles);
                        }
                        tenantSaaSRulesMap.put(tenant, tenantSaaSRules);
                    }
                    ((CarbonTomcatRealm)realm).setSaaSRules(tenantSaaSRulesMap);
                    ((CarbonTomcatRealm)realm).setSaaSEnabled(Boolean.TRUE);
                }
            } else {
                ((CarbonTomcatRealm)realm).setSaaSEnabled(Boolean.FALSE);
            }
            TomcatValveContainer.invokeValves(request, response);
            int status = response.getStatus();
            if (!(status == 302 || status == 403 || request.getRequestURI().equals("/") && request.getQueryString().equals("wsdl"))) {
                this.getNext().invoke(request, response);
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not handle request: " + request.getRequestURI()), (Throwable)e);
        }
    }
}

