/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.transport.statistics;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransportStatisticsEntry {
    private static final Pattern servicesURLPattern = Pattern.compile("\\/services\\/t\\/(.*?)\\/");
    private static final Pattern webAppsURLPattern = Pattern.compile("\\/t\\/(.*?)\\/webapps\\/");
    private static final String CONTEXT_SERVICES = "services";
    private static final String CONTEXT_WEBAPPS = "webapps";
    private long requestSize;
    private long responseSize;
    private String requestUrl;

    public TransportStatisticsEntry(long requestSize, long responseSize, String requestUrl) {
        this.requestSize = requestSize;
        this.responseSize = responseSize;
        this.requestUrl = requestUrl;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getTenantName() {
        Matcher matcher = servicesURLPattern.matcher(this.requestUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = webAppsURLPattern.matcher(this.requestUrl);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getContext() {
        Matcher matcher = servicesURLPattern.matcher(this.requestUrl);
        if (matcher.find()) {
            return CONTEXT_SERVICES;
        }
        matcher = webAppsURLPattern.matcher(this.requestUrl);
        if (matcher.find()) {
            return CONTEXT_WEBAPPS;
        }
        return null;
    }
}

