/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.lucene.store.jdbc.datasource.AbstractDataSource;

public class DriverManagerDataSource
extends AbstractDataSource {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private boolean autoCommit;

    public DriverManagerDataSource() {
    }

    public DriverManagerDataSource(String driverClassName, String url, String username, String password, boolean autoCommit) {
        this.setDriverClassName(driverClassName);
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
        this.setAutoCommit(autoCommit);
    }

    public DriverManagerDataSource(String url, String username, String password) {
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
    }

    public DriverManagerDataSource(String url) {
        this.setUrl(url);
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
        try {
            Class.forName(this.driverClassName, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not load JDBC driver class [" + this.driverClassName + "]");
        }
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnectionFromDriverManager();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnectionFromDriverManager(this.getUrl(), username, password);
    }

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return this.getConnectionFromDriverManager(this.getUrl(), this.getUsername(), this.getPassword());
    }

    protected Connection getConnectionFromDriverManager(String url, String username, String password) throws SQLException {
        Connection conn = DriverManager.getConnection(url, username, password);
        if (conn.getAutoCommit() != this.autoCommit) {
            conn.setAutoCommit(this.autoCommit);
        }
        return conn;
    }
}

