/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class CarbonUtils {
    private static final String REPOSITORY = "repository";
    private static final String TRUE = "true";
    private static Log log = LogFactory.getLog(CarbonUtils.class);
    private static boolean isServerConfigInitialized;

    public static boolean isAdminConsoleEnabled() {
        boolean enableAdminConsole = false;
        String enableAdminConsoleProp = ServerConfiguration.getInstance().getFirstProperty("Management.EnableConsole");
        if (enableAdminConsoleProp != null) {
            enableAdminConsole = Boolean.valueOf(enableAdminConsoleProp);
        }
        return enableAdminConsole;
    }

    public static int getTransportPort(ConfigurationContextService configContextService, String transport) {
        return CarbonUtils.getTransportPort(configContextService.getServerConfigContext(), transport);
    }

    public static int getTransportPort(ConfigurationContext configContext, String transport) {
        return CarbonUtils.getTransportPort(configContext.getAxisConfiguration(), transport);
    }

    public static int getTransportProxyPort(ConfigurationContext configContext, String transport) {
        return CarbonUtils.getTransportProxyPort(configContext.getAxisConfiguration(), transport);
    }

    public static int getTransportPort(AxisConfiguration axisConfig, String transport) {
        String transportPort = System.getProperty(transport + "Port");
        if (transportPort == null) {
            Parameter portParam = axisConfig.getTransportIn(transport).getParameter("port");
            if (portParam != null) {
                transportPort = (String)portParam.getValue();
            } else {
                throw new IllegalStateException(transport + " port has not been set yet. " + "Most probably the ListenerManager has not" + " been started yet or the this transport does not " + "have a port associated with it. You can wait until " + "the org.apache.axis2.engine.ListenerManager OSGi " + "service is available & retry.");
            }
        }
        return Integer.parseInt(transportPort);
    }

    public static int getTransportProxyPort(AxisConfiguration axisConfig, String transport) {
        Parameter proxyPortParam = axisConfig.getTransportIn(transport).getParameter("proxyPort");
        if (proxyPortParam != null) {
            String transportPort = (String)proxyPortParam.getValue();
            return Integer.parseInt(transportPort);
        }
        return -1;
    }

    public static String getAxis2Xml() {
        String axis2XML = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.ConfigurationFile");
        if (axis2XML == null) {
            axis2XML = System.getProperty("axis2.xml");
        }
        return axis2XML;
    }

    public static String getServerXml() {
        String carbonXML = System.getProperty("carbon.config.dir.path");
        if (carbonXML == null) {
            return CarbonUtils.getCarbonConfigDirPath() + File.separator + "carbon.xml";
        }
        return carbonXML + File.separator + "carbon.xml";
    }

    public static String getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            System.setProperty("carbon.home", carbonHome);
        }
        return carbonHome;
    }

    public static String getCarbonCatalinaHome() {
        String carbonCatalinaHomePath = System.getProperty("carbon.catalina.home");
        if (carbonCatalinaHomePath == null && (carbonCatalinaHomePath = System.getenv("CARBON_CATALINA_DIR_PATH")) == null) {
            return CarbonUtils.getCarbonHome() + File.separator + "lib" + File.separator + "tomcat" + File.separator + "work" + File.separator + "Catalina";
        }
        return carbonCatalinaHomePath;
    }

    public static String getCarbonTenantsDirPath() {
        String carbonTenantsDirPath = System.getProperty("tenants.dir.path");
        if (carbonTenantsDirPath == null) {
            carbonTenantsDirPath = System.getenv("CARBON_TENANTS_DIR_PATH");
        }
        if (carbonTenantsDirPath == null) {
            carbonTenantsDirPath = CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + "tenants";
        }
        return carbonTenantsDirPath;
    }

    public static String getEtcCarbonConfigDirPath() {
        return CarbonUtils.getCarbonConfigDirPath() + File.separator + "etc";
    }

    public static String getCarbonConfigDirPath() {
        String carbonConfigDirPath = System.getProperty("carbon.config.dir.path");
        if (carbonConfigDirPath == null && (carbonConfigDirPath = System.getenv("CARBON_CONFIG_DIR_PATH")) == null) {
            return CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + "conf";
        }
        return carbonConfigDirPath;
    }

    public static String getCarbonLogsPath() {
        String carbonLogsPath = System.getProperty("carbon.logs.path");
        if (carbonLogsPath == null && (carbonLogsPath = System.getenv("CARBON_LOGS")) == null) {
            return CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + "logs";
        }
        return carbonLogsPath;
    }

    public static String getComponentsRepo() {
        String componentsRepo = System.getProperty("components.repo");
        if (componentsRepo == null && (componentsRepo = System.getenv("COMPONENTS_REPO")) == null) {
            return CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + "components" + File.separator + "plugins";
        }
        return componentsRepo;
    }

    public static String getCarbonOSGiDropinsDir() {
        return CarbonUtils.getCarbonHome() + File.separator + REPOSITORY + File.separator + "components" + File.separator + "dropins";
    }

    public static String getAxis2Repo() {
        String axis2Repo = System.getProperty("axis2.repo");
        if (axis2Repo == null) {
            axis2Repo = System.getenv("AXIS2_REPO");
        }
        return axis2Repo;
    }

    public static String getRegistryXMLPath() {
        String carbonHome = CarbonUtils.getCarbonHome();
        String configPath = null;
        if (carbonHome != null) {
            configPath = System.getProperty("wso2.registry.xml") == null ? CarbonUtils.getCarbonConfigDirPath() + File.separator + "registry.xml" : System.getProperty("wso2.registry.xml");
        }
        return configPath;
    }

    public static String getUserMgtXMLPath() {
        String carbonHome = CarbonUtils.getCarbonHome();
        String configPath = null;
        if (carbonHome != null) {
            configPath = System.getProperty("wso2.user.mgt.xml") == null ? CarbonUtils.getCarbonConfigDirPath() + File.separator + "user-mgt.xml" : System.getProperty("wso2.user.mgt.xml");
        }
        return configPath;
    }

    public static boolean isURL(String location) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Long lastUpdatedTime(AxisServiceGroup serviceGroup) {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (CarbonUtils.isURL(axis2Repo)) {
            return null;
        }
        Long lastUpdated = null;
        String fileName = "";
        Iterator serviceIter = serviceGroup.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn != null) {
                fileName = fn.getPath();
            }
            if (fileName == null || fileName.trim().length() == 0) continue;
            File file = new File(fileName);
            lastUpdated = file.lastModified();
            break;
        }
        return lastUpdated;
    }

    public static String computeServiceHash(AxisServiceGroup serviceGroup) {
        String axis2Repo = ServerConfiguration.getInstance().getFirstProperty("Axis2Config.RepositoryLocation");
        if (CarbonUtils.isURL(axis2Repo)) {
            return null;
        }
        Parameter param = serviceGroup.getParameter("forceExistingServiceInit");
        if (param != null && TRUE.equals(param.getValue().toString())) {
            return null;
        }
        String hashValue = null;
        String fileName = "";
        Iterator serviceIter = serviceGroup.getServices();
        while (serviceIter.hasNext()) {
            AxisService axisService = (AxisService)serviceIter.next();
            URL fn = axisService.getFileName();
            if (fn != null) {
                fileName = fn.getPath();
            }
            if (fileName == null || fileName.trim().length() == 0) continue;
            File file = new File(fileName);
            try {
                hashValue = CarbonUtils.getMD5(CarbonUtils.getBytesFromFile(file));
            }
            catch (CarbonException ignore) {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"Error occured in calculating the hash", (Throwable)ignore);
            }
            break;
        }
        return hashValue;
    }

    public static String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getTenantTmpDirPath(AxisConfiguration axisConfig) {
        CarbonContextHolder carbonCtxHolder;
        String tmpPath;
        String tenantTmpDirPath = null;
        String javaTempDir = System.getProperty("java.io.tmpdir");
        if (javaTempDir != null && CarbonUtils.createDir(tmpPath = javaTempDir + File.separator + "tenants") && (carbonCtxHolder = CarbonContextHolder.getCurrentCarbonContextHolder(axisConfig)) != null) {
            int tempTenantId = carbonCtxHolder.getTenantId();
            if (tempTenantId != -1234) {
                tmpPath = tmpPath + File.separator + carbonCtxHolder.getTenantId();
            }
            if (CarbonUtils.createDir(tmpPath)) {
                tenantTmpDirPath = tmpPath;
            }
        }
        return tenantTmpDirPath;
    }

    private static boolean createDir(String path) {
        File tmpFile = new File(path);
        if (!tmpFile.exists() && !tmpFile.mkdir()) {
            log.error((Object)("Error while creating directory at : " + path));
            return false;
        }
        return true;
    }

    public static int getCommandListenerPort() {
        int serverPort = -1;
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String port = serverConfig.getFirstProperty("Ports.CommandListener");
        if (port == null) {
            port = serverConfig.getFirstProperty("CommandListener.Port");
        }
        if (port != null) {
            serverPort = Integer.parseInt(port);
        }
        return serverPort;
    }

    public static void registerFaultyService(String artifactPath, String serviceType, ConfigurationContext configurationContext) throws AxisFault {
        HashMap<String, AxisService> faultyServicesMap;
        String repository = configurationContext.getAxisConfiguration().getRepository().getPath();
        String serviceName = artifactPath;
        if (File.separatorChar == '\\') {
            serviceName = serviceName.replace('\\', '/');
            repository = repository.replace('\\', '/');
        }
        if (serviceName.endsWith("/")) {
            serviceName = serviceName.substring(0, serviceName.length() - 1);
        }
        if (repository.endsWith("/")) {
            repository = repository.substring(0, repository.length() - 1);
        }
        serviceName = serviceName.substring(repository.length() + 1);
        serviceName = serviceName.substring(serviceName.indexOf(47) + 1);
        int slashIndex = serviceName.lastIndexOf(47);
        int dotIndex = serviceName.lastIndexOf(46);
        if (dotIndex != -1 && dotIndex > slashIndex) {
            serviceName = serviceName.substring(0, dotIndex);
        }
        AxisService service = new AxisService(serviceName);
        if (serviceType != null) {
            Parameter serviceTypeParam = new Parameter("serviceType", (Object)serviceType);
            service.addParameter(serviceTypeParam);
        }
        if ((faultyServicesMap = (HashMap<String, AxisService>)configurationContext.getPropertyNonReplicable("local_carbon.faulty.services.map")) == null) {
            faultyServicesMap = new HashMap<String, AxisService>();
            configurationContext.setNonReplicableProperty("local_carbon.faulty.services.map", faultyServicesMap);
        }
        faultyServicesMap.put(artifactPath, service);
    }

    public static AxisService getFaultyService(String serviceName, ConfigurationContext configurationContext) {
        Map faultyServicesMap = (Map)configurationContext.getPropertyNonReplicable("local_carbon.faulty.services.map");
        if (faultyServicesMap != null) {
            return (AxisService)faultyServicesMap.get(serviceName);
        }
        return null;
    }

    public static boolean isRemoteRegistry() throws Exception {
        ServerConfiguration serverConfig = CarbonUtils.getServerConfiguration();
        String isRemoteRegistry = serverConfig.getFirstProperty("Registry.Type");
        return isRemoteRegistry != null && isRemoteRegistry.equalsIgnoreCase("remote");
    }

    public static String getCarbonRepository() {
        ServerConfiguration serverConfig = CarbonUtils.getServerConfiguration();
        return serverConfig.getFirstProperty("Axis2Config.RepositoryLocation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerConfiguration getServerConfiguration() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        if (!isServerConfigInitialized) {
            String serverXml = CarbonUtils.getServerXml();
            File carbonXML = new File(serverXml);
            FileInputStream inSXml = null;
            try {
                inSXml = new FileInputStream(carbonXML);
                serverConfig.init((InputStream)inSXml);
                isServerConfigInitialized = true;
            }
            catch (Exception e) {
                log.error((Object)("Cannot read file " + serverXml), (Throwable)e);
            }
            finally {
                if (inSXml != null) {
                    try {
                        ((InputStream)inSXml).close();
                    }
                    catch (IOException e) {
                        log.warn((Object)("Cannot close file " + serverXml), (Throwable)e);
                    }
                }
            }
        }
        return serverConfig;
    }

    public static boolean isMasterNode() {
        return TRUE.equals(System.getProperty("instance")) && TRUE.equals(System.getProperty("master"));
    }

    public static boolean isChildNode() {
        return TRUE.equals(System.getProperty("instance"));
    }

    public static boolean isMultipleInstanceCase() {
        return System.getProperty("instances.value") != null;
    }

    public static boolean isReadOnlyNode() {
        return CarbonUtils.isChildNode() && !CarbonUtils.isMasterNode();
    }

    public static byte[] getBytesFromFile(File file) throws CarbonException {
        FileInputStream is = null;
        try {
            int offset;
            int numRead;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new CarbonException("File to read is too large. File name: " + file.getName() + ". File length limit: " + Integer.MAX_VALUE);
            }
            byte[] bytes = new byte[(int)length];
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new CarbonException("Couldn't read the entire file. File name: " + file.getName());
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new CarbonException("Error creating the file input stream", e);
        }
        catch (IOException e) {
            throw new CarbonException("Error in reading file. File name: " + file.getName(), e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Error in closing the file input stream. File name: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static String getMD5(byte[] content) {
        MessageDigest m;
        try {
            m = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            log.error((Object)"Error while generating the MD5", (Throwable)e);
            return null;
        }
        m.update(content, 0, content.length);
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static boolean isRunningInStandaloneMode() {
        return System.getProperty("wso2.server.standalone", "false").equalsIgnoreCase(TRUE);
    }

    public static boolean useRegistryBasedRepository() {
        return TRUE.equalsIgnoreCase(System.getProperty("carbon.use.registry.repo"));
    }

    public static void checkSecurity() {
        CarbonBaseUtils.checkSecurity();
    }

    public static void checkSecurity(List<String> allowedClasses) {
        CarbonBaseUtils.checkSecurity();
    }

    public static void checkSecurity(Map<String, String> allowedMethods) {
        CarbonBaseUtils.checkSecurity(allowedMethods);
    }

    public static String getBackendHttpPort(ConfigurationContext configurationContext) throws Exception {
        String httpPort = ServerConfiguration.getInstance().getFirstProperty("RegistryHttpPort");
        if (httpPort == null) {
            httpPort = (String)configurationContext.getAxisConfiguration().getTransportIn("http").getParameter("port").getValue();
        }
        return httpPort;
    }

    public static String getServerURL(ServerConfigurationService serverConfig, ConfigurationContext configCtx) {
        ServerConfiguration serverConfigToProcess = serverConfig == null ? CarbonUtils.getServerConfiguration() : serverConfig;
        return CarbonUtils.getServerURL(serverConfigToProcess.getFirstProperty("ServerURL"), configCtx);
    }

    public static String getServerURL(ServletContext servletContext, HttpSession httpSession, ConfigurationContext configCtx) {
        Object obj = httpSession.getAttribute("ServerURL");
        String url = obj instanceof String ? (String)obj : (String)servletContext.getAttribute("ServerURL");
        return CarbonUtils.getServerURL(url, configCtx);
    }

    private static String getServerURL(String url, ConfigurationContext configCtx) {
        String carbonMgtParam = "${carbon.management.port}";
        String mgtTransport = CarbonUtils.getManagementTransport();
        String returnUrl = url;
        if (returnUrl.indexOf(carbonMgtParam) != -1) {
            String httpsPort = CarbonUtils.getTransportPort(configCtx, mgtTransport) + "";
            returnUrl = returnUrl.replace(carbonMgtParam, httpsPort);
        }
        if (returnUrl.indexOf("${carbon.context}") != -1) {
            String context = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
            if (context.equals("/")) {
                context = "";
            }
            returnUrl = returnUrl.replace("${carbon.context}", context);
        }
        return returnUrl;
    }

    public static String getManagementTransport() {
        String mgtConsoleTransport = ServerConfiguration.getInstance().getFirstProperty("ManagementTransport");
        if (mgtConsoleTransport == null || mgtConsoleTransport.startsWith("${")) {
            mgtConsoleTransport = "https";
        }
        return mgtConsoleTransport;
    }

    public static <T> T[] arrayCopyOf(T[] original) {
        if (original == null) {
            return null;
        }
        Class<?> newType = original.getClass();
        int newLength = original.length;
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, newLength);
        return copy;
    }

    public static int getPortFromServerConfig(String property) {
        String portTemplate;
        String port;
        int indexOfClosingBrace;
        int portNumber = -1;
        int indexOfStartingChars = -1;
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        if (indexOfStartingChars < property.indexOf("${") && (indexOfStartingChars = property.indexOf("${")) != -1 && (indexOfClosingBrace = property.indexOf(125)) != -1 && (port = serverConfiguration.getFirstProperty(portTemplate = property.substring(indexOfStartingChars + 2, indexOfClosingBrace))) != null) {
            portNumber = Integer.parseInt(port);
        }
        String portOffset = System.getProperty("portOffset", serverConfiguration.getFirstProperty("Ports.Offset"));
        System.setProperty("portOffset", portOffset);
        return portOffset == null ? portNumber : portNumber + Integer.parseInt(portOffset);
    }

    public static boolean isFilteredOutService(AxisService service) {
        String adminParamValue = (String)service.getParameterValue("adminService");
        String hiddenParamValue = (String)service.getParameterValue("hiddenService");
        return adminParamValue != null && adminParamValue.length() != 0 ? Boolean.parseBoolean(adminParamValue.trim()) : hiddenParamValue != null && hiddenParamValue.length() != 0 && Boolean.parseBoolean(hiddenParamValue.trim());
    }

    public static boolean isRunningOnLocalTransportMode() {
        return System.getProperty("localTransportModeEnabled") != null;
    }

    public static String getAxis2ServicesDir(AxisConfiguration axisConfig) {
        String servicesDir = "axis2services";
        String serviceDirPara = (String)axisConfig.getParameterValue("ServicesDirectory");
        if (serviceDirPara != null) {
            servicesDir = serviceDirPara;
        }
        return servicesDir;
    }

    public static void setBasicAccessSecurityHeaders(String userName, String password, boolean rememberMe, ServiceClient serviceClient) {
        String userNamePassword = userName + ":" + password;
        String encodedString = Base64Utils.encode((byte[])userNamePassword.getBytes());
        String authorizationHeader = "Basic " + encodedString;
        ArrayList<Header> headers = new ArrayList<Header>();
        Header authHeader = new Header("Authorization", authorizationHeader);
        headers.add(authHeader);
        if (rememberMe) {
            Header rememberMeHeader = new Header("RememberMe", TRUE);
            headers.add(rememberMeHeader);
        }
        serviceClient.getOptions().setProperty("HTTP_HEADERS", headers);
    }

    public static void setBasicAccessSecurityHeaders(String userName, String password, boolean rememberMe, MessageContext msgContext) throws AxisFault {
        String userNamePassword = userName + ":" + password;
        String encodedString = Base64Utils.encode((byte[])userNamePassword.getBytes());
        String authorizationHeader = "Basic " + encodedString;
        ArrayList<Header> headers = new ArrayList<Header>();
        Header authHeader = new Header("Authorization", authorizationHeader);
        headers.add(authHeader);
        if (rememberMe) {
            Header rememberMeHeader = new Header("RememberMe", TRUE);
            headers.add(rememberMeHeader);
        }
        msgContext.getOptions().setProperty("HTTP_HEADERS", headers);
    }

    public static void setBasicAccessSecurityHeaders(String userName, String password, ServiceClient serviceClient) {
        CarbonUtils.setBasicAccessSecurityHeaders(userName, password, false, serviceClient);
    }
}

