/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.saml.SAML2Util;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2TokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)SAML2TokenProcessor.class.getName());
    private String id;
    private Element samlTokenElement;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig config) throws WSSecurityException {
        Assertion assertion = this.buildAssertion(elem);
        if (assertion.getSignature() != null) {
            SAML2Util.validateSignature(assertion, crypto);
        }
        this.id = assertion.getID();
        this.samlTokenElement = elem;
        WSSecurityEngineResult securityEngineResult = new WSSecurityEngineResult(8, assertion);
        returnResults.add(0, securityEngineResult);
        securityEngineResult.put("samlVersion", "urn:oasis:names:tc:SAML:2.0:assertion");
        returnResults.add(0, new WSSecurityEngineResult(17, SAML2Util.getTimestampForSAMLAssertion(assertion)));
        securityEngineResult.put("Issuer", assertion.getIssuer());
        securityEngineResult.put("Claims", SAML2Util.getClaims(assertion));
    }

    public Assertion buildAssertion(Element elem) throws WSSecurityException {
        Assertion samlAssertion;
        try {
            DefaultBootstrap.bootstrap();
            String keyInfoElementString = elem.toString();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(keyInfoElementString.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            samlAssertion = (Assertion)unmarshaller.unmarshall(element);
        }
        catch (ConfigurationException e) {
            throw new WSSecurityException(0, "Failure in bootstrapping", null, e);
        }
        catch (UnmarshallingException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (SAXException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SAML2 Token was validated successfully.");
        }
        return samlAssertion;
    }

    public Element getSamlTokenElement() {
        return this.samlTokenElement;
    }

    public void setSamlTokenElement(Element samlTokenElement) {
        this.samlTokenElement = samlTokenElement;
    }

    public String getId() {
        return this.id;
    }
}

