/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.processor.Processor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDocInfo {
    Document doc = null;
    Crypto crypto = null;
    Vector bst = null;
    Element assertion = null;
    Vector processors = null;
    List securityTokenReferences = null;

    public WSDocInfo(Document doc) {
        this.doc = doc.getDocumentElement().getOwnerDocument();
    }

    public void setSecurityTokenReference(Element securityTokenRef) {
        if (this.securityTokenReferences == null) {
            this.securityTokenReferences = new Vector();
        }
        this.securityTokenReferences.add(securityTokenRef);
    }

    public Element getSecurityTokenReference(String uri) {
        if (this.securityTokenReferences != null) {
            for (Element elem : this.securityTokenReferences) {
                String cId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (!uri.equals(cId)) continue;
                return elem;
            }
        }
        return null;
    }

    public void clear() {
        this.crypto = null;
        this.assertion = null;
        if (this.bst != null && this.bst.size() > 0) {
            this.bst.removeAllElements();
        }
        if (this.processors != null && this.processors.size() > 0) {
            this.processors.removeAllElements();
        }
        this.bst = null;
        this.processors = null;
    }

    public Element getBst(String uri) {
        String id = uri.substring(1);
        if (this.bst != null) {
            Enumeration e = this.bst.elements();
            while (e.hasMoreElements()) {
                Element elem = (Element)e.nextElement();
                String cId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                if (!id.equals(cId)) continue;
                return elem;
            }
        }
        return null;
    }

    public Processor getProcessor(String id) {
        if (id == null) {
            return null;
        }
        Processor p = null;
        if (this.processors != null) {
            Enumeration e = this.processors.elements();
            while (e.hasMoreElements()) {
                p = (Processor)e.nextElement();
                String cId = p.getId();
                if (!id.equals(cId)) continue;
                return p;
            }
        }
        return null;
    }

    public void setProcessor(Processor p) {
        if (this.processors == null) {
            this.processors = new Vector();
        }
        this.processors.add(p);
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setBst(Element elem) {
        if (this.bst == null) {
            this.bst = new Vector();
        }
        this.bst.add(elem);
    }

    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    public Element getAssertion() {
        return this.assertion;
    }

    public void setAssertion(Element assertion) {
        this.assertion = assertion;
    }
}

