/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.dataaccess;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class TenantAwareSQLTransformer {
    private static final Log log = LogFactory.getLog(TenantAwareSQLTransformer.class);
    private String transformedQuery = null;
    private int parameterCount = 0;
    private int trailingParameterCount = 0;

    public TenantAwareSQLTransformer(String sqlQuery) throws RegistryException {
        String sqlQueryUCase = sqlQuery.toUpperCase();
        this.parameterCount = 0;
        int endOfFromIndex = sqlQueryUCase.indexOf("FROM");
        if (endOfFromIndex == -1) {
            String msg = "Error in parsing the query. You should have a 'FROM' token in your custom query";
            log.error((Object)msg);
            throw new RegistryException(msg);
        }
        endOfFromIndex += 4;
        int startOfWhereIndex = sqlQueryUCase.indexOf("WHERE");
        int startOfThirdClauseIndex = -1;
        for (String s : new String[]{"GROUP BY", "HAVING", "ORDER BY", "LIMIT"}) {
            int index = sqlQueryUCase.indexOf(s);
            if (index <= 0 || startOfThirdClauseIndex != -1 && index >= startOfThirdClauseIndex) continue;
            startOfThirdClauseIndex = index;
        }
        boolean whereNotFound = false;
        if (startOfWhereIndex == -1) {
            whereNotFound = true;
            startOfWhereIndex = sqlQueryUCase.length();
            if (startOfThirdClauseIndex != -1) {
                startOfWhereIndex = startOfThirdClauseIndex;
            }
        }
        String fromPart = sqlQuery.substring(endOfFromIndex + 1, startOfWhereIndex);
        StringTokenizer tokenizer = new StringTokenizer(fromPart, ",");
        StringBuilder sb = new StringBuilder();
        while (tokenizer.hasMoreElements()) {
            String secondPart;
            String firstPart;
            String token = tokenizer.nextToken();
            token = token.trim();
            int separator = (token = token.replaceAll("[\t\r\n]+", " ")).indexOf(32);
            if (separator == -1) {
                firstPart = token;
                secondPart = null;
            } else {
                firstPart = token.substring(0, separator);
                secondPart = token.substring(separator + 1);
                firstPart = firstPart.trim();
                secondPart = secondPart.trim();
            }
            if (secondPart == null) {
                if (sb.length() < 1) {
                    sb.append(firstPart).append(".REG_TENANT_ID=?");
                } else {
                    sb.append(" AND ").append(firstPart).append(".REG_TENANT_ID=?");
                }
            } else if (sb.length() < 1) {
                sb.append(secondPart).append(".REG_TENANT_ID=?");
            } else {
                sb.append(" AND ").append(secondPart).append(".REG_TENANT_ID=?");
            }
            ++this.parameterCount;
        }
        String additionalWherePart = sb.toString();
        if (whereNotFound) {
            if (startOfThirdClauseIndex == -1) {
                this.transformedQuery = sqlQuery + " WHERE " + additionalWherePart;
            } else {
                String[] parts = sqlQuery.substring(startOfThirdClauseIndex).split("[?]");
                if (parts != null && parts.length > 1) {
                    this.trailingParameterCount += parts.length - 1;
                    if (sqlQuery.substring(startOfThirdClauseIndex).endsWith("?")) {
                        ++this.trailingParameterCount;
                    }
                }
                this.transformedQuery = sqlQuery.substring(0, startOfThirdClauseIndex) + " WHERE " + additionalWherePart + " " + sqlQuery.substring(startOfThirdClauseIndex);
            }
        } else {
            int endOfWhereIndex = startOfWhereIndex + 5;
            this.transformedQuery = sqlQuery.substring(0, endOfWhereIndex) + " (" + additionalWherePart + ") AND " + sqlQuery.substring(endOfWhereIndex);
        }
    }

    String getTransformedQuery() {
        return this.transformedQuery;
    }

    int getAdditionalParameterCount() {
        return this.parameterCount;
    }

    int getTrailingParameterCount() {
        return this.trailingParameterCount;
    }
}

