/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.config;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Aspect;
import org.wso2.carbon.registry.core.config.DataBaseConfiguration;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.QueryProcessorConfiguration;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.RemoteConfiguration;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.CustomEditManager;
import org.wso2.carbon.registry.core.jdbc.handlers.EditProcessor;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.filters.Filter;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class RegistryConfigurationProcessor {
    private static final Log log = LogFactory.getLog(RegistryConfigurationProcessor.class);

    public static void populateRegistryConfig(InputStream in, RegistryContext registryContext) throws RegistryException {
        if (in == null && (in = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/wso2/carbon/registry/core/servlet/registry.xml")) == null) {
            return;
        }
        try {
            StAXOMBuilder builder = new StAXOMBuilder(in);
            OMElement configElement = builder.getDocumentElement();
            if (configElement != null) {
                OMElement currentConfigElement;
                OMElement enableCachingEle;
                OMElement readOnlyEle;
                OMElement registryRootEle = configElement.getFirstChildWithName(new QName("registryRoot"));
                if (registryRootEle != null) {
                    String registryRoot = registryRootEle.getText();
                    if (registryRoot != null && !registryRoot.equals("/")) {
                        if (registryRoot.endsWith("/")) {
                            registryRoot = registryRoot.substring(0, registryRoot.length() - 1);
                        } else if (!registryRoot.startsWith("/")) {
                            registryRoot = "/" + registryRoot;
                        }
                    } else {
                        registryRoot = null;
                    }
                    registryContext.setRegistryRoot(registryRoot);
                }
                if ((readOnlyEle = configElement.getFirstChildWithName(new QName("readOnly"))) != null) {
                    registryContext.setReadOnly(CarbonUtils.isReadOnlyNode() || "true".equals(readOnlyEle.getText()));
                }
                if ((enableCachingEle = configElement.getFirstChildWithName(new QName("enableCache"))) != null) {
                    registryContext.setCacheEnabled("true".equals(enableCachingEle.getText()));
                }
                SecretResolver secretResolver = SecretResolverFactory.create((OMElement)configElement, (boolean)false);
                Iterator dbConfigs = configElement.getChildrenWithName(new QName("dbConfig"));
                while (dbConfigs.hasNext()) {
                    OMElement dbConfig = (OMElement)dbConfigs.next();
                    DataBaseConfiguration dataBaseConfiguration = new DataBaseConfiguration();
                    dataBaseConfiguration.setPasswordManager(secretResolver);
                    String dbName = dbConfig.getAttributeValue(new QName("name"));
                    if (dbName == null) {
                        throw new RegistryException("The database configuration name cannot be null.");
                    }
                    dataBaseConfiguration.setConfigName(dbName);
                    OMElement dataSource = dbConfig.getFirstChildWithName(new QName("dataSource"));
                    if (dataSource != null) {
                        dataBaseConfiguration.setDataSourceName(dataSource.getText());
                    } else {
                        OMElement validationQuery;
                        OMElement minIdle;
                        OMElement maxIdle;
                        OMElement maxActive;
                        OMElement numTestsPerEvictionRun;
                        OMElement minEvictableIdleTimeMillis;
                        OMElement timeBetweenEvictionRunsMillis;
                        OMElement testWhileIdle;
                        OMElement maxWait;
                        OMElement url;
                        String dbUrl;
                        OMElement password;
                        OMElement userName = dbConfig.getFirstChildWithName(new QName("userName"));
                        if (userName != null) {
                            dataBaseConfiguration.setUserName(userName.getText());
                        }
                        if ((password = dbConfig.getFirstChildWithName(new QName("password"))) != null) {
                            dataBaseConfiguration.setPassWord(password.getText());
                        }
                        if ((dbUrl = (url = dbConfig.getFirstChildWithName(new QName("url"))).getText()) != null && dbUrl.contains("${carbon.home}")) {
                            File carbonHomeDir = new File(CarbonUtils.getCarbonHome());
                            String path = carbonHomeDir.getPath();
                            path = path.replaceAll(Pattern.quote("\\"), "/");
                            if (carbonHomeDir.exists() && carbonHomeDir.isDirectory()) {
                                dbUrl = dbUrl.replaceAll(Pattern.quote("${carbon.home}"), path);
                            } else {
                                log.warn((Object)"carbon home invalid");
                                String[] tempStrings1 = dbUrl.split(Pattern.quote("${carbon.home}"));
                                String tempUrl = tempStrings1[1];
                                String[] tempStrings2 = tempUrl.split("/");
                                for (int i = 0; i < tempStrings2.length - 1; ++i) {
                                    dbUrl = tempStrings1[0] + tempStrings2[i] + "/";
                                }
                                dbUrl = dbUrl + tempStrings2[tempStrings2.length - 1];
                            }
                            url.setText(dbUrl);
                        }
                        dataBaseConfiguration.setDbUrl(url.getText());
                        OMElement driverName = dbConfig.getFirstChildWithName(new QName("driverName"));
                        if (driverName != null) {
                            dataBaseConfiguration.setDriverName(driverName.getText());
                        }
                        if ((maxWait = dbConfig.getFirstChildWithName(new QName("maxWait"))) != null) {
                            dataBaseConfiguration.setMaxWait(maxWait.getText());
                        }
                        if ((testWhileIdle = dbConfig.getFirstChildWithName(new QName("testWhileIdle"))) != null) {
                            dataBaseConfiguration.setTestWhileIdle(testWhileIdle.getText());
                        }
                        if ((timeBetweenEvictionRunsMillis = dbConfig.getFirstChildWithName(new QName("timeBetweenEvictionRunsMillis"))) != null) {
                            dataBaseConfiguration.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.getText());
                        }
                        if ((minEvictableIdleTimeMillis = dbConfig.getFirstChildWithName(new QName("minEvictableIdleTimeMillis"))) != null) {
                            dataBaseConfiguration.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis.getText());
                        }
                        if ((numTestsPerEvictionRun = dbConfig.getFirstChildWithName(new QName("numTestsPerEvictionRun"))) != null) {
                            dataBaseConfiguration.setNumTestsPerEvictionRun(numTestsPerEvictionRun.getText());
                        }
                        if ((maxActive = dbConfig.getFirstChildWithName(new QName("maxActive"))) != null) {
                            dataBaseConfiguration.setMaxActive(maxActive.getText());
                        }
                        if ((maxIdle = dbConfig.getFirstChildWithName(new QName("maxIdle"))) != null) {
                            dataBaseConfiguration.setMaxIdle(maxIdle.getText());
                        }
                        if ((minIdle = dbConfig.getFirstChildWithName(new QName("minIdle"))) != null) {
                            dataBaseConfiguration.setMinIdle(minIdle.getText());
                        }
                        if ((validationQuery = dbConfig.getFirstChildWithName(new QName("validationQuery"))) != null) {
                            dataBaseConfiguration.setValidationQuery(validationQuery.getText());
                        }
                    }
                    registryContext.addDBConfig(dbName, dataBaseConfiguration);
                }
                OMElement staticConfigElement = configElement.getFirstChildWithName(new QName("staticConfiguration"));
                if (staticConfigElement != null) {
                    Iterator staticConfigs = staticConfigElement.getChildElements();
                    while (staticConfigs.hasNext()) {
                        OMElement staticConfig = (OMElement)staticConfigs.next();
                        if (staticConfig.getLocalName().equals("versioningProperties")) {
                            String versioningProperties = staticConfig.getText();
                            StaticConfiguration.setVersioningProperties(versioningProperties.equals("true"));
                            continue;
                        }
                        if (staticConfig.getLocalName().equals("versioningComments")) {
                            String versioningComments = staticConfig.getText();
                            StaticConfiguration.setVersioningComments(versioningComments.equals("true"));
                            continue;
                        }
                        if (staticConfig.getLocalName().equals("versioningTags")) {
                            String versioningTags = staticConfig.getText();
                            StaticConfiguration.setVersioningTags(versioningTags.equals("true"));
                            continue;
                        }
                        if (staticConfig.getLocalName().equals("versioningRatings")) {
                            String versioningRatings = staticConfig.getText();
                            StaticConfiguration.setVersioningRatings(versioningRatings.equals("true"));
                            continue;
                        }
                        if (staticConfig.getLocalName().equals("versioningAssociations")) {
                            String versioningAssociations = staticConfig.getText();
                            StaticConfiguration.setVersioningAssociations(versioningAssociations.equals("true"));
                            continue;
                        }
                        if (staticConfig.getLocalName().equals("profilesPath")) {
                            String profilesPath = staticConfig.getText();
                            if (!profilesPath.startsWith("/")) {
                                profilesPath = "/" + profilesPath;
                            }
                            if (profilesPath.endsWith("/")) {
                                profilesPath = profilesPath.substring(0, profilesPath.length() - 1);
                            }
                            if (profilesPath == null) continue;
                            if (profilesPath.startsWith("/_system/config")) {
                                registryContext.setProfilesPath(profilesPath);
                                continue;
                            }
                            registryContext.setProfilesPath("/_system/config" + profilesPath);
                            continue;
                        }
                        if (!staticConfig.getLocalName().equals("servicePath")) continue;
                        String servicePath = staticConfig.getText();
                        if (!servicePath.startsWith("/")) {
                            servicePath = "/" + servicePath;
                        }
                        if (servicePath.endsWith("/")) {
                            servicePath = servicePath.substring(0, servicePath.length() - 1);
                        }
                        if (servicePath == null) continue;
                        if (servicePath.startsWith("/_system/governance")) {
                            registryContext.setServicePath(servicePath);
                            continue;
                        }
                        registryContext.setServicePath("/_system/governance" + servicePath);
                    }
                }
                if ((currentConfigElement = configElement.getFirstChildWithName(new QName("currentDBConfig"))) == null) {
                    throw new RegistryException("The current database configuration is not defined.");
                }
                String currentConfigName = currentConfigElement.getText();
                DataBaseConfiguration dbConfiguration = registryContext.selectDBConfig(currentConfigName);
                registryContext.setDefaultDataBaseConfiguration(dbConfiguration);
                OMElement versionConfig = configElement.getFirstChildWithName(new QName("versionResourcesOnChange"));
                if (versionConfig != null && "true".equals(versionConfig.getText())) {
                    registryContext.setVersionOnChange(true);
                } else {
                    registryContext.setVersionOnChange(false);
                }
                RegistryConfigurationProcessor.initializeHandlers(configElement, registryContext);
                RegistryConfigurationProcessor.readRemoteInstances(configElement, registryContext, secretResolver);
                RegistryConfigurationProcessor.readMounts(configElement, registryContext);
                Iterator queryProcessors = configElement.getChildrenWithName(new QName("queryProcessor"));
                while (queryProcessors.hasNext()) {
                    OMElement processorName;
                    QueryProcessorConfiguration queryProcessorConfiguration = new QueryProcessorConfiguration();
                    OMElement queryProcessorElement = (OMElement)queryProcessors.next();
                    OMElement queryType = queryProcessorElement.getFirstChildWithName(new QName("queryType"));
                    if (queryType != null) {
                        queryProcessorConfiguration.setQueryType(queryType.getText());
                    }
                    if ((processorName = queryProcessorElement.getFirstChildWithName(new QName("processor"))) != null) {
                        queryProcessorConfiguration.setProcessorClassName(processorName.getText());
                    }
                    registryContext.addQueryProcessor(queryProcessorConfiguration);
                }
                RegistryConfigurationProcessor.initializeAspects(configElement, registryContext);
            }
        }
        catch (XMLStreamException e) {
            throw new RegistryException(e.getMessage());
        }
    }

    public static OMElement getRegistryConfigAsXML(RegistryContext registryContext) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement root = factory.createOMElement("wso2registry", null);
        if (registryContext.getDefaultDataBaseConfiguration() != null) {
            OMElement currentConfigElement = factory.createOMElement("currentConfig", null);
            currentConfigElement.setText(registryContext.getDefaultDataBaseConfiguration().getConfigName());
            root.addChild((OMNode)currentConfigElement);
        }
        Iterator<String> values = registryContext.getDBConfigNames();
        while (values.hasNext()) {
            DataBaseConfiguration dataBaseConfiguration = (DataBaseConfiguration)((Object)values.next());
            OMElement config = factory.createOMElement("dbConfig", null);
            OMElement url = factory.createOMElement("url", null);
            url.setText(dataBaseConfiguration.getDbUrl());
            config.addChild((OMNode)url);
            OMElement userName = factory.createOMElement("userName", null);
            userName.setText(dataBaseConfiguration.getUserName());
            config.addChild((OMNode)userName);
            OMElement password = factory.createOMElement("password", null);
            password.setText(dataBaseConfiguration.getResolvedPassword());
            config.addChild((OMNode)password);
            OMElement driverName = factory.createOMElement("driverName", null);
            driverName.setText(dataBaseConfiguration.getDriverName());
            config.addChild((OMNode)driverName);
            config.addAttribute("name", dataBaseConfiguration.getConfigName(), null);
            root.addChild((OMNode)config);
        }
        return root;
    }

    public static void initializeAspects(OMElement configElement, RegistryContext registryContext) throws RegistryException {
        Iterator aspectElement = configElement.getChildrenWithName(new QName("aspect"));
        if (aspectElement != null) {
            while (aspectElement.hasNext()) {
                OMElement aspect = (OMElement)aspectElement.next();
                String name = aspect.getAttributeValue(new QName("name"));
                registryContext.addAspect(name, RegistryConfigurationProcessor.buildAspect(aspect, name), 0);
            }
        }
    }

    private static Aspect buildAspect(OMElement aspect, String name) throws RegistryException {
        String clazz = aspect.getAttributeValue(new QName("class"));
        Aspect aspectInstance = null;
        try {
            if (name == null || clazz == null) {
                throw new RegistryException("Invalid aspect element , required values are missing " + aspect.toString());
            }
            Class handlerClass = RegistryUtils.loadClass(clazz);
            if (aspect.getChildElements().hasNext()) {
                try {
                    Constructor constructor = handlerClass.getConstructor(OMElement.class);
                    try {
                        aspectInstance = (Aspect)constructor.newInstance(aspect);
                    }
                    catch (Exception e) {
                        throw new RegistryException("Couldn't instantiate", e);
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (aspectInstance == null) {
                aspectInstance = (Aspect)handlerClass.newInstance();
            }
            return aspectInstance;
        }
        catch (Exception e) {
            String msg = "Could not initialize custom aspects. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    public static Aspect updateAspects(OMElement configElement) throws RegistryException {
        Iterator aspectElement = configElement.getChildrenWithName(new QName("aspect"));
        if (aspectElement != null) {
            OMElement aspect = (OMElement)aspectElement.next();
            String name = aspect.getAttributeValue(new QName("name"));
            return RegistryConfigurationProcessor.buildAspect(aspect, name);
        }
        return null;
    }

    private static void initializeHandlers(OMElement configElement, RegistryContext registryContext) throws RegistryException {
        CustomEditManager customEditManager = registryContext.getCustomEditManager();
        try {
            Iterator handlerConfigs = configElement.getChildrenWithName(new QName("handler"));
            while (handlerConfigs.hasNext()) {
                OMElement handlerConfigElement = (OMElement)handlerConfigs.next();
                RegistryConfigurationProcessor.buildHandler(registryContext, customEditManager, handlerConfigElement, null);
            }
        }
        catch (Exception e) {
            String msg = "Could not initialize custom handlers. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    public static boolean updateHandler(OMElement configElement, RegistryContext registryContext, String lifecyclePhase) throws RegistryException {
        try {
            Iterator handlerConfigs = configElement.getChildrenWithName(new QName("handler"));
            if (handlerConfigs != null) {
                OMElement handlerConfigElement = (OMElement)handlerConfigs.next();
                return RegistryConfigurationProcessor.buildHandler(registryContext, null, handlerConfigElement, lifecyclePhase);
            }
            return false;
        }
        catch (Exception e) {
            String msg = "Could not create custom handler. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean buildHandler(RegistryContext registryContext, CustomEditManager customEditManager, OMElement handlerConfigElement, String lifecyclePhase) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, UserStoreException {
        HandlerDefinitionObject handlerDefinitionObject = new HandlerDefinitionObject(customEditManager, handlerConfigElement).invoke();
        String[] methods = handlerDefinitionObject.getMethods();
        Filter filter = handlerDefinitionObject.getFilter();
        Handler handler = handlerDefinitionObject.getHandler();
        if (filter == null || handler == null) {
            return false;
        }
        if (lifecyclePhase != null) {
            if (handlerDefinitionObject.getTenantId() != -1 && !"default".equals(lifecyclePhase) && !"system".equals(lifecyclePhase)) {
                CurrentSession.setCallerTenantId(handlerDefinitionObject.getTenantId());
                try {
                    registryContext.getHandlerManager().addHandler(methods, filter, handler, lifecyclePhase);
                }
                finally {
                    CurrentSession.removeCallerTenantId();
                }
            } else {
                registryContext.getHandlerManager().addHandler(methods, filter, handler, lifecyclePhase);
            }
        } else {
            registryContext.getHandlerManager().addHandler(methods, filter, handler, "system");
        }
        return true;
    }

    private static void readRemoteInstances(OMElement configElement, RegistryContext registryContext, SecretResolver secretResolver) throws RegistryException {
        try {
            Iterator remoteConfigs = configElement.getChildrenWithName(new QName("remoteInstance"));
            ArrayList<String> idList = new ArrayList<String>();
            while (remoteConfigs.hasNext()) {
                OMElement remoteConfigElement = (OMElement)remoteConfigs.next();
                String url = remoteConfigElement.getAttributeValue(new QName("url"));
                String id = remoteConfigElement.getFirstChildWithName(new QName("id")).getText();
                if (idList.contains(id)) {
                    String msg = "Two remote instances can't have the same id.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                idList.add(id);
                String trustedUser = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("username")) != null) {
                    trustedUser = remoteConfigElement.getFirstChildWithName(new QName("username")).getText();
                }
                String trustedPwd = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("password")) != null) {
                    trustedPwd = remoteConfigElement.getFirstChildWithName(new QName("password")).getText();
                }
                String type = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("type")) != null) {
                    type = remoteConfigElement.getFirstChildWithName(new QName("type")).getText();
                }
                String dbConfig = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("dbConfig")) != null) {
                    dbConfig = remoteConfigElement.getFirstChildWithName(new QName("dbConfig")).getText();
                }
                String readOnly = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("readOnly")) != null) {
                    readOnly = remoteConfigElement.getFirstChildWithName(new QName("readOnly")).getText();
                }
                String enableCache = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("enableCache")) != null) {
                    enableCache = remoteConfigElement.getFirstChildWithName(new QName("enableCache")).getText();
                }
                String registryRoot = null;
                if (remoteConfigElement.getFirstChildWithName(new QName("registryRoot")) != null) {
                    registryRoot = remoteConfigElement.getFirstChildWithName(new QName("registryRoot")).getText();
                }
                RemoteConfiguration remoteConfiguration = new RemoteConfiguration();
                remoteConfiguration.setPasswordManager(secretResolver);
                remoteConfiguration.setId(id);
                remoteConfiguration.setUrl(url);
                remoteConfiguration.setTrustedUser(trustedUser);
                remoteConfiguration.setTrustedPwd(trustedPwd);
                remoteConfiguration.setType(type);
                remoteConfiguration.setDbConfig(dbConfig);
                remoteConfiguration.setReadOnly(readOnly);
                remoteConfiguration.setCacheEnabled(enableCache);
                remoteConfiguration.setRegistryRoot(registryRoot);
                registryContext.getRemoteInstances().add(remoteConfiguration);
            }
        }
        catch (Exception e) {
            String msg = "Could not read remote instance configuration. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    private static void readMounts(OMElement configElement, RegistryContext registryContext) throws RegistryException {
        try {
            Iterator mounts = configElement.getChildrenWithName(new QName("mount"));
            ArrayList<String> pathList = new ArrayList<String>();
            while (mounts.hasNext()) {
                String msg;
                OMElement mountElement = (OMElement)mounts.next();
                String path = mountElement.getAttributeValue(new QName("path"));
                if (path == null) {
                    msg = "The path attribute was not specified for remote mount. Skipping creation of remote mount. Element: " + mountElement.toString();
                    log.warn((Object)msg);
                    continue;
                }
                if (pathList.contains(path)) {
                    msg = "Two remote instances can't have the same path.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                OMElement instanceIdElement = mountElement.getFirstChildWithName(new QName("instanceId"));
                if (instanceIdElement == null) {
                    String msg2 = "The instance identifier was not specified for the mount: " + path;
                    log.warn((Object)msg2);
                    continue;
                }
                OMElement targetPathElement = mountElement.getFirstChildWithName(new QName("targetPath"));
                if (targetPathElement == null) {
                    String msg3 = "The target path was not specified for the mount: " + path;
                    log.warn((Object)msg3);
                    continue;
                }
                pathList.add(path);
                String overwriteStr = mountElement.getAttributeValue(new QName("overwrite"));
                boolean overwrite = false;
                boolean virtual = false;
                if (overwriteStr != null && !(overwrite = Boolean.toString(true).equalsIgnoreCase(overwriteStr))) {
                    virtual = "virtual".equalsIgnoreCase(overwriteStr);
                }
                String instanceId = instanceIdElement.getText();
                String targetPath = targetPathElement.getText();
                Mount mount = new Mount();
                mount.setPath(path);
                mount.setOverwrite(overwrite);
                mount.setVirtual(virtual);
                mount.setInstanceId(instanceId);
                mount.setTargetPath(targetPath);
                registryContext.getMounts().add(mount);
            }
        }
        catch (Exception e) {
            String msg = "Could not read remote instance configuration. Caused by: " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
    }

    private static String getSetterName(String varName) {
        String setterName = varName.length() == 1 ? "set" + varName.substring(0, 1).toUpperCase() : "set" + varName.substring(0, 1).toUpperCase() + varName.substring(1, varName.length());
        return setterName;
    }

    public static class HandlerDefinitionObject {
        private CustomEditManager customEditManager;
        private OMElement handlerConfigElement;
        private List<String> methods;
        private Handler handler;
        private Filter filter;
        private int tenantId;

        public HandlerDefinitionObject(CustomEditManager customEditManager, OMElement handlerConfigElement) {
            this.customEditManager = customEditManager;
            this.handlerConfigElement = handlerConfigElement;
        }

        public HandlerDefinitionObject(OMElement handlerConfigElement) {
            this.customEditManager = null;
            this.handlerConfigElement = handlerConfigElement;
        }

        public String[] getMethods() {
            if (this.methods == null) {
                return null;
            }
            return this.methods.toArray(new String[this.methods.size()]);
        }

        public Handler getHandler() {
            return this.handler;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public HandlerDefinitionObject invoke() throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, UserStoreException {
            OMElement editElement;
            Class filterClass;
            Class handlerClass;
            String methodsValue;
            String handlerClassName;
            block19: {
                handlerClassName = this.handlerConfigElement.getAttributeValue(new QName("class"));
                methodsValue = this.handlerConfigElement.getAttributeValue(new QName("methods"));
                String tenantIdString = this.handlerConfigElement.getAttributeValue(new QName("tenant"));
                this.tenantId = -1;
                int tempTenantId = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId();
                if (tempTenantId != -1) {
                    this.tenantId = tempTenantId;
                } else if (tenantIdString != null) {
                    try {
                        this.tenantId = Integer.parseInt(tenantIdString);
                    }
                    catch (NumberFormatException ignore) {
                        RegistryContext context = RegistryContext.getBaseInstance();
                        if (context == null || context.getRealmService() == null) break block19;
                        try {
                            this.tenantId = context.getRealmService().getTenantManager().getTenantId(tenantIdString);
                        }
                        catch (org.wso2.carbon.user.api.UserStoreException e) {
                            throw new UserStoreException((Throwable)e);
                        }
                    }
                }
            }
            if (methodsValue != null) {
                String[] methods = methodsValue.split(",");
                for (int i = 0; i < methods.length; ++i) {
                    methods[i] = methods[i].trim();
                }
                this.methods = Arrays.asList(methods);
            }
            try {
                handlerClass = RegistryUtils.loadClass(handlerClassName);
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find the handler class " + handlerClassName + ". This handler will not be registered. All handler and " + "filter classes should be in the class path of the Registry.";
                log.warn((Object)msg);
                return this;
            }
            this.handler = (Handler)handlerClass.newInstance();
            Iterator handlerProps = this.handlerConfigElement.getChildrenWithName(new QName("property"));
            while (handlerProps.hasNext()) {
                Method setter;
                String setterName;
                OMElement propElement = (OMElement)handlerProps.next();
                String propName = propElement.getAttributeValue(new QName("name"));
                String propType = propElement.getAttributeValue(new QName("type"));
                if (propType != null && "xml".equals(propType)) {
                    setterName = RegistryConfigurationProcessor.getSetterName(propName);
                    setter = handlerClass.getMethod(setterName, OMElement.class);
                    setter.invoke((Object)this.handler, propElement);
                    continue;
                }
                setterName = RegistryConfigurationProcessor.getSetterName(propName);
                setter = handlerClass.getMethod(setterName, String.class);
                String propValue = propElement.getText();
                setter.invoke((Object)this.handler, propValue);
            }
            OMElement filterElement = this.handlerConfigElement.getFirstChildWithName(new QName("filter"));
            String filterClassName = filterElement.getAttributeValue(new QName("class"));
            try {
                filterClass = RegistryUtils.loadClass(filterClassName);
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find the filter class " + filterClassName + ". " + handlerClassName + " will not be registered. All configured handler, filter and " + "edit processor classes should be in the class " + "path of the Registry.";
                log.warn((Object)msg);
                return this;
            }
            this.filter = (Filter)filterClass.newInstance();
            Iterator filterProps = filterElement.getChildrenWithName(new QName("property"));
            while (filterProps.hasNext()) {
                OMElement propElement = (OMElement)filterProps.next();
                String propName = propElement.getAttributeValue(new QName("name"));
                String propValue = propElement.getText();
                String setterName = RegistryConfigurationProcessor.getSetterName(propName);
                Method setter = filterClass.getMethod(setterName, String.class);
                setter.invoke((Object)this.filter, propValue);
            }
            if (this.customEditManager != null && (editElement = this.handlerConfigElement.getFirstChildWithName(new QName("edit"))) != null) {
                Class editProcessorClass;
                String processorKey = editElement.getAttributeValue(new QName("processor"));
                String processorClassName = editElement.getText();
                try {
                    editProcessorClass = RegistryUtils.loadClass(processorClassName);
                }
                catch (ClassNotFoundException e) {
                    String msg = "Could not find the edit processor class " + processorClassName + ". " + handlerClassName + " will not be registered. All configured handler, filter and " + "edit processor classes should be in the class " + "path of the Registry.";
                    log.warn((Object)msg);
                    return this;
                }
                EditProcessor editProcessor = (EditProcessor)editProcessorClass.newInstance();
                this.customEditManager.addProcessor(processorKey, editProcessor);
            }
            return this;
        }
    }
}

