/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.admin.privilegedaction.extension;

import java.util.ArrayList;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.admin.privilegedaction.extension.PrivilegedActionExtension;
import org.wso2.carbon.server.admin.privilegedaction.extension.PrivilegedActionExtensionException;
import org.wso2.carbon.server.admin.privilegedaction.extension.PrivilegedActionExtensionRegistry;

public class PrivilegedActionExtensionMessageReceiver
extends RPCMessageReceiver {
    private static final Log log = LogFactory.getLog(PrivilegedActionExtensionMessageReceiver.class);
    private static final boolean SKIP_SERVICE_INVOCATION = false;
    private static final boolean SKIP_LOWER_PRIORITY_EXTENSIONS = false;

    public void invokeBusinessLogic(MessageContext inMsgCtx, MessageContext outMsgCtx) throws AxisFault {
        boolean skipLowerPriorityExtensions = false;
        boolean skipServiceInvocation = false;
        int skipPriority = -1;
        ArrayList<PrivilegedActionExtension> extensions = PrivilegedActionExtensionRegistry.getPrivilegedActionExtensions(inMsgCtx);
        if (extensions != null && !extensions.isEmpty()) {
            SOAPEnvelope inEnvelope = inMsgCtx.getEnvelope();
            SOAPEnvelope outEnvelope = this.getOutEnvelope(inMsgCtx);
            for (PrivilegedActionExtension ext : extensions) {
                if (skipLowerPriorityExtensions && ext.getPriority() != skipPriority) continue;
                try {
                    outEnvelope = ext.execute(inEnvelope, outEnvelope);
                }
                catch (PrivilegedActionExtensionException e) {
                    throw new AxisFault("Error while executing the privileged action extension " + ext.getExtensionName(), (Throwable)e);
                }
            }
            outMsgCtx.setEnvelope(outEnvelope);
            if (!skipServiceInvocation) {
                super.invokeBusinessLogic(inMsgCtx, outMsgCtx);
            }
        } else {
            super.invokeBusinessLogic(inMsgCtx, outMsgCtx);
        }
    }

    private SOAPEnvelope getOutEnvelope(MessageContext inMsgCtx) {
        String soapNamespace = inMsgCtx.getEnvelope().getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        if (soapNamespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            System.out.println("Unknow soap message");
        }
        return soapFactory.getDefaultEnvelope();
    }
}

