/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.services.loggeduserinfo;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.common.LoggedUserInfo;
import org.wso2.carbon.core.services.authentication.AuthenticationAdmin;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;

public class LoggedUserInfoAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(AuthenticationAdmin.class);

    public LoggedUserInfo getUserInfo() throws Exception {
        try {
            MessageContext messageContext = MessageContext.getCurrentMessageContext();
            HttpServletRequest request = (HttpServletRequest)messageContext.getProperty("transport.http.servletRequest");
            String userName = (String)request.getSession().getAttribute("wso2carbon.admin.logged.in");
            LoggedUserInfo loggedUserInfo = new LoggedUserInfo();
            UserRealm userRealm = this.getUserRealm();
            List<String> userPermissions = this.getUserPermissions(userName, userRealm);
            String[] permissions = userPermissions.toArray(new String[userPermissions.size()]);
            loggedUserInfo.setUIPermissionOfUser(permissions);
            Date date = userRealm.getUserStoreManager().getPasswordExpirationTime(userName);
            if (date != null) {
                DateFormat timeFormat = DateFormat.getTimeInstance(3);
                DateFormat dateFormat = DateFormat.getDateInstance(2);
                String passwordExpiration = timeFormat.format(date) + " on " + dateFormat.format(date);
                loggedUserInfo.setPasswordExpiration(passwordExpiration);
            }
            return loggedUserInfo;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    private List<String> getUserPermissions(String username, UserRealm realm) throws Exception {
        AuthorizationManager authManager = realm.getAuthorizationManager();
        String[] permissions = authManager.getAllowedUIResourcesForUser(username, RegistryUtils.getUnChrootedPath((String)"/"));
        List<String> userPermissions = Arrays.asList(permissions);
        return userPermissions;
    }
}

