/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.coordination.core.services.CoordinationService;
import org.wso2.carbon.ndatasource.core.DataSourceAxis2ConfigurationContextObserver;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.securevault.SecretCallbackHandlerService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class DataSourceServiceComponent {
    private static final Log log = LogFactory.getLog(DataSourceServiceComponent.class);
    private static RegistryService registryService;
    private static RealmService realmService;
    private static CoordinationService coodinationService;
    private static SecretCallbackHandlerService secretCallbackHandlerService;
    private static ServerConfigurationService serverConfigurationService;
    private DataSourceService dataSourceService;
    private ComponentContext ctx;
    private boolean tenantUserDataSourcesInitialized;

    protected synchronized void activate(ComponentContext ctx) {
        this.ctx = ctx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent activated");
        }
        if (this.tenantUserDataSourcesInitialized) {
            this.registerServices();
        }
    }

    protected synchronized void deactivate(ComponentContext ctx) {
        this.ctx = null;
        this.tenantUserDataSourcesInitialized = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)"DataSourceServiceComponent deactivated");
        }
    }

    private void registerServices() {
        if (this.getDataSourceService() == null) {
            this.dataSourceService = new DataSourceService();
        }
        BundleContext bundleContext = this.ctx.getBundleContext();
        bundleContext.registerService(DataSourceService.class.getName(), (Object)this.getDataSourceService(), null);
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new DataSourceAxis2ConfigurationContextObserver(), null);
    }

    public DataSourceService getDataSourceService() {
        return this.dataSourceService;
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService acquired");
        }
        DataSourceServiceComponent.realmService = realmService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRealmService(RealmService realmService) {
        DataSourceServiceComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService acquired");
        }
        DataSourceServiceComponent.registryService = registryService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetRegistryService(RegistryService registryService) {
        registryService = null;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static SecretCallbackHandlerService getSecretCallbackHandlerService() {
        return secretCallbackHandlerService;
    }

    protected void setSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"SecretCallbackHandlerService acquired");
        }
        DataSourceServiceComponent.secretCallbackHandlerService = secretCallbackHandlerService;
        this.initSystemDataSources();
        this.checkInitTenantUserDataSources();
    }

    protected void unsetSecretCallbackHandlerService(SecretCallbackHandlerService secretCallbackHandlerService) {
        DataSourceServiceComponent.secretCallbackHandlerService = null;
    }

    private void initSystemDataSources() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing system data sources...");
        }
        try {
            DataSourceManager.getInstance().initSystemDataSources();
            if (log.isDebugEnabled()) {
                log.debug((Object)"System data sources successfully initialized");
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    private synchronized void checkInitTenantUserDataSources() {
        if (DataSourceServiceComponent.getRealmService() != null && DataSourceServiceComponent.getRegistryService() != null && DataSourceServiceComponent.getCoordinationService() != null && DataSourceServiceComponent.getSecretCallbackHandlerService() != null && DataSourceServiceComponent.getServerConfigurationService() != null) {
            this.initAllTenantUserDataSources();
        }
    }

    private synchronized void initAllTenantUserDataSources() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing tenant user data sources...");
            }
            DataSourceManager.getInstance().initAllTenants();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Tenant user data sources successfully initialized");
            }
            this.tenantUserDataSourcesInitialized = true;
            if (this.ctx != null) {
                this.registerServices();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in intializing system data sources: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void setCoordinationService(CoordinationService coordinationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CoordinationService acquired");
        }
        coodinationService = coordinationService;
        this.checkInitTenantUserDataSources();
    }

    protected void unsetCoordinationService(CoordinationService coordinationService) {
        coodinationService = null;
    }

    public static CoordinationService getCoordinationService() {
        return coodinationService;
    }

    public static ServerConfigurationService getServerConfigurationService() {
        return serverConfigurationService;
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        DataSourceServiceComponent.serverConfigurationService = null;
    }

    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ServerConfigurationService acquired");
        }
        DataSourceServiceComponent.serverConfigurationService = serverConfigurationService;
        this.checkInitTenantUserDataSources();
    }
}

