/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Group;
import org.wso2.carbon.coordination.core.sync.GroupEventListener;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ndatasource.common.DataSourceConstants;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.common.spi.DataSourceReader;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.DataSourceStatus;
import org.wso2.carbon.ndatasource.core.JNDIConfig;
import org.wso2.carbon.ndatasource.core.internal.DataSourceServiceComponent;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;

public class DataSourceRepository
implements GroupEventListener {
    private static Log log = LogFactory.getLog(DataSourceRepository.class);
    private int tenantId;
    private Registry registry;
    private Map<String, CarbonDataSource> dataSources;
    private Marshaller dsmMarshaller;
    private Unmarshaller dsmUnmarshaller;
    private Group syncGroup;

    public DataSourceRepository(int tenantId) throws DataSourceException {
        this.tenantId = tenantId;
        this.dataSources = new HashMap<String, CarbonDataSource>();
        try {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{DataSourceMetaInfo.class});
            this.dsmMarshaller = ctx.createMarshaller();
            this.dsmUnmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new DataSourceException("Error creating data source meta info marshaller/unmarshaller: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void initRepository() throws DataSourceException {
        this.registry = DataSourceUtils.getConfRegistryForTenant(this.getTenantId());
        this.initSyncGroup();
        this.refreshAllUserDataSources();
    }

    private Group getSyncGroup() {
        return this.syncGroup;
    }

    private void initSyncGroup() throws DataSourceException {
        if (!DataSourceServiceComponent.getCoordinationService().isEnabled()) {
            return;
        }
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
            this.syncGroup = DataSourceServiceComponent.getCoordinationService().createGroup(DataSourceConstants.DATASOURCES_SYNC_GROUP_NAME);
            this.syncGroup.setGroupEventListener((GroupEventListener)this);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in creating data source sync group: " + e.getMessage(), e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private Registry getRegistry() {
        return this.registry;
    }

    private String resourceNameFromPath(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public void refreshAllUserDataSources() throws DataSourceException {
        try {
            if (this.getRegistry().resourceExists(DataSourceConstants.DATASOURCES_REPOSITORY_BASE_PATH)) {
                String[] dsmPaths;
                org.wso2.carbon.registry.api.Collection dsCollection = (org.wso2.carbon.registry.api.Collection)this.getRegistry().get(DataSourceConstants.DATASOURCES_REPOSITORY_BASE_PATH);
                for (String dsmPath : dsmPaths = dsCollection.getChildren()) {
                    try {
                        this.refreshUserDataSource(this.resourceNameFromPath(dsmPath));
                    }
                    catch (DataSourceException e) {
                        log.error((Object)("Error in reloading data source at path '" + dsmPath + "': " + e.getMessage()), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in getting all data sources from repository: " + e.getMessage(), e);
        }
    }

    public synchronized void refreshUserDataSource(String dsName) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing data source: " + dsName));
        }
        String dsmPath = DataSourceConstants.DATASOURCES_REPOSITORY_BASE_PATH + "/" + dsName;
        try {
            DataSourceMetaInfo dsmInfo = this.getDataSourceMetaInfoFromRegistryPath(dsmPath);
            CarbonDataSource currentCDS = this.getDataSource(dsName);
            DataSourceMetaInfo currentDsmInfo = null;
            if (currentCDS != null) {
                currentDsmInfo = currentCDS.getDSMInfo();
            }
            if (DataSourceUtils.nullAllowEquals(dsmInfo, currentDsmInfo)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No change for data source: " + dsName));
                }
                return;
            }
            if (dsmInfo != null) {
                this.registerDataSource(dsmInfo);
            } else {
                this.unregisterDataSource(dsName);
            }
        }
        catch (Exception e) {
            throw new DataSourceException("Error in reloading data source '" + dsName + "' from registry: " + e.getMessage(), e);
        }
    }

    private Object createDataSourceObject(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        boolean isDataSourceFactoryReference = false;
        DataSourceReader dsReader = DataSourceManager.getInstance().getDataSourceReader(dsmInfo.getDefinition().getType());
        if (dsReader == null) {
            throw new DataSourceException("A data source reader cannot be found for the type '" + dsmInfo.getDefinition().getType() + "'");
        }
        JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
        if (jndiConfig != null) {
            isDataSourceFactoryReference = dsmInfo.getJndiConfig().isUseDataSourceFactory();
        }
        return dsReader.createDataSource(DataSourceUtils.elementToString((Element)dsmInfo.getDefinition().getDsXMLConfiguration()), isDataSourceFactoryReference);
    }

    private Context lookupJNDISubContext(Context context, String jndiName) throws DataSourceException {
        try {
            Object obj = context.lookup(jndiName);
            if (!(obj instanceof Context)) {
                throw new DataSourceException("Non JNDI context already exists at '" + context + "/" + jndiName);
            }
            return (Context)obj;
        }
        catch (NamingException e) {
            return null;
        }
    }

    private void checkAndCreateJNDISubContexts(Context context, String jndiName) throws DataSourceException {
        String[] tokens = jndiName.split("/");
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            Context tmpCtx = this.lookupJNDISubContext(context, token);
            if (tmpCtx == null) {
                try {
                    tmpCtx = context.createSubcontext(token);
                }
                catch (NamingException e) {
                    throw new DataSourceException("Error in creating JNDI subcontext '" + context + "/" + token + ": " + e.getMessage(), (Exception)e);
                }
            }
            context = tmpCtx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerJNDI(DataSourceMetaInfo dsmInfo, Object dsObject) throws DataSourceException {
        try {
            InitialContext context;
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
            JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
            if (jndiConfig == null) {
                return;
            }
            try {
                context = new InitialContext(jndiConfig.extractHashtableEnv());
            }
            catch (NamingException e) {
                throw new DataSourceException("Error creating JNDI initial context: " + e.getMessage(), (Exception)e);
            }
            this.checkAndCreateJNDISubContexts(context, jndiConfig.getName());
            try {
                context.rebind(jndiConfig.getName(), dsObject);
            }
            catch (NamingException e) {
                throw new DataSourceException("Error in binding to JNDI with name '" + jndiConfig.getName() + "' - " + e.getMessage(), (Exception)e);
            }
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterJNDI(DataSourceMetaInfo dsmInfo) {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(this.getTenantId());
            JNDIConfig jndiConfig = dsmInfo.getJndiConfig();
            if (jndiConfig == null) {
                return;
            }
            try {
                InitialContext context = new InitialContext(jndiConfig.extractHashtableEnv());
                context.unbind(jndiConfig.getName());
            }
            catch (NamingException e) {
                log.error((Object)("Error in unregistering JNDI name: " + jndiConfig.getName() + " - " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private void removePersistedDataSource(String dsName) throws DataSourceException {
        try {
            this.getRegistry().beginTransaction();
            String path = DataSourceConstants.DATASOURCES_REPOSITORY_BASE_PATH + "/" + dsName;
            if (this.getRegistry().resourceExists(path)) {
                this.getRegistry().delete(path);
            }
            this.getRegistry().commitTransaction();
        }
        catch (Exception e) {
            try {
                this.getRegistry().rollbackTransaction();
            }
            catch (RegistryException e1) {
                log.error((Object)("Error in rollback transaction in removing data source:" + e1.getMessage()), (Throwable)e1);
            }
            throw new DataSourceException("Error in removing data source: " + dsName + " - " + e.getMessage(), e);
        }
    }

    private void persistDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        try {
            dsmInfo = DataSourceUtils.secureSaveDSMInfo(dsmInfo);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getDSMMarshaller().marshal((Object)dsmInfo, (OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            Resource resource = this.getRegistry().newResource();
            resource.setContentStream((InputStream)in);
            this.getRegistry().put(DataSourceConstants.DATASOURCES_REPOSITORY_BASE_PATH + "/" + dsmInfo.getName(), (org.wso2.carbon.registry.api.Resource)resource);
        }
        catch (Exception e) {
            throw new DataSourceException("Error in persisting data source: " + dsmInfo.getName() + " - " + e.getMessage(), e);
        }
    }

    private void unregisterDataSource(String dsName) {
        CarbonDataSource cds = this.getDataSource(dsName);
        if (cds == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering data source: " + dsName));
        }
        this.unregisterJNDI(cds.getDSMInfo());
        this.dataSources.remove(dsName);
    }

    private synchronized void registerDataSource(DataSourceMetaInfo dsmInfo) {
        DataSourceStatus dsStatus;
        CarbonDataSource currentCDS = this.getDataSource(dsmInfo.getName());
        if (currentCDS != null) {
            this.unregisterDataSource(currentCDS.getDSMInfo().getName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering data source: " + dsmInfo.getName()));
        }
        Object dsObject = null;
        try {
            dsObject = this.createDataSourceObject(dsmInfo);
            this.registerJNDI(dsmInfo, dsObject);
            dsStatus = new DataSourceStatus("ACTIVE", null);
        }
        catch (Exception e) {
            String msg = "Error in registering data source: " + dsmInfo.getName() + " - " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            dsStatus = new DataSourceStatus("ERROR", msg);
        }
        CarbonDataSource cds = new CarbonDataSource(dsmInfo, dsStatus, dsObject);
        this.dataSources.put(cds.getDSMInfo().getName(), cds);
    }

    private void notifyClusterDSChange(String dsName) throws DataSourceException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Notifying cluster ds change: " + dsName + " - " + this.getSyncGroup()));
            }
            if (this.getSyncGroup() != null) {
                this.getSyncGroup().broadcast(dsName.getBytes());
            }
        }
        catch (CoordinationException e) {
            throw new DataSourceException("Error in sending data source sync message to cluster: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private DataSourceMetaInfo getDataSourceMetaInfoFromRegistryPath(String path) throws DataSourceException, Exception {
        try {
            this.getRegistry().beginTransaction();
            if (this.getRegistry().resourceExists(path)) {
                Resource resource;
                try {
                    resource = this.getRegistry().get(path);
                }
                catch (ResourceNotFoundException e) {
                    return null;
                }
                InputStream in = resource.getContentStream();
                DataSourceMetaInfo dsmInfo = (DataSourceMetaInfo)this.getDSMUnmarshaller().unmarshal(in);
                in.close();
                this.getRegistry().commitTransaction();
                return DataSourceUtils.secureLoadDSMInfo(dsmInfo, false);
            }
            return null;
        }
        catch (Exception e) {
            this.getRegistry().rollbackTransaction();
            throw e;
        }
    }

    private Unmarshaller getDSMUnmarshaller() {
        return this.dsmUnmarshaller;
    }

    private Marshaller getDSMMarshaller() {
        return this.dsmMarshaller;
    }

    public Collection<CarbonDataSource> getAllDataSources() {
        return this.dataSources.values();
    }

    public CarbonDataSource getDataSource(String dsName) {
        return this.dataSources.get(dsName);
    }

    public void addDataSource(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding data source: " + dsmInfo.getName()));
        }
        if (!dsmInfo.isSystem()) {
            this.persistDataSource(dsmInfo);
        }
        this.registerDataSource(dsmInfo);
        if (!dsmInfo.isSystem()) {
            this.notifyClusterDSChange(dsmInfo.getName());
        }
    }

    public void deleteDataSource(String dsName) throws DataSourceException {
        CarbonDataSource cds;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting data source: " + dsName));
        }
        if ((cds = this.getDataSource(dsName)) == null) {
            throw new DataSourceException("Data source does not exist: " + dsName);
        }
        if (cds.getDSMInfo().isSystem()) {
            throw new DataSourceException("System data sources cannot be deleted: " + dsName);
        }
        this.removePersistedDataSource(dsName);
        this.unregisterDataSource(dsName);
        this.notifyClusterDSChange(dsName);
    }

    public boolean testDataSourceConnection(DataSourceMetaInfo dsmInfo) throws DataSourceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Testing connection of data source: " + dsmInfo.getName()));
        }
        DataSourceReader dsReader = DataSourceManager.getInstance().getDataSourceReader(dsmInfo.getDefinition().getType());
        return dsReader.testDataSourceConnection(DataSourceUtils.elementToString((Element)dsmInfo.getDefinition().getDsXMLConfiguration()));
    }

    public void onGroupMessage(byte[] msg) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Group message received: " + new String(msg)));
            }
            this.refreshUserDataSource(new String(msg));
        }
        catch (Exception e) {
            log.error((Object)("Error in processing received data source sync message: " + e.getMessage()), (Throwable)e);
        }
    }

    public void onLeaderChange(String leaderId) {
    }

    public void onMemberArrival(String memberId) {
    }

    public void onMemberDeparture(String memberId) {
    }

    public byte[] onPeerMessage(byte[] arg0) throws CoordinationException {
        throw new CoordinationException("Data sources does not handle group RPC", CoordinationException.ExceptionCode.GENERIC_ERROR);
    }
}

