/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.file.deployer;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.persistence.ModulePersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.ServiceGroupPersistenceManager;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;

public class PersistenceMetaDataDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(PersistenceMetaDataDeployer.class);
    private AxisConfiguration axisConfig;
    String metaDataDir;
    private PersistenceFactory persistenceFactory;

    public void init(ConfigurationContext configurationContext) {
        this.axisConfig = configurationContext.getAxisConfiguration();
        try {
            this.persistenceFactory = PersistenceFactory.getInstance(this.axisConfig);
        }
        catch (AxisFault e) {
            log.error((Object)"Error obtaining persistence factory.", (Throwable)e);
        }
    }

    public void setDirectory(String directory) {
        this.metaDataDir = directory;
    }

    public void setExtension(String extension) {
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String fileName = deploymentFileData.getName();
        String name = fileName.substring(0, fileName.lastIndexOf(".xml"));
        if ("servicemetafiles".equals(this.metaDataDir)) {
            AxisServiceGroup serviceGroup;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detected Service Meta File change.." + name));
            }
            if ((serviceGroup = this.axisConfig.getServiceGroup(name)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Error getting service from axisConfig.");
                }
                return;
            }
            if (this.persistenceFactory.getServiceGroupFilePM().isUserModification(serviceGroup.getServiceGroupName())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User modified service : " + serviceGroup.getServiceGroupName()));
                }
                return;
            }
            ServiceGroupPersistenceManager serviceGroupPM = this.persistenceFactory.getServiceGroupPM();
            ServicePersistenceManager servicePM = this.persistenceFactory.getServicePM();
            try {
                serviceGroupPM.handleExistingServiceGroupInit(serviceGroup);
                Iterator itr = serviceGroup.getServices();
                while (itr.hasNext()) {
                    AxisService axisService = (AxisService)itr.next();
                    OMElement serviceEle = this.persistenceFactory.getServicePM().getService(axisService);
                    if (serviceEle == null) continue;
                    servicePM.handleExistingServiceInit(axisService);
                }
            }
            catch (AxisFault e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new DeploymentException((Throwable)e);
            }
        } else if ("modulemetafiles".equals(this.metaDataDir)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Detected Module Meta File change.." + name));
            }
            AxisModule module = this.axisConfig.getModule(name);
            String version = PersistenceUtils.getModuleVersion(module);
            try {
                OMElement moduleEle = (OMElement)this.persistenceFactory.getModuleFilePM().get(name, "/version" + PersistenceUtils.getXPathAttrPredicate("id", version));
                ModulePersistenceManager mpm = this.persistenceFactory.getModulePM();
                if (this.persistenceFactory.getModuleFilePM().isUserModification(module.getName())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("user modified module : " + module.getName()));
                    }
                    return;
                }
                mpm.handleExistingModuleInit(moduleEle, module);
            }
            catch (PersistenceDataNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void undeploy(String filePath) throws DeploymentException {
    }

    public void cleanup() throws DeploymentException {
    }
}

