/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.file.AbstractFilePersistenceManager;
import org.wso2.carbon.core.persistence.file.ResourceFileData;

public class ModuleFilePersistenceManager
extends AbstractFilePersistenceManager {
    private static final Log log = LogFactory.getLog(ModuleFilePersistenceManager.class);

    public ModuleFilePersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            URL repositoryURL = axisConfig.getRepository();
            if (repositoryURL != null) {
                String repoPath = URLDecoder.decode(axisConfig.getRepository().getPath(), "UTF-8");
                String moduleMetaFileLocation = System.getProperty("module.metafiles.location");
                if (moduleMetaFileLocation == null) {
                    moduleMetaFileLocation = "modulemetafiles";
                }
                this.metafilesDir = new File(repoPath + File.separator + moduleMetaFileLocation);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"metafiles directory URL can not bde decoded.", (Throwable)e);
            throw new AxisFault("metafiles directory URL can not bde decoded.", (Throwable)e);
        }
        if (this.metafilesDir == null) {
            log.error((Object)"metafiles directory for services must exist. ");
            throw new AxisFault("metafiles directory for services must exist. May be AxisConfiguration does not have repository url set.");
        }
    }

    @Override
    public synchronized void beginTransaction(String moduleName) throws PersistenceException {
        File moduleFile = new File(this.metafilesDir, this.getFilePathFromResourceId(moduleName));
        try {
            OMElement moduleElement = moduleFile.exists() ? PersistenceUtils.getResourceDocumentElement(moduleFile) : this.omFactory.createOMElement("module", null);
            ResourceFileData fileData = new ResourceFileData(moduleElement, moduleFile, true);
            this.resourceMap.put(moduleName, fileData);
        }
        catch (XMLStreamException e1) {
            log.error((Object)"Failed to use XMLStreamReader. Exception in beginning the transaction ", (Throwable)e1);
            throw new PersistenceException("Exception in beginning the transaction " + e1);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("File not found. Exception in beginning the transaction " + moduleFile.getAbsolutePath()), (Throwable)e);
            throw new PersistenceException("Exception in beginning the transaction", e);
        }
        catch (IOException e) {
            log.error((Object)("Exception in closing service group file " + moduleName), (Throwable)e);
            throw new PersistenceException("Exception in closing service group file", e);
        }
    }

    @Override
    public OMElement get(String moduleId) throws PersistenceDataNotFoundException {
        return (OMElement)this.get(moduleId, "/");
    }

    @Override
    public void delete(String moduleId, String xpathStr) throws PersistenceDataNotFoundException {
        ResourceFileData fileData = (ResourceFileData)this.resourceMap.get(moduleId);
        try {
            if (fileData != null && fileData.isTransactionStarted()) {
                AXIOMXPath xpathExpr = new AXIOMXPath(xpathStr);
                OMElement sgElement = fileData.getOMElement();
                OMElement el = (OMElement)xpathExpr.selectSingleNode((Object)sgElement);
                if (el != null && el.getParent() == null) {
                    fileData.setOMElement(null);
                } else if (el != null) {
                    el.detach();
                }
            } else {
                throw new PersistenceDataNotFoundException("transaction isn't started");
            }
            this.setMetaFileModification(moduleId);
        }
        catch (JaxenException e) {
            log.error((Object)("Error parsing xpath string " + moduleId + xpathStr), (Throwable)e);
            throw new PersistenceDataNotFoundException("Error parsing xpath string " + (Object)((Object)e));
        }
    }
}

