/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.CarbonAxisConfigurator;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.deployment.SynchronizeRepositoryResponse;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.TenantAxisConfigurator;

public class SynchronizeRepositoryRequest
extends ClusteringMessage {
    private int tenantId;
    private static final transient Log log = LogFactory.getLog(SynchronizeRepositoryRequest.class);

    public SynchronizeRepositoryRequest() {
    }

    public SynchronizeRepositoryRequest(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        this.updateDeploymentRepository(configContext);
        this.doDeployment(configContext);
    }

    private void doDeployment(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator = configContext.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).runDeployment();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).runDeployment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeploymentRepository(ConfigurationContext configContext) {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);
            try {
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    ((DeploymentSynchronizer)obj).update(this.tenantId);
                }
            }
            catch (Exception e) {
                log.error((Object)("Repository update failed for tenant " + this.tenantId), (Throwable)e);
                this.setRepoUpdateFailed(configContext);
            }
            finally {
                serviceTracker.close();
            }
        }
    }

    private void setRepoUpdateFailed(ConfigurationContext configContext) {
        AxisConfigurator axisConfigurator = configContext.getAxisConfiguration().getConfigurator();
        if (axisConfigurator instanceof CarbonAxisConfigurator) {
            ((CarbonAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        } else if (axisConfigurator instanceof TenantAxisConfigurator) {
            ((TenantAxisConfigurator)axisConfigurator).setRepoUpdateFailed();
        }
    }

    public ClusteringCommand getResponse() {
        return new SynchronizeRepositoryResponse();
    }
}

