/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.Axis2ModuleNotFound;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class DeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(DeploymentInterceptor.class);
    private final Map<String, Parameter> paramMap = new HashMap<String, Parameter>();
    private final HashMap<String, HashMap<String, AxisDescription>> faultyServicesDueToModules = new HashMap();
    private PersistenceFactory pf;
    private Registry registry;
    private int tenantId = -1;
    private String tenantDomain = "carbon.super";
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void init(AxisConfiguration axisConfig) {
        this.extractTenantInfo(axisConfig);
        try {
            this.pf = PersistenceFactory.getInstance(axisConfig);
            if (this.registry == null) {
                this.registry = this.dataHolder.getRegistryService().getConfigSystemRegistry();
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error while adding PersistenceFactory parameter to axisConfig", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error while obtaining registry instance for the deployment interceptor", (Throwable)e);
        }
    }

    private void extractTenantInfo(AxisConfiguration axisConfig) {
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext(axisConfig);
        this.tenantId = carbonContext.getTenantId();
        this.tenantDomain = carbonContext.getTenantDomain();
    }

    private String getTenantIdAndDomainString() {
        return this.tenantId != -1 && this.tenantId != -1234 ? " {" + this.tenantDomain + "[" + this.tenantId + "]}" : " {super-tenant}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceGroupUpdate(AxisEvent axisEvent, AxisServiceGroup axisServiceGroup) {
        block26: {
            SuperTenantCarbonContext.startTenantFlow();
            try {
                Parameter svcHistoryParam;
                SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
                carbonContext.setTenantId(this.tenantId);
                carbonContext.setTenantDomain(this.tenantDomain);
                if (SystemFilter.isFilteredOutService(axisServiceGroup)) {
                    return;
                }
                int eventType = axisEvent.getEventType();
                if (SystemFilter.isGhostServiceGroup(axisServiceGroup) && eventType != 0) {
                    return;
                }
                if (eventType == 1) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deploying service group : " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()));
                    }
                    OMElement serviceGroupOMElement = null;
                    if (this.pf.getServiceGroupFilePM().elementExists(axisServiceGroup.getServiceGroupName(), "/")) {
                        try {
                            serviceGroupOMElement = this.pf.getServiceGroupPM().getServiceGroup(axisServiceGroup.getServiceGroupName());
                        }
                        catch (Exception e) {
                            log.error((Object)("Couldn't read service group resource." + this.getTenantIdAndDomainString()), (Throwable)e);
                        }
                    }
                    if (serviceGroupOMElement == null) {
                        this.addServiceGroup(axisServiceGroup);
                        break block26;
                    }
                    try {
                        String hashFromServiceFile = CarbonUtils.computeServiceHash((AxisServiceGroup)axisServiceGroup);
                        AXIOMXPath xpathExpression = new AXIOMXPath("/@hashValue[1]");
                        OMAttribute isSuccessAttr = (OMAttribute)xpathExpression.selectSingleNode((Object)serviceGroupOMElement);
                        String hashFromMetaFile = null;
                        if (isSuccessAttr != null) {
                            hashFromMetaFile = isSuccessAttr.getAttributeValue();
                        }
                        if (hashFromServiceFile != null && hashFromMetaFile != null && !hashFromMetaFile.equals(hashFromServiceFile)) {
                            log.warn((Object)("The service artifact of the " + axisServiceGroup.getServiceGroupName() + " service group has changed. Removing all registry entries and " + "handling this as a new service addition." + this.getTenantIdAndDomainString()));
                            try {
                                this.deleteServiceGroup(axisServiceGroup);
                                this.addServiceGroup(axisServiceGroup);
                            }
                            catch (Exception e) {
                                String msg = "Unable to remove all registry entries and handle newservice addition [" + axisServiceGroup.getServiceGroupName() + "]" + this.getTenantIdAndDomainString();
                                try {
                                    this.pf.getServiceGroupFilePM().rollbackTransaction(axisServiceGroup.getServiceGroupName());
                                    log.error((Object)msg, (Throwable)e);
                                    break block26;
                                }
                                catch (Exception ex) {
                                    msg = msg + ". Unable to rollback transaction.";
                                    log.error((Object)msg, (Throwable)ex);
                                }
                            }
                            break block26;
                        }
                        try {
                            this.pf.getServiceGroupPM().handleExistingServiceGroupInit(axisServiceGroup);
                            break block26;
                        }
                        catch (Axis2ModuleNotFound e) {
                            this.addFaultyServiceDueToModule(e.getModuleName(), (AxisDescription)axisServiceGroup);
                            this.stopServiceGroup(axisServiceGroup, axisServiceGroup.getAxisConfiguration());
                            log.warn((Object)("ServiceGroup: " + axisServiceGroup.getServiceGroupName() + "is stopped due to the missing module : " + e.getModuleName() + this.getTenantIdAndDomainString()));
                            break block26;
                        }
                        catch (Exception e) {
                            String msg = "Could not handle initialization of existing service group [" + axisServiceGroup.getServiceGroupName() + "]" + this.getTenantIdAndDomainString();
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                    catch (JaxenException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    break block26;
                }
                if (eventType == 0 && ((svcHistoryParam = axisServiceGroup.getParameter("keepServiceHistory")) == null || svcHistoryParam.getValue() == null || JavaUtils.isFalse((Object)svcHistoryParam.getValue()))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing service group : " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()));
                    }
                    this.deleteServiceGroup(axisServiceGroup);
                }
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }

    private void addServiceGroup(AxisServiceGroup axisServiceGroup) {
        try {
            this.pf.getServiceGroupPM().handleNewServiceGroupAddition(axisServiceGroup);
        }
        catch (Exception e) {
            String msg = "Could not handle initialization of new service group [" + axisServiceGroup.getServiceGroupName() + "]";
            log.error((Object)msg, (Throwable)e);
        }
    }

    private void deleteServiceGroup(AxisServiceGroup axisServiceGroup) {
        try {
            this.pf.getServiceGroupPM().deleteServiceGroup(axisServiceGroup);
        }
        catch (Exception e) {
            log.error((Object)("Could not delete service group " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        block23: {
            SuperTenantCarbonContext.startTenantFlow();
            try {
                SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
                carbonContext.setTenantId(this.tenantId);
                carbonContext.setTenantDomain(this.tenantDomain);
                if (SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getParent())) {
                    return;
                }
                if (axisService.isClientSide()) {
                    return;
                }
                int eventType = axisEvent.getEventType();
                if (GhostDeployerUtils.isGhostService((AxisService)axisService) && eventType != 0) {
                    return;
                }
                String serviceName = axisService.getName();
                try {
                    OMElement service = this.pf.getServicePM().getService(axisService);
                    if (eventType == 1) {
                        if (!JavaUtils.isTrue((Object)axisService.getParameterValue("hiddenService"))) {
                            log.info((Object)("Deploying Axis2 service: " + serviceName + this.getTenantIdAndDomainString()));
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)("Deploying hidden Axis2 service : " + serviceName + this.getTenantIdAndDomainString()));
                        }
                        if (service == null) {
                            this.pf.getServicePM().handleNewServiceAddition(axisService);
                        } else {
                            this.pf.getServicePM().handleExistingServiceInit(axisService);
                        }
                        break block23;
                    }
                    if (eventType == 3) {
                        service.addAttribute("serviceActive", "true", null);
                        break block23;
                    }
                    if (eventType == 2 && service != null) {
                        service.addAttribute("serviceActive", "false", null);
                        break block23;
                    }
                    if (eventType != 0 || service == null) break block23;
                    try {
                        Parameter svcHistoryParam = axisService.getParameter("keepServiceHistory");
                        if (svcHistoryParam == null || svcHistoryParam.getValue() == null || JavaUtils.isFalse((Object)svcHistoryParam.getValue())) {
                            this.pf.getServicePM().deleteService(axisService);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Cannot delete service [" + serviceName + "]" + this.getTenantIdAndDomainString();
                        log.error((Object)msg, (Throwable)e);
                    }
                }
                catch (Axis2ModuleNotFound e) {
                    this.addFaultyServiceDueToModule(e.getModuleName(), (AxisDescription)axisService);
                    this.stopService(axisService, axisService.getAxisConfiguration());
                    log.warn((Object)("Service " + axisService.getName() + " is stopped due to the missing module: " + e.getModuleName() + this.getTenantIdAndDomainString()));
                }
                catch (Exception e) {
                    String msg = "Exception occurred while handling service update event." + this.getTenantIdAndDomainString();
                    log.error((Object)msg, (Throwable)e);
                }
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleUpdate(AxisEvent axisEvent, AxisModule axisModule) {
        block23: {
            SuperTenantCarbonContext.startTenantFlow();
            try {
                String moduleVersion;
                SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext();
                carbonContext.setTenantId(this.tenantId);
                carbonContext.setTenantDomain(this.tenantDomain);
                String moduleName = axisModule.getName();
                if (axisEvent.getEventType() != 4) break block23;
                if (axisModule.getVersion() == null) {
                    log.warn((Object)("A valid Version not found for the module : '" + moduleName + "'" + this.getTenantIdAndDomainString()));
                    moduleVersion = "undefined";
                } else {
                    moduleVersion = axisModule.getVersion().toString();
                }
                if (!SystemFilter.isFilteredOutModule(axisModule) && log.isDebugEnabled()) {
                    log.debug((Object)("Deploying Axis2 module: " + axisModule.getArchiveName() + this.getTenantIdAndDomainString()));
                }
                OMElement module = null;
                if (this.pf.getModuleFilePM().elementExists(moduleName, PersistenceUtils.getResourcePath(axisModule))) {
                    try {
                        module = (OMElement)this.pf.getModuleFilePM().get(moduleName, "/version" + PersistenceUtils.getXPathAttrPredicate("id", moduleVersion));
                    }
                    catch (Exception e) {
                        log.error((Object)("Couldn't read the module resource" + this.getTenantIdAndDomainString()), (Throwable)e);
                    }
                }
                if (module != null) {
                    try {
                        this.pf.getModulePM().handleExistingModuleInit(module, axisModule);
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not handle initialization of existing module" + this.getTenantIdAndDomainString()), (Throwable)e);
                    }
                } else {
                    try {
                        this.pf.getModulePM().handleNewModuleAddition(axisModule, moduleName, moduleVersion);
                    }
                    catch (Exception e) {
                        log.error((Object)("Could not handle addition of new module" + this.getTenantIdAndDomainString()), (Throwable)e);
                    }
                }
                HashMap<String, HashMap<String, AxisDescription>> hashMap = this.faultyServicesDueToModules;
                synchronized (hashMap) {
                    HashMap faultyServices = this.getFaultyServicesDueToModule(moduleName);
                    faultyServices = (HashMap)faultyServices.clone();
                    for (AxisDescription axisDescription : faultyServices.values()) {
                        this.removeFaultyServiceDueToModule(moduleName, (String)axisDescription.getKey());
                        try {
                            if (axisDescription instanceof AxisServiceGroup) {
                                AxisServiceGroup axisServiceGroup = (AxisServiceGroup)axisDescription;
                                this.pf.getServiceGroupPM().handleExistingServiceGroupInit(axisServiceGroup);
                                this.startServiceGroup(axisServiceGroup, axisServiceGroup.getAxisConfiguration());
                                log.info((Object)("Recovered and Deployed axis2 service group: " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()));
                                continue;
                            }
                            if (!(axisDescription instanceof AxisService)) continue;
                            AxisService axisService = (AxisService)axisDescription;
                            this.pf.getServicePM().handleExistingServiceInit(axisService);
                            this.startService(axisService, axisService.getAxisConfiguration());
                            log.info((Object)("Recovered and Deployed axis2 service: " + axisService.getName() + this.getTenantIdAndDomainString()));
                        }
                        catch (Axis2ModuleNotFound e) {
                            this.addFaultyServiceDueToModule(e.getModuleName(), axisDescription);
                        }
                        catch (Exception e) {
                            String msg = "Could not handle initialization of existing service group [" + axisDescription.getKey() + "]" + this.getTenantIdAndDomainString();
                            log.error((Object)msg, (Throwable)e);
                        }
                    }
                }
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }

    public void addParameter(Parameter parameter) throws AxisFault {
        this.paramMap.put(parameter.getName(), parameter);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.paramMap.remove(param.getName());
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String paramName) {
        return this.paramMap.get(paramName);
    }

    public ArrayList<Parameter> getParameters() {
        Collection<Parameter> collection = this.paramMap.values();
        ArrayList<Parameter> arr = new ArrayList<Parameter>();
        for (Parameter aCollection : collection) {
            arr.add(aCollection);
        }
        return arr;
    }

    public boolean isParameterLocked(String paramName) {
        return this.paramMap.get(paramName).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFaultyServiceDueToModule(String moduleName, AxisDescription axisDescription) {
        HashMap<String, HashMap<String, AxisDescription>> hashMap = this.faultyServicesDueToModules;
        synchronized (hashMap) {
            if (this.faultyServicesDueToModules.containsKey(moduleName)) {
                HashMap<String, AxisDescription> faultyServicesMap = this.faultyServicesDueToModules.get(moduleName);
                faultyServicesMap.put((String)axisDescription.getKey(), axisDescription);
            } else {
                HashMap<String, AxisDescription> faultyServicesMap = new HashMap<String, AxisDescription>();
                faultyServicesMap.put((String)axisDescription.getKey(), axisDescription);
                this.faultyServicesDueToModules.put(moduleName, faultyServicesMap);
            }
        }
    }

    private HashMap<String, AxisDescription> getFaultyServicesDueToModule(String moduleName) {
        if (this.faultyServicesDueToModules.containsKey(moduleName)) {
            return this.faultyServicesDueToModules.get(moduleName);
        }
        return new HashMap<String, AxisDescription>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFaultyServiceDueToModule(String moduleName, String serviceGroupName) {
        HashMap<String, HashMap<String, AxisDescription>> hashMap = this.faultyServicesDueToModules;
        synchronized (hashMap) {
            HashMap<String, AxisDescription> faultyServices = this.faultyServicesDueToModules.get(moduleName);
            if (faultyServices != null) {
                faultyServices.remove(serviceGroupName);
                if (faultyServices.isEmpty()) {
                    this.faultyServicesDueToModules.remove(moduleName);
                }
            }
        }
    }

    public void startServiceGroup(AxisServiceGroup serviceGroup, AxisConfiguration axisConfiguration) {
        Iterator itr = serviceGroup.getServices();
        while (itr.hasNext()) {
            this.startService((AxisService)itr.next(), axisConfiguration);
        }
    }

    public void stopServiceGroup(AxisServiceGroup serviceGroup, AxisConfiguration axisConfiguration) {
        Iterator itr = serviceGroup.getServices();
        while (itr.hasNext()) {
            this.stopService((AxisService)itr.next(), axisConfiguration);
        }
    }

    public void startService(AxisService axisService, AxisConfiguration axisConfiguration) {
        String serviceName = axisService.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activating service: " + serviceName + this.getTenantIdAndDomainString()));
        }
        try {
            axisConfiguration.startService(serviceName);
            Parameter param = axisService.getParameter("carbonFaultyService");
            if (param != null) {
                axisService.removeParameter(param);
            }
        }
        catch (AxisFault e) {
            String msg = "Cannot start service : " + serviceName + this.getTenantIdAndDomainString();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void stopService(AxisService axisService, AxisConfiguration axisConfiguration) {
        String serviceName = axisService.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating service: " + serviceName + this.getTenantIdAndDomainString()));
        }
        try {
            axisConfiguration.stopService(serviceName);
            axisService.addParameter("carbonFaultyService", (Object)"This service is cannot be started due to missing modules");
        }
        catch (AxisFault e) {
            String msg = "Cannot stop service: " + serviceName + this.getTenantIdAndDomainString();
            log.error((Object)msg, (Throwable)e);
        }
    }
}

