/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.http.HTTPConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.utils.CarbonUtils;

public abstract class AbstractAdmin {
    protected AxisConfiguration axisConfig;
    protected ConfigurationContext configurationContext;

    protected AbstractAdmin() {
        CarbonUtils.checkSecurity();
    }

    protected AbstractAdmin(AxisConfiguration axisConfig) throws Exception {
        this();
        this.axisConfig = axisConfig;
    }

    protected AxisConfiguration getAxisConfig() {
        this.checkAdminService();
        return this.axisConfig != null ? this.axisConfig : this.getConfigContext().getAxisConfiguration();
    }

    protected ConfigurationContext getConfigContext() {
        this.checkAdminService();
        if (this.configurationContext != null) {
            return this.configurationContext;
        }
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null) {
            ConfigurationContext mainConfigContext = msgContext.getConfigurationContext();
            SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext(msgContext);
            String domain = carbonContext.getTenantDomain();
            if (domain != null && !"carbon.super".equals(domain)) {
                return TenantAxisUtils.getTenantConfigurationContext(domain, mainConfigContext);
            }
            if (carbonContext.getTenantId() == -1234) {
                return mainConfigContext;
            }
            throw new UnsupportedOperationException("Tenant domain unidentified. Upstream code needs to identify & set the tenant domain & tenant ID.  The TenantDomain SOAP header could be set by the clients or tenant authentication should be carried out.");
        }
        return CarbonConfigurationContextFactory.getConfigurationContext();
    }

    protected String getTenantDomain() {
        this.checkAdminService();
        return CarbonContext.getCurrentContext().getTenantDomain();
    }

    protected void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
        this.axisConfig = configurationContext.getAxisConfiguration();
    }

    protected Registry getRegistry() {
        return this.getConfigSystemRegistry();
    }

    protected Registry getConfigSystemRegistry() {
        return (Registry)SuperTenantCarbonContext.getCurrentContext(this.getAxisConfig()).getRegistry(RegistryType.SYSTEM_CONFIGURATION);
    }

    protected Registry getConfigUserRegistry() {
        return (Registry)CarbonContext.getCurrentContext().getRegistry(RegistryType.USER_CONFIGURATION);
    }

    protected UserRealm getUserRealm() {
        return (UserRealm)CarbonContext.getCurrentContext().getUserRealm();
    }

    protected Registry getLocalRepo() {
        return (Registry)SuperTenantCarbonContext.getCurrentContext(this.getAxisConfig()).getRegistry(RegistryType.LOCAL_REPOSITORY);
    }

    @Deprecated
    protected Registry getGovernanceRegistry() {
        return this.getGovernanceUserRegistry();
    }

    protected Registry getGovernanceUserRegistry() {
        return (Registry)CarbonContext.getCurrentContext().getRegistry(RegistryType.USER_GOVERNANCE);
    }

    protected Registry getGovernanceSystemRegistry() {
        return (Registry)CarbonContext.getCurrentContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE);
    }

    protected HttpSession getHttpSession() {
        this.checkAdminService();
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSession = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSession = request.getSession();
        }
        return httpSession;
    }

    protected void setPermissionUpdateTimestamp() throws RegistryException {
        this.checkAdminService();
        Registry registry = this.getGovernanceSystemRegistry();
        Resource resource = registry.newResource();
        resource.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
        registry.put("/repository/components/org.wso2.carbon.user.mgt/updatedTime", resource);
    }

    private void checkAdminService() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        if (msgCtx == null) {
            return;
        }
        AxisService axisService = msgCtx.getAxisService();
        if (axisService.getParameter("adminService") == null) {
            throw new RuntimeException("AbstractAdmin can only be extended by Carbon admin services. " + this.getClass().getName() + " is not an admin service. Service name " + axisService.getName() + ". The service should have defined the " + "adminService" + " parameter");
        }
    }
}

