/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt.ui;

import java.rmi.RemoteException;
import javax.activation.DataHandler;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.IUserAdmin;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserStoreInfo;
import org.wso2.carbon.user.mgt.stub.ChangePasswordByUserUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.DeleteUserUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.UpdateRolesOfUserUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.UpdateUsersOfRoleUserAdminExceptionException;
import org.wso2.carbon.user.mgt.stub.UserAdminStub;
import org.wso2.carbon.user.mgt.ui.Util;

public class UserAdminClient
implements IUserAdmin {
    public static final String USER_STORE_INFO = "org.wso2.carbon.userstore.info";
    public static final String DO_USER_LIST = "org.wso2.usermgt.user.list.error";
    public static final String USER_LIST_FILTER = "org.wso2.usermgt.internal.filter";
    public static final String EMAIL_CLAIM_URI = "http://wso2.org/claims/emailaddress";
    protected UserAdminStub stub = null;
    protected static Log log = LogFactory.getLog(UserAdminClient.class);

    public UserAdminClient(String cookie, String url, String serviceName, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserAdminStub(configContext, url + serviceName);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public UserAdminClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.stub = new UserAdminStub(configContext, url + "UserAdmin");
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        try {
            this.stub.addRole(roleName, userList, permissions);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        try {
            this.stub.addUser(userName, password, roles, Util.toADBClaimValues(claims), profileName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        try {
            this.stub.changePassword(userName, newPassword);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        try {
            this.stub.deleteRole(roleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        try {
            this.stub.updateRoleName(roleName, newRoleName);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName) throws UserAdminException {
        try {
            this.stub.deleteUser(userName);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (DeleteUserUserAdminExceptionException e) {
            if (e.getFaultMessage().isUserAdminExceptionSpecified()) {
                this.handleException(e.getFaultMessage().getUserAdminException().getErrorMessage(), (Exception)((Object)e));
            }
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public FlaggedName[] getAllRolesNames() throws UserAdminException {
        try {
            return Util.toCommonFlaggedNames(this.stub.getAllRolesNames());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new FlaggedName[0];
        }
    }

    public FlaggedName[] getRolesOfUser(String userName) throws UserAdminException {
        try {
            return Util.toCommonFlaggedNames(this.stub.getRolesOfUser(userName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new FlaggedName[0];
        }
    }

    public FlaggedName[] getRolesOfCurrentUser() throws UserAdminException {
        try {
            return Util.toCommonFlaggedNames(this.stub.getRolesOfCurrentUser());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new FlaggedName[0];
        }
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter) throws UserAdminException {
        try {
            return Util.toCommonFlaggedNames(this.stub.getUsersOfRole(roleName, filter));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return new FlaggedName[0];
        }
    }

    public UserStoreInfo getUserStoreInfo() throws UserAdminException {
        try {
            return Util.toCommonUserStoreInfo(this.stub.getUserStoreInfo());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public String[] listUsers(String filter) throws UserAdminException {
        try {
            return this.stub.listUsers(filter);
        }
        catch (Exception e) {
            this.handleException("Error reading users.", e);
            return new String[0];
        }
    }

    public void updateRolesOfUser(String userName, String[] newUserList) throws UserAdminException {
        try {
            this.stub.updateRolesOfUser(userName, newUserList);
        }
        catch (Exception e) {
            UpdateRolesOfUserUserAdminExceptionException userAdminException;
            if (e instanceof UpdateRolesOfUserUserAdminExceptionException && (userAdminException = (UpdateRolesOfUserUserAdminExceptionException)e).getFaultMessage().isUserAdminExceptionSpecified()) {
                this.handleException(userAdminException.getFaultMessage().getUserAdminException().getErrorMessage(), e);
            }
            this.handleException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        try {
            this.stub.updateUsersOfRole(roleName, Util.toADBFlaggedNames(userList));
        }
        catch (Exception e) {
            UpdateUsersOfRoleUserAdminExceptionException userAdminException;
            if (e instanceof UpdateUsersOfRoleUserAdminExceptionException && (userAdminException = (UpdateUsersOfRoleUserAdminExceptionException)e).getFaultMessage().isUserAdminExceptionSpecified()) {
                this.handleException(userAdminException.getFaultMessage().getUserAdminException().getErrorMessage(), e);
            }
            this.handleException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getAllUIPermissions() throws UserAdminException {
        try {
            return Util.toCommonUIPermissionNode(this.stub.getAllUIPermissions());
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public UIPermissionNode getRolePermissions(String roleName) throws UserAdminException {
        try {
            return Util.toCommonUIPermissionNode(this.stub.getRolePermissions(roleName));
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        try {
            this.stub.setRoleUIPermission(roleName, rawResources);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void bulkImportUsers(String fileName, DataHandler handler, String defaultPassword) throws UserAdminException {
        try {
            this.stub.bulkImportUsers(fileName, handler, defaultPassword);
        }
        catch (Exception e) {
            this.handleException(e.getMessage(), e);
        }
    }

    public void changePasswordByUser(String oldPassword, String newPassword) throws UserAdminException {
        try {
            this.stub.changePasswordByUser(oldPassword, newPassword);
        }
        catch (RemoteException e) {
            this.handleException(e.getMessage(), e);
        }
        catch (ChangePasswordByUserUserAdminExceptionException e) {
            if (e.getFaultMessage().getUserAdminException() != null) {
                String errorMessage = e.getFaultMessage().getUserAdminException().getErrorMessage();
                this.handleException(errorMessage, (Exception)((Object)e));
            }
            this.handleException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String[] handleException(String msg, Exception e) throws UserAdminException {
        log.error((Object)msg, (Throwable)e);
        throw new UserAdminException(msg, (Throwable)e);
    }
}

