/*
 * Decompiled with CFR 0.152.
 */
package org.h2.schema;

import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.table.Table;

public class Sequence
extends SchemaObjectBase {
    public static final int DEFAULT_CACHE_SIZE = 32;
    private long value = 1L;
    private long valueWithMargin;
    private long increment = 1L;
    private long cacheSize = 32L;
    private boolean belongsToTable;

    public Sequence(Schema schema, int n, String string, boolean bl) {
        this.initSchemaObjectBase(schema, n, string, "sequence");
        this.belongsToTable = bl;
    }

    public synchronized void setStartValue(long l) {
        this.value = l;
        this.valueWithMargin = l;
    }

    public boolean getBelongsToTable() {
        return this.belongsToTable;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long l) {
        if (l == 0L) {
            throw DbException.get(90008, "0", "INCREMENT");
        }
        this.increment = l;
    }

    @Override
    public String getDropSQL() {
        if (this.getBelongsToTable()) {
            return null;
        }
        return "DROP SEQUENCE IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        throw DbException.throwInternalError();
    }

    @Override
    public synchronized String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE SEQUENCE ");
        stringBuilder.append(this.getSQL()).append(" START WITH ").append(this.value);
        if (this.increment != 1L) {
            stringBuilder.append(" INCREMENT BY ").append(this.increment);
        }
        if (this.cacheSize != 32L) {
            stringBuilder.append(" CACHE ").append(this.cacheSize);
        }
        if (this.belongsToTable) {
            stringBuilder.append(" BELONGS_TO_TABLE");
        }
        return stringBuilder.toString();
    }

    public synchronized long getNext(Session session) {
        if (this.increment > 0L && this.value >= this.valueWithMargin || this.increment < 0L && this.value <= this.valueWithMargin) {
            this.valueWithMargin += this.increment * this.cacheSize;
            this.flush(session);
        }
        long l = this.value;
        this.value += this.increment;
        return l;
    }

    public void flushWithoutMargin() {
        if (this.valueWithMargin != this.value) {
            this.valueWithMargin = this.value;
            this.flush(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush(Session session) {
        Session session2 = this.database.getSystemSession();
        if (session == null || !this.database.isSysTableLocked()) {
            session = session2;
        }
        Session session3 = session;
        synchronized (session3) {
            long l = this.value;
            try {
                this.value = this.valueWithMargin;
                this.database.update(session, this);
            }
            finally {
                this.value = l;
            }
            if (session == session2) {
                session2.commit(false);
            }
        }
    }

    public void close() {
        this.flushWithoutMargin();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.database.removeMeta(session, this.getId());
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public synchronized long getCurrentValue() {
        return this.value - this.increment;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(long l) {
        this.cacheSize = l;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }
}

