/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jaqu.bytecode;

import org.h2.jaqu.Query;
import org.h2.jaqu.SQLStatement;
import org.h2.jaqu.bytecode.Constant;

public class ConstantNumber
implements Constant {
    private final String value;
    private final Constant.Type type;
    private final long longValue;

    private ConstantNumber(String string, long l, Constant.Type type) {
        this.value = string;
        this.longValue = l;
        this.type = type;
    }

    static ConstantNumber get(String string) {
        return new ConstantNumber(string, 0L, Constant.Type.STRING);
    }

    static ConstantNumber get(int n) {
        return new ConstantNumber("" + n, n, Constant.Type.INT);
    }

    static ConstantNumber get(long l) {
        return new ConstantNumber("" + l, l, Constant.Type.LONG);
    }

    static ConstantNumber get(String string, long l, Constant.Type type) {
        return new ConstantNumber(string, l, type);
    }

    @Override
    public int intValue() {
        return (int)this.longValue;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public <T> void appendSQL(SQLStatement sQLStatement, Query<T> query) {
        sQLStatement.appendSQL(this.toString());
    }

    @Override
    public Constant.Type getType() {
        return this.type;
    }
}

