/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.mgt.UserRealmProxy;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.IUserAdmin;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserStoreInfo;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;

public class UserAdmin
extends AbstractAdmin
implements IUserAdmin {
    private static Log log = LogFactory.getLog(UserAdmin.class);

    @Override
    public String[] listUsers(String filter) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        return userAdminCore.listUsers(filter);
    }

    @Override
    public FlaggedName[] getAllRolesNames() throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        FlaggedName[] roleNames = userAdminCore.getAllRolesNames();
        Arrays.sort(roleNames, new Comparator<FlaggedName>(){

            @Override
            public int compare(FlaggedName o1, FlaggedName o2) {
                return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
            }
        });
        return roleNames;
    }

    @Override
    public UserStoreInfo getUserStoreInfo() throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        return userAdminCore.getUserStoreInfo();
    }

    @Override
    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.addUser(userName, password, roles, claims, profileName);
    }

    @Override
    public void changePassword(String userName, String newPassword) throws UserAdminException {
        UserStoreInfo userStoreInfo = this.getUserStoreInfo();
        if (null != userStoreInfo) {
            if (userStoreInfo.isPasswordsExternallyManaged()) {
                throw new UserAdminException("Passwords are managed externally. Therefore cannot change password.");
            }
        } else {
            throw new UserAdminException("An error occurred while changing the password. The UserStoreInfo object is null");
        }
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.changePassword(userName, newPassword);
    }

    @Override
    public void deleteUser(String userName) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.deleteUser(userName, super.getConfigSystemRegistry());
    }

    @Override
    public void addRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.addRole(roleName, userList, permissions);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public void deleteRole(String roleName) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.deleteRole(roleName);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.updateRoleName(roleName, newRoleName);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public FlaggedName[] getUsersOfRole(String roleName, String filter) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        return userAdminCore.getUsersOfRole(roleName, filter);
    }

    @Override
    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.updateUsersOfRole(roleName, userList);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public FlaggedName[] getRolesOfUser(String userName) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        return userAdminCore.getRolesOfUser(userName);
    }

    @Override
    public FlaggedName[] getRolesOfCurrentUser() throws UserAdminException {
        return this.getRolesOfUser(CarbonContext.getCurrentContext().getUsername());
    }

    @Override
    public void updateRolesOfUser(String userName, String[] newUserList) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.updateRolesOfUser(userName, newUserList);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public UIPermissionNode getAllUIPermissions() throws UserAdminException {
        try {
            UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            return userAdminCore.getAllUIPermissions(tenantId, (Registry)UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException();
        }
    }

    @Override
    public UIPermissionNode getRolePermissions(String roleName) throws UserAdminException {
        try {
            UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            return userAdminCore.getRolePermissions(roleName, tenantId, (Registry)UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException();
        }
    }

    @Override
    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        userAdminCore.setRoleUIPermission(roleName, rawResources);
        this.setPermissionUpdateTimestampUserAdmin();
    }

    @Override
    public void bulkImportUsers(String fileName, DataHandler handler, String defaultPassword) throws UserAdminException {
        if (fileName == null || handler == null || defaultPassword == null) {
            throw new UserAdminException("Required data not provided");
        }
        try {
            UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
            InputStream inStream = handler.getInputStream();
            userAdminCore.bulkImportUsers(fileName, inStream, defaultPassword);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException();
        }
    }

    @Override
    public void changePasswordByUser(String oldPassword, String newPassword) throws UserAdminException, AxisFault {
        UserStoreInfo userStoreInfo = this.getUserStoreInfo();
        if (null != userStoreInfo) {
            if (userStoreInfo.isPasswordsExternallyManaged()) {
                throw new UserAdminException("Passwords are managed externally. Therefore cannot change password.");
            }
        } else {
            throw new UserAdminException("An error occurred while changing the password. The UserStoreInfo object is null");
        }
        UserRealmProxy userAdminCore = new UserRealmProxy(super.getUserRealm());
        try {
            userAdminCore.changePasswordByUser(oldPassword, newPassword);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private void setPermissionUpdateTimestampUserAdmin() throws UserAdminException {
        try {
            super.setPermissionUpdateTimestamp();
        }
        catch (RegistryException e) {
            throw new UserAdminException("An error occurred while saving the timestamp", e);
        }
    }
}

