/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.relaxng;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CClassInfoParent;
import com.sun.tools.xjc.model.CEnumConstant;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.TypeUse;
import com.sun.tools.xjc.reader.relaxng.ContentModelBinder;
import com.sun.tools.xjc.reader.relaxng.DatatypeLib;
import com.sun.tools.xjc.reader.relaxng.DefineFinder;
import com.sun.tools.xjc.reader.relaxng.TypeUseBinder;
import com.sun.xml.bind.api.impl.NameConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.kohsuke.rngom.digested.DChoicePattern;
import org.kohsuke.rngom.digested.DDefine;
import org.kohsuke.rngom.digested.DElementPattern;
import org.kohsuke.rngom.digested.DPattern;
import org.kohsuke.rngom.digested.DPatternWalker;
import org.kohsuke.rngom.digested.DRefPattern;
import org.kohsuke.rngom.digested.DValuePattern;
import org.kohsuke.rngom.nc.NameClass;

public final class RELAXNGCompiler {
    final DPattern grammar;
    final Set<DDefine> defs;
    final Options opts;
    final Model model;
    final JPackage pkg;
    final Map<String, DatatypeLib> datatypes = new HashMap<String, DatatypeLib>();
    final Map<DPattern, CTypeInfo[]> classes = new HashMap<DPattern, CTypeInfo[]>();
    final Map<CClassInfo, DPattern> bindQueue = new HashMap<CClassInfo, DPattern>();
    final TypeUseBinder typeUseBinder = new TypeUseBinder(this);

    public static Model build(DPattern grammar, JCodeModel codeModel, Options opts) {
        RELAXNGCompiler compiler = new RELAXNGCompiler(grammar, codeModel, opts);
        compiler.compile();
        return compiler.model;
    }

    public RELAXNGCompiler(DPattern grammar, JCodeModel codeModel, Options opts) {
        this.grammar = grammar;
        this.opts = opts;
        this.model = new Model(opts, codeModel, NameConverter.smart, opts.classNameAllocator, null);
        this.datatypes.put("", DatatypeLib.BUILTIN);
        this.datatypes.put("http://www.w3.org/2001/XMLSchema-datatypes", DatatypeLib.XMLSCHEMA);
        DefineFinder deff = new DefineFinder();
        grammar.accept(deff);
        this.defs = deff.defs;
        this.pkg = opts.defaultPackage2 != null ? codeModel._package(opts.defaultPackage2) : (opts.defaultPackage != null ? codeModel._package(opts.defaultPackage) : codeModel.rootPackage());
    }

    private void compile() {
        this.promoteElementDefsToClasses();
        this.promoteTypeSafeEnums();
        this.promoteTypePatternsToClasses();
        for (Map.Entry<CClassInfo, DPattern> e : this.bindQueue.entrySet()) {
            this.bindContentModel(e.getKey(), e.getValue());
        }
    }

    private void bindContentModel(CClassInfo clazz, DPattern pattern) {
        pattern.accept(new ContentModelBinder(this, clazz));
    }

    private void promoteTypeSafeEnums() {
        ArrayList<CEnumConstant> members = new ArrayList<CEnumConstant>();
        block0: for (DDefine def : this.defs) {
            TypeUse use;
            DPattern p = def.getPattern();
            if (!(p instanceof DChoicePattern)) continue;
            DChoicePattern cp = (DChoicePattern)p;
            members.clear();
            DValuePattern vp = null;
            for (DPattern child : cp) {
                if (!(child instanceof DValuePattern)) continue block0;
                DValuePattern c = (DValuePattern)child;
                if (vp == null) {
                    vp = c;
                } else if (!vp.getDatatypeLibrary().equals(c.getDatatypeLibrary()) || !vp.getType().equals(c.getType())) continue block0;
                members.add(new CEnumConstant(this.model.getNameConverter().toConstantName(c.getValue()), null, c.getValue(), c.getLocation()));
            }
            if (members.isEmpty()) continue;
            CNonElement base = CBuiltinLeafInfo.STRING;
            DatatypeLib lib = this.datatypes.get(vp.getNs());
            if (lib != null && (use = lib.get(vp.getType())) instanceof CNonElement) {
                base = (CNonElement)use;
            }
            CEnumLeafInfo xducer = new CEnumLeafInfo(this.model, null, new CClassInfoParent.Package(this.pkg), def.getName(), base, new ArrayList<CEnumConstant>(members), null, null, cp.getLocation());
            this.classes.put(cp, new CTypeInfo[]{xducer});
        }
    }

    private void promoteElementDefsToClasses() {
        for (DDefine def : this.defs) {
            DPattern p = def.getPattern();
            if (!(p instanceof DElementPattern)) continue;
            DElementPattern ep = (DElementPattern)p;
            this.mapToClass(ep);
        }
        this.grammar.accept(new DPatternWalker(){

            public Void onRef(DRefPattern p) {
                return null;
            }

            public Void onElement(DElementPattern p) {
                RELAXNGCompiler.this.mapToClass(p);
                return null;
            }
        });
    }

    private void mapToClass(DElementPattern p) {
        NameClass nc = p.getName();
        if (nc.isOpen()) {
            return;
        }
        Set<QName> names = nc.listNames();
        CClassInfo[] types = new CClassInfo[names.size()];
        int i = 0;
        for (QName n : names) {
            String name = this.model.getNameConverter().toClassName(n.getLocalPart());
            int n2 = i++;
            CClassInfo cClassInfo = new CClassInfo(this.model, this.pkg, name, p.getLocation(), null, n, null, null);
            types[n2] = cClassInfo;
            this.bindQueue.put(cClassInfo, p.getChild());
        }
        this.classes.put(p, types);
    }

    private void promoteTypePatternsToClasses() {
    }
}

