/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader;

import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.reader.Messages;
import com.sun.tools.xjc.reader.Ring;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;

public final class ModelChecker {
    private final Model model = Ring.get(Model.class);
    private final ErrorReceiver errorReceiver = Ring.get(ErrorReceiver.class);

    public void check() {
        for (CClassInfo ci : this.model.beans().values()) {
            this.check(ci);
        }
    }

    private void check(CClassInfo ci) {
        List<CPropertyInfo> props = ci.getProperties();
        HashMap<QName, CPropertyInfo> collisionTable = new HashMap<QName, CPropertyInfo>();
        block0: for (int i = 0; i < props.size(); ++i) {
            CPropertyInfo p1 = props.get(i);
            if (p1.getName(true).equals("Class")) {
                this.errorReceiver.error(p1.locator, Messages.PROPERTY_CLASS_IS_RESERVED.format(new Object[0]));
                continue;
            }
            QName n = p1.collectElementNames(collisionTable);
            if (n != null) {
                CPropertyInfo p2 = (CPropertyInfo)collisionTable.get(n);
                this.errorReceiver.error(p1.locator, Messages.DUPLICATE_ELEMENT.format(n));
                this.errorReceiver.error(p2.locator, Messages.ERR_RELEVANT_LOCATION.format(new Object[0]));
            }
            for (int j = i + 1; j < props.size(); ++j) {
                if (this.checkPropertyCollision(p1, props.get(j))) continue block0;
            }
            for (CClassInfo c = ci.getBaseClass(); c != null; c = c.getBaseClass()) {
                for (CPropertyInfo p2 : c.getProperties()) {
                    if (!this.checkPropertyCollision(p1, p2)) continue;
                    continue block0;
                }
            }
        }
    }

    private boolean checkPropertyCollision(CPropertyInfo p1, CPropertyInfo p2) {
        if (!p1.getName(true).equals(p2.getName(true))) {
            return false;
        }
        this.errorReceiver.error(p1.locator, Messages.DUPLICATE_PROPERTY.format(p1.getName(true)));
        this.errorReceiver.error(p2.locator, Messages.ERR_RELEVANT_LOCATION.format(new Object[0]));
        return true;
    }
}

