/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.application.deployer.handler;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.application.deployer.internal.AppDeployerServiceComponent;
import org.wso2.carbon.utils.CarbonUtils;

public class DefaultAppDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(DefaultAppDeployer.class);
    public static final String AAR_TYPE = "service/axis2";
    public static final String DS_TYPE = "service/dataservice";
    public static final String BUNDLE_TYPE = "bundle";
    public static final String DS_DIR = "dataservices";
    private Map<String, Boolean> acceptanceList = null;

    @Override
    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List<Artifact.Dependency> dependencies = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.deployRecursively(dependencies, axisConfig);
    }

    @Override
    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) {
        List<Artifact.Dependency> dependencies = carbonApp.getAppConfig().getApplicationArtifact().getDependencies();
        this.undeployRecursively(dependencies, axisConfig);
    }

    private void installBundle(String bundlePath) {
        String bundlePathFormatted = AppDeployerUtils.formatPath(bundlePath);
        bundlePathFormatted = bundlePathFormatted.startsWith("/") ? "file://" + bundlePathFormatted : "file:///" + bundlePathFormatted;
        try {
            Bundle bundle = AppDeployerServiceComponent.getBundleContext().installBundle(bundlePathFormatted);
            bundle.start();
        }
        catch (BundleException e) {
            log.error((Object)("Error while installing bundle : " + bundlePathFormatted));
        }
    }

    private void deployRecursively(List<Artifact.Dependency> deps, AxisConfiguration axisConfig) {
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dependency : deps) {
            String destPath;
            Artifact artifact = dependency.getArtifact();
            if (artifact == null) continue;
            if (!this.isAccepted(artifact.getType())) {
                log.warn((Object)("Can't deploy artifact : " + artifact.getName() + " of type : " + artifact.getType() + ". Required features are not installed in the system"));
                continue;
            }
            if (AAR_TYPE.equals(artifact.getType())) {
                destPath = repo + File.separator + CarbonUtils.getAxis2ServicesDir((AxisConfiguration)axisConfig);
            } else if (DS_TYPE.equals(artifact.getType())) {
                destPath = repo + File.separator + DS_DIR;
            } else if ("carbon/application".equals(artifact.getType())) {
                destPath = repo + File.separator + "carbonapps";
            } else {
                if (!artifact.getType().startsWith("lib/") || AppDeployerUtils.getTenantId(axisConfig) != -1234) continue;
                destPath = CarbonUtils.getCarbonOSGiDropinsDir();
            }
            List<CappFile> files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)(artifact.getType() + " type must have a single file to " + "be deployed. But " + files.size() + " files found."));
                continue;
            }
            String fileName = artifact.getFiles().get(0).getName();
            String artifactPath = artifact.getExtractedPath() + File.separator + fileName;
            AppDeployerUtils.createDir(destPath);
            String destFilePath = destPath + File.separator + fileName;
            AppDeployerUtils.copyFile(artifactPath, destFilePath);
            if ((artifact.getType().startsWith("lib/") || BUNDLE_TYPE.equals(artifact.getType())) && AppDeployerUtils.getTenantId(axisConfig) == -1234) {
                this.installBundle(destFilePath);
                artifact.setRuntimeObjectName(fileName);
            }
            this.deployRecursively(artifact.getDependencies(), axisConfig);
        }
    }

    private void undeployRecursively(List<Artifact.Dependency> deps, AxisConfiguration axisConfig) {
        String repo = axisConfig.getRepository().getPath();
        for (Artifact.Dependency dependency : deps) {
            String destPath;
            Artifact artifact = dependency.getArtifact();
            if (artifact == null) continue;
            if (AAR_TYPE.equals(artifact.getType())) {
                destPath = repo + File.separator + CarbonUtils.getAxis2ServicesDir((AxisConfiguration)axisConfig);
            } else if (DS_TYPE.equals(artifact.getType())) {
                destPath = repo + File.separator + DS_DIR;
            } else if ("carbon/application".equals(artifact.getType())) {
                destPath = repo + File.separator + "carbonapps";
            } else {
                if (artifact.getType() == null || !artifact.getType().startsWith("lib/") && !BUNDLE_TYPE.equals(artifact.getType()) || AppDeployerUtils.getTenantId(axisConfig) != -1234) continue;
                destPath = CarbonUtils.getCarbonOSGiDropinsDir();
            }
            List<CappFile> files = artifact.getFiles();
            if (files.size() != 1) {
                log.error((Object)(artifact.getType() + " type must have a single file. But " + files.size() + " files found."));
                continue;
            }
            String fileName = artifact.getFiles().get(0).getName();
            String artifactPath = destPath + File.separator + fileName;
            File artifactFile = new File(artifactPath);
            if (artifactFile.exists() && !artifactFile.delete()) {
                log.warn((Object)("Couldn't delete App artifact file : " + artifactPath));
            }
            this.undeployRecursively(artifact.getDependencies(), axisConfig);
        }
    }

    private boolean isAccepted(String serviceType) {
        Boolean acceptance;
        if (this.acceptanceList == null) {
            this.acceptanceList = AppDeployerUtils.buildAcceptanceList(AppDeployerServiceComponent.getRequiredFeatures());
        }
        return (acceptance = this.acceptanceList.get(serviceType)) == null || acceptance != false;
    }
}

