/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.net.URL;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class TransportAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(TransportAxis2ConfigurationContextObserver.class);
    private String transport;
    private URL configFileURL;

    public TransportAxis2ConfigurationContextObserver(String transport, URL configFileURL) {
        this.transport = transport;
        this.configFileURL = configFileURL;
    }

    public void createdConfigurationContext(ConfigurationContext configContext) {
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        try {
            new TransportPersistenceManager(axisConfig).saveTransportConfiguration(this.transport, this.configFileURL);
        }
        catch (Exception e) {
            log.error((Object)("Cannot persist transport " + this.transport + " with config " + this.configFileURL + this.getTenantIdAndDomainString(axisConfig)));
        }
    }

    private String getTenantIdAndDomainString(AxisConfiguration axisConfig) {
        SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext(axisConfig);
        int tenantId = carbonContext.getTenantId();
        String tenantDomain = carbonContext.getTenantDomain();
        return tenantId != -1 && tenantId != -1234 ? " {" + tenantDomain + "[" + tenantId + "]}" : " {super-tenant}";
    }

    public void terminatingConfigurationContext(ConfigurationContext configCtx) {
    }

    public void terminatedConfigurationContext(ConfigurationContext configCtx) {
    }
}

