/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Element;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.core.transports.metering.MeteredServletRequest;
import org.wso2.carbon.core.transports.metering.MeteredServletResponse;
import org.wso2.carbon.core.transports.metering.RequestDataPersister;

public class CarbonServlet
extends AxisServlet {
    private static final long serialVersionUID = 3460108128756524161L;
    private Map<String, HttpGetRequestProcessor> getRequestProcessors = new LinkedHashMap<String, HttpGetRequestProcessor>();
    private static final QName ITEM_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Item");
    private static final QName CLASS_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Class");
    private static final Log log = LogFactory.getLog(CarbonServlet.class);

    public CarbonServlet(ConfigurationContext configurationContext) {
        this.configContext = configurationContext;
    }

    public void init(ServletConfig config) throws ServletException {
        this.axisConfiguration = this.configContext.getAxisConfiguration();
        this.servletConfig = config;
        this.populateGetRequestProcessors();
        this.configContext.setProperty("GETRequestProcessorMap", this.getRequestProcessors);
        this.initParams();
    }

    private void populateGetRequestProcessors() throws ServletException {
        try {
            OMElement docEle = XMLUtils.toOM((Element)CarbonCoreDataHolder.getInstance().getServerConfigurationService().getDocumentElement());
            if (docEle != null) {
                SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
                nsCtx.addNamespace("wsas", "http://wso2.org/projects/carbon/carbon.xml");
                AXIOMXPath xp = new AXIOMXPath("//wsas:HttpGetRequestProcessors/wsas:Processor");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                List nodeList = xp.selectNodes((Object)docEle);
                for (Object aNodeList : nodeList) {
                    OMElement processorEle = (OMElement)aNodeList;
                    OMElement itemEle = processorEle.getFirstChildWithName(ITEM_QN);
                    if (itemEle == null) {
                        throw new ServletException("Required element, 'Item' not found!");
                    }
                    OMElement classEle = processorEle.getFirstChildWithName(CLASS_QN);
                    if (classEle == null) {
                        throw new ServletException("Required element, 'Class' not found!");
                    }
                    HttpGetRequestProcessor processor = (HttpGetRequestProcessor)Class.forName(classEle.getText().trim()).newInstance();
                    this.getRequestProcessors.put(itemEle.getText().trim(), processor);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Cannot populate HTTPGetRequestProcessors", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.initContextRoot(request);
        boolean isRequestHandled = false;
        try {
            String queryString = request.getQueryString();
            if (queryString != null) {
                for (String item : this.getRequestProcessors.keySet()) {
                    if (queryString.indexOf(item) != 0 || !queryString.equals(item) && queryString.indexOf(38) != item.length() && queryString.indexOf(61) != item.length()) continue;
                    this.processWithGetProcessor(request, response, item);
                    isRequestHandled = true;
                    break;
                }
            }
            if (!isRequestHandled) {
                this.handleRestRequest(request, response);
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithGetProcessor(HttpServletRequest request, HttpServletResponse response, String item) throws Exception {
        OverflowBlob temporaryData = new OverflowBlob(256, 4048, "_servlet", ".dat");
        try {
            CarbonHttpRequest carbonHttpRequest = new CarbonHttpRequest("GET", request.getRequestURI(), request.getRequestURL().toString());
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                Object name = names.nextElement();
                if (name == null || !(name instanceof String)) continue;
                carbonHttpRequest.setParameter((String)name, request.getParameter((String)name));
            }
            carbonHttpRequest.setContextPath(request.getContextPath());
            carbonHttpRequest.setQueryString(request.getQueryString());
            CarbonHttpResponse carbonHttpResponse = new CarbonHttpResponse((OutputStream)temporaryData.getOutputStream());
            this.getRequestProcessors.get(item).process(carbonHttpRequest, carbonHttpResponse, this.configContext);
            Map<String, String> responseHeaderMap = carbonHttpResponse.getHeaders();
            Iterator<Map.Entry<String, String>> i$ = responseHeaderMap.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, String> obj;
                Map.Entry<String, String> entry = obj = i$.next();
                response.setHeader(entry.getKey().toString(), entry.getValue().toString());
            }
            response.setStatus(carbonHttpResponse.getStatusCode());
            if (carbonHttpResponse.isError()) {
                if (carbonHttpResponse.getStatusMessage() != null) {
                    response.sendError(carbonHttpResponse.getStatusCode(), carbonHttpResponse.getStatusMessage());
                } else {
                    response.sendError(carbonHttpResponse.getStatusCode());
                }
            }
            if (carbonHttpResponse.isRedirect()) {
                response.sendRedirect(carbonHttpResponse.getRedirect());
            }
            if (carbonHttpResponse.getHeaders().get("Content-Type") != null) {
                response.setContentType(carbonHttpResponse.getHeaders().get("Content-Type"));
            }
            temporaryData.writeTo((OutputStream)response.getOutputStream());
        }
        finally {
            temporaryData.release();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MeteredServletRequest wrappedRequest = new MeteredServletRequest(request);
        MeteredServletResponse wrappedResponse = new MeteredServletResponse(response);
        super.doPost((HttpServletRequest)wrappedRequest, (HttpServletResponse)wrappedResponse);
        this.persistRequestData(wrappedRequest, wrappedResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistRequestData(MeteredServletRequest wrappedRequest, MeteredServletResponse wrappedResponse) {
        RequestDataPersister requestDataPersister = null;
        ServiceTracker meteringDataPersistTracker = new ServiceTracker(CarbonCoreDataHolder.getInstance().getBundleContext(), RequestDataPersister.class.getName(), null);
        meteringDataPersistTracker.open();
        try {
            requestDataPersister = (RequestDataPersister)meteringDataPersistTracker.getService();
        }
        finally {
            meteringDataPersistTracker.close();
        }
        if (requestDataPersister != null) {
            requestDataPersister.persist(wrappedRequest, wrappedResponse);
        }
    }

    protected void handleRestRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.disableREST) {
            new AxisServlet.RestRequestProcessor((AxisServlet)this, "GET", request, response).processURLRequest();
        } else {
            this.showRestDisabledErrorMessage(response);
        }
    }

    public void addGetRequestProcessor(String key, HttpGetRequestProcessor processor) {
        this.getRequestProcessors.put(key, processor);
    }

    public void removeGetRequestProcessor(String key) {
        this.getRequestProcessors.remove(key);
    }
}

