/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.DiscoveryService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.ServerRestartHandler;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.init.CarbonServerManager;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class CarbonCoreServiceComponent {
    private static Log log = LogFactory.getLog(CarbonCoreServiceComponent.class);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static List<ServerShutdownHandler> shutdownHandlers = new ArrayList<ServerShutdownHandler>();
    private static List<ServerRestartHandler> restartHandlers = new ArrayList<ServerRestartHandler>();
    private CarbonServerManager carbonServerManager;

    protected void activate(ComponentContext ctxt) {
        try {
            this.carbonServerManager = new CarbonServerManager();
            this.carbonServerManager.start(ctxt.getBundleContext());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Core bundle ", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        try {
            this.carbonServerManager.stop();
        }
        catch (Throwable e) {
            log.error((Object)"Failed clean up Carbon core", e);
        }
        try {
            if ("false".equals(this.dataHolder.getServerConfigurationService().getFirstProperty("RequireCarbonServlet"))) {
                return;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error while retrieving serverConfiguration instance", (Throwable)e);
        }
        log.debug((Object)"Carbon Core bundle is deactivated ");
    }

    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(null);
    }

    protected void setRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(null);
    }

    protected void setHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    protected void setDiscoveryService(DiscoveryService discoveryService) {
        CarbonContextHolder.setDiscoveryServiceProvider((DiscoveryService)discoveryService);
    }

    protected void unsetDiscoveryService(DiscoveryService discoveryService) {
        CarbonContextHolder.setDiscoveryServiceProvider(null);
    }

    protected void addServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.add(shutdownHandler);
    }

    protected void removeServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.remove(shutdownHandler);
    }

    protected void addServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.add(restartHandler);
    }

    protected void removeServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.remove(restartHandler);
    }

    public static void shutdown() {
        for (ServerShutdownHandler shutdownHandler : shutdownHandlers) {
            shutdownHandler.invoke();
        }
    }

    public static void restart() {
        for (ServerRestartHandler restartHandler : restartHandlers) {
            restartHandler.invoke();
        }
    }
}

