/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.internalizer;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.SAXParseException2;
import com.sun.tools.xjc.ErrorReceiver;
import com.sun.tools.xjc.reader.internalizer.DOMForest;
import com.sun.tools.xjc.reader.internalizer.Messages;
import com.sun.tools.xjc.reader.internalizer.NamespaceContextImpl;
import com.sun.tools.xjc.reader.internalizer.SCDBasedBindingSet;
import com.sun.tools.xjc.util.DOMUtils;
import com.sun.xml.bind.v2.util.EditDistance;
import com.sun.xml.xsom.SCD;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Internalizer {
    private static final XPathFactory xpf = XPathFactory.newInstance();
    private final XPath xpath = xpf.newXPath();
    private final DOMForest forest;
    private ErrorReceiver errorHandler;
    private boolean enableSCD;
    private static final String EXTENSION_PREFIXES = "extensionBindingPrefixes";

    static SCDBasedBindingSet transform(DOMForest forest, boolean enableSCD) {
        return new Internalizer(forest, enableSCD).transform();
    }

    private Internalizer(DOMForest forest, boolean enableSCD) {
        this.errorHandler = forest.getErrorHandler();
        this.forest = forest;
        this.enableSCD = enableSCD;
    }

    private SCDBasedBindingSet transform() {
        HashMap<Element, Node> targetNodes = new HashMap<Element, Node>();
        SCDBasedBindingSet scd = new SCDBasedBindingSet(this.forest);
        for (Element jaxbBindings : this.forest.outerMostBindings) {
            this.buildTargetNodeMap(jaxbBindings, jaxbBindings, null, targetNodes, scd);
        }
        for (Element jaxbBindings : this.forest.outerMostBindings) {
            this.move(jaxbBindings, targetNodes);
        }
        return scd;
    }

    private void validate(Element bindings) {
        NamedNodeMap atts = bindings.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (a.getNamespaceURI() == null && !a.getLocalName().equals("node") && !a.getLocalName().equals("schemaLocation") && !a.getLocalName().equals("scd")) continue;
        }
    }

    private void buildTargetNodeMap(Element bindings, @NotNull Node inheritedTarget, @Nullable SCDBasedBindingSet.Target inheritedSCD, Map<Element, Node> result, SCDBasedBindingSet scdResult) {
        Element[] children;
        Node target = inheritedTarget;
        this.validate(bindings);
        if (bindings.getAttributeNode("schemaLocation") != null) {
            String schemaLocation = bindings.getAttribute("schemaLocation");
            try {
                schemaLocation = new URL(new URL(this.forest.getSystemId(bindings.getOwnerDocument())), schemaLocation).toExternalForm();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            target = this.forest.get(schemaLocation);
            if (target == null) {
                this.reportError(bindings, Messages.format("Internalizer.IncorrectSchemaReference", schemaLocation, EditDistance.findNearest(schemaLocation, this.forest.listSystemIDs())));
                return;
            }
            target = ((Document)target).getDocumentElement();
        }
        if (bindings.getAttributeNode("node") != null) {
            NodeList nlst;
            String nodeXPath = bindings.getAttribute("node");
            try {
                this.xpath.setNamespaceContext(new NamespaceContextImpl(bindings));
                nlst = (NodeList)this.xpath.evaluate(nodeXPath, target, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluationError", e.getMessage()), e);
                return;
            }
            if (nlst.getLength() == 0) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNoTarget", nodeXPath));
                return;
            }
            if (nlst.getLength() != 1) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaulatesToTooManyTargets", nodeXPath, nlst.getLength()));
                return;
            }
            Node rnode = nlst.item(0);
            if (!(rnode instanceof Element)) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNonElement", nodeXPath));
                return;
            }
            if (!this.forest.logic.checkIfValidTargetNode(this.forest, bindings, (Element)rnode)) {
                this.reportError(bindings, Messages.format("Internalizer.XPathEvaluatesToNonSchemaElement", nodeXPath, rnode.getNodeName()));
                return;
            }
            target = rnode;
        }
        if (bindings.getAttributeNode("scd") != null) {
            String scdPath = bindings.getAttribute("scd");
            if (!this.enableSCD) {
                this.reportError(bindings, Messages.format("SCD_NOT_ENABLED", new Object[0]));
                this.enableSCD = true;
            }
            try {
                inheritedSCD = scdResult.createNewTarget(inheritedSCD, bindings, SCD.create(scdPath, new NamespaceContextImpl(bindings)));
            }
            catch (ParseException e) {
                this.reportError(bindings, Messages.format("ERR_SCD_EVAL", e.getMessage()), e);
                return;
            }
        }
        if (inheritedSCD != null) {
            inheritedSCD.addBinidng(bindings);
        } else {
            result.put(bindings, target);
        }
        for (Element value : children = DOMUtils.getChildElements(bindings, "http://java.sun.com/xml/ns/jaxb", "bindings")) {
            this.buildTargetNodeMap(value, target, inheritedSCD, result, scdResult);
        }
    }

    private void move(Element bindings, Map<Element, Node> targetNodes) {
        Node target = targetNodes.get(bindings);
        if (target == null) {
            return;
        }
        for (Element item : DOMUtils.getChildElements(bindings)) {
            String localName = item.getLocalName();
            if ("bindings".equals(localName)) {
                this.move(item, targetNodes);
                continue;
            }
            if ("globalBindings".equals(localName)) {
                this.moveUnder(item, this.forest.getOneDocument().getDocumentElement());
                continue;
            }
            if (!(target instanceof Element)) {
                this.reportError(item, Messages.format("Internalizer.ContextNodeIsNotElement", new Object[0]));
                return;
            }
            if (!this.forest.logic.checkIfValidTargetNode(this.forest, item, (Element)target)) {
                this.reportError(item, Messages.format("Internalizer.OrphanedCustomization", item.getNodeName()));
                return;
            }
            this.moveUnder(item, (Element)target);
        }
    }

    private void moveUnder(Element decl, Element target) {
        Element realTarget = this.forest.logic.refineTarget(target);
        this.declExtensionNamespace(decl, target);
        Element p = decl;
        HashSet<String> inscopes = new HashSet<String>();
        while (true) {
            NamedNodeMap atts = p.getAttributes();
            for (int i = 0; i < atts.getLength(); ++i) {
                String prefix;
                Attr a = (Attr)atts.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) || !inscopes.add(prefix = a.getName().indexOf(58) == -1 ? "" : a.getLocalName()) || p == decl) continue;
                decl.setAttributeNodeNS((Attr)a.cloneNode(true));
            }
            if (p.getParentNode() instanceof Document) break;
            p = (Element)p.getParentNode();
        }
        if (!inscopes.contains("")) {
            decl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        if (realTarget.getOwnerDocument() != decl.getOwnerDocument()) {
            Element original = decl;
            decl = (Element)realTarget.getOwnerDocument().importNode(decl, true);
            this.copyLocators(original, decl);
        }
        realTarget.appendChild(decl);
    }

    private void declExtensionNamespace(Element decl, Element target) {
        if (!"http://java.sun.com/xml/ns/jaxb".equals(decl.getNamespaceURI())) {
            this.declareExtensionNamespace(target, decl.getNamespaceURI());
        }
        NodeList lst = decl.getChildNodes();
        for (int i = 0; i < lst.getLength(); ++i) {
            Node n = lst.item(i);
            if (!(n instanceof Element)) continue;
            this.declExtensionNamespace((Element)n, target);
        }
    }

    private void declareExtensionNamespace(Element target, String nsUri) {
        Element root = target.getOwnerDocument().getDocumentElement();
        Attr att = root.getAttributeNodeNS("http://java.sun.com/xml/ns/jaxb", EXTENSION_PREFIXES);
        if (att == null) {
            String jaxbPrefix = this.allocatePrefix(root, "http://java.sun.com/xml/ns/jaxb");
            att = target.getOwnerDocument().createAttributeNS("http://java.sun.com/xml/ns/jaxb", jaxbPrefix + ':' + EXTENSION_PREFIXES);
            root.setAttributeNodeNS(att);
        }
        String prefix = this.allocatePrefix(root, nsUri);
        if (att.getValue().indexOf(prefix) == -1) {
            att.setValue(att.getValue() + ' ' + prefix);
        }
    }

    private String allocatePrefix(Element e, String nsUri) {
        String prefix;
        NamedNodeMap atts = e.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr a = (Attr)atts.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(a.getNamespaceURI()) || a.getName().indexOf(58) == -1 || !a.getValue().equals(nsUri)) continue;
            return a.getLocalName();
        }
        while (e.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix = "p" + (int)(Math.random() * 1000000.0) + '_') != null) {
        }
        e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsUri);
        return prefix;
    }

    private void copyLocators(Element src, Element dst) {
        this.forest.locatorTable.storeStartLocation(dst, this.forest.locatorTable.getStartLocation(src));
        this.forest.locatorTable.storeEndLocation(dst, this.forest.locatorTable.getEndLocation(src));
        Element[] srcChilds = DOMUtils.getChildElements(src);
        Element[] dstChilds = DOMUtils.getChildElements(dst);
        for (int i = 0; i < srcChilds.length; ++i) {
            this.copyLocators(srcChilds[i], dstChilds[i]);
        }
    }

    private void reportError(Element errorSource, String formattedMsg) {
        this.reportError(errorSource, formattedMsg, null);
    }

    private void reportError(Element errorSource, String formattedMsg, Exception nestedException) {
        SAXParseException2 e = new SAXParseException2(formattedMsg, this.forest.locatorTable.getStartLocation(errorSource), nestedException);
        this.errorHandler.error(e);
    }
}

