/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.config;

import javax.xml.ws.soap.AddressingFeature;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.addressing.SubmissionAddressingFeature;
import org.apache.axis2.jaxws.binding.SOAPBinding;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.feature.ClientConfigurator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.spi.Binding;
import org.apache.axis2.jaxws.spi.BindingProvider;

public class AddressingConfigurator
implements ClientConfigurator {
    public void configure(MessageContext messageContext, BindingProvider provider) {
        boolean w3cAddressingEnabled;
        Binding bnd = (Binding)provider.getBinding();
        AddressingFeature addressingFeature = (AddressingFeature)bnd.getFeature("http://www.w3.org/2005/08/addressing/module");
        SubmissionAddressingFeature submissionAddressingFeature = (SubmissionAddressingFeature)bnd.getFeature("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        String addressingNamespace = bnd.getAddressingNamespace();
        Boolean disableAddressing = (Boolean)messageContext.getProperty("disableAddressingForOutMessages");
        String addressingRequired = "unspecified";
        if (addressingFeature != null && submissionAddressingFeature != null) {
            w3cAddressingEnabled = addressingFeature.isEnabled();
            boolean submissionAddressingEnabled = submissionAddressingFeature.isEnabled();
            if (w3cAddressingEnabled && submissionAddressingEnabled) {
                if (addressingNamespace == null) {
                    addressingNamespace = "http://www.w3.org/2005/08/addressing";
                }
                disableAddressing = Boolean.FALSE;
                if (addressingFeature.isRequired() || submissionAddressingFeature.isRequired()) {
                    addressingRequired = "required";
                }
            } else if (w3cAddressingEnabled) {
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("FeatureNamespaceNotSupported", addressingNamespace));
                }
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
                disableAddressing = Boolean.FALSE;
                if (addressingFeature.isRequired()) {
                    addressingRequired = "required";
                }
            } else if (submissionAddressingEnabled) {
                if ("http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("FeatureNamespaceNotSupported", addressingNamespace));
                }
                addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                disableAddressing = Boolean.FALSE;
                if (submissionAddressingFeature.isRequired()) {
                    addressingRequired = "required";
                }
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else if (addressingFeature != null) {
            w3cAddressingEnabled = addressingFeature.isEnabled();
            if (w3cAddressingEnabled) {
                if ("http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("FeatureNamespaceNotSupported", addressingNamespace));
                }
                addressingNamespace = "http://www.w3.org/2005/08/addressing";
                disableAddressing = Boolean.FALSE;
                if (addressingFeature.isRequired()) {
                    addressingRequired = "required";
                }
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else if (submissionAddressingFeature != null) {
            boolean submissionAddressingEnabled = submissionAddressingFeature.isEnabled();
            if (submissionAddressingEnabled) {
                if ("http://www.w3.org/2005/08/addressing".equals(addressingNamespace)) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("FeatureNamespaceNotSupported", addressingNamespace));
                }
                addressingNamespace = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
                disableAddressing = Boolean.FALSE;
                if (submissionAddressingFeature.isRequired()) {
                    addressingRequired = "required";
                }
            } else {
                disableAddressing = Boolean.TRUE;
            }
        } else {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("NoWSAddressingFeatures"));
        }
        if (!disableAddressing.booleanValue()) {
            try {
                EndpointReference epr = bnd.getAxis2EndpointReference();
                org.apache.axis2.context.MessageContext axis2MessageContext = messageContext.getAxisMessageContext();
                axis2MessageContext.setTo(epr);
                ServiceDescription sd = messageContext.getEndpointDescription().getServiceDescription();
                AxisConfiguration axisConfig = sd.getAxisConfigContext().getAxisConfiguration();
                if (!axisConfig.isEngaged("addressing")) {
                    axisConfig.engageModule("addressing");
                }
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("AddressingEngagementError", e.toString()));
            }
        }
        messageContext.setProperty("WSAddressingVersion", addressingNamespace);
        messageContext.setProperty("disableAddressingForOutMessages", disableAddressing);
        messageContext.setProperty("addressingRequirementParameter", addressingRequired);
        if (addressingFeature != null) {
            messageContext.setProperty("wsamInvocationPattern", org.apache.axis2.jaxws.server.config.AddressingConfigurator.mapResponseAttributeToAddressing(addressingFeature.getResponses()));
        }
    }

    public boolean supports(Binding binding) {
        return binding instanceof SOAPBinding;
    }
}

