/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CarbonSSOSessionManager {
    private static Log log = LogFactory.getLog(CarbonSSOSessionManager.class);
    private static CarbonSSOSessionManager instance = new CarbonSSOSessionManager();
    private ConcurrentHashMap<String, String> validSessionMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> invalidSessionsMap = new ConcurrentHashMap();

    private CarbonSSOSessionManager() {
    }

    public static CarbonSSOSessionManager getInstance() {
        return instance;
    }

    public void addSessionMapping(String idPSessionIndex, String localSessionId) {
        this.validSessionMap.put(idPSessionIndex, localSessionId);
    }

    public void makeSessionInvalid(String idPSessionIndex) {
        if (this.validSessionMap.containsKey(idPSessionIndex)) {
            this.invalidSessionsMap.put(this.validSessionMap.get(idPSessionIndex), idPSessionIndex);
            this.validSessionMap.remove(idPSessionIndex);
        }
    }

    public boolean isSessionValid(String localSessionId) {
        boolean isSessionValid = true;
        if (this.invalidSessionsMap.containsKey(localSessionId)) {
            isSessionValid = false;
        }
        return isSessionValid;
    }

    public void removeInvalidSession(String localSessionId) {
        if (this.invalidSessionsMap.containsKey(localSessionId)) {
            this.invalidSessionsMap.remove(localSessionId);
        }
    }
}

