/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.ui.CarbonUIAuthenticator;

public abstract class AbstractCarbonUIAuthenticator
implements CarbonUIAuthenticator {
    private static final int DEFAULT_PRIORITY_LEVEL = 5;

    @Override
    public boolean isDisabled() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        return authenticatorConfig != null && authenticatorConfig.isDisabled();
    }

    @Override
    public int getPriority() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 5;
    }

    @Override
    public List<String> getSessionValidationSkippingUrls() {
        ArrayList<String> skippingUrls = new ArrayList<String>(Arrays.asList("/samlsso", "sso-saml/login.jsp", "stratos-sso/login_ajaxprocessor.jsp", "sso-saml/redirect_ajaxprocessor.jsp", "stratos-sso/redirect_ajaxprocessor.jsp", "sso-acs/redirect_ajaxprocessor.jsp", "stratos-auth/redirect_ajaxprocessor.jsp"));
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            skippingUrls.addAll(authenticatorConfig.getSessionValidationSkippingUrls());
        }
        return skippingUrls;
    }

    private AuthenticatorsConfiguration.AuthenticatorConfig getAuthenticatorConfig() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(this.getAuthenticatorName());
        return authenticatorConfig;
    }

    @Override
    public List<String> getAuthenticationSkippingUrls() {
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = this.getAuthenticatorConfig();
        if (authenticatorConfig != null) {
            return authenticatorConfig.getAuthenticationSkippingUrls();
        }
        return new ArrayList<String>(0);
    }
}

