/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueLong;

public class Merge
extends Prepared {
    private Table table;
    private Column[] columns;
    private Column[] keys;
    private ArrayList<Expression[]> list = New.arrayList();
    private Query query;
    private Prepared update;

    public Merge(Session session) {
        super(session);
    }

    @Override
    public void setCommand(Command command) {
        super.setCommand(command);
        if (this.query != null) {
            this.query.setCommand(command);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumns(Column[] columnArray) {
        this.columns = columnArray;
    }

    public void setKeys(Column[] columnArray) {
        this.keys = columnArray;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public void addRow(Expression[] expressionArray) {
        this.list.add(expressionArray);
    }

    @Override
    public int update() {
        int n;
        this.session.getUser().checkRight(this.table, 4);
        this.session.getUser().checkRight(this.table, 8);
        this.setCurrentRowNumber(0);
        this.session.setLastIdentity(ValueLong.get(0L));
        if (this.list.size() > 0) {
            n = 0;
            for (int i = 0; i < this.list.size(); ++i) {
                this.setCurrentRowNumber(i + 1);
                Expression[] expressionArray = this.list.get(i);
                Row row = this.table.getTemplateRow();
                for (int j = 0; j < this.columns.length; ++j) {
                    Column column = this.columns[j];
                    int n2 = column.getColumnId();
                    Expression expression = expressionArray[j];
                    if (expression == null) continue;
                    try {
                        Value value = column.convert(expression.getValue(this.session));
                        row.setValue(n2, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, this.getSQL(expressionArray));
                    }
                }
                this.merge(row);
                ++n;
            }
        } else {
            ResultInterface resultInterface = this.query.query(0);
            n = 0;
            this.table.fire(this.session, 3, true);
            this.table.lock(this.session, true, false);
            while (resultInterface.next()) {
                Value[] valueArray = resultInterface.currentRow();
                Row row = this.table.getTemplateRow();
                this.setCurrentRowNumber(++n);
                for (int i = 0; i < this.columns.length; ++i) {
                    Column column = this.columns[i];
                    int n3 = column.getColumnId();
                    try {
                        Value value = column.convert(valueArray[i]);
                        row.setValue(n3, value);
                        continue;
                    }
                    catch (DbException dbException) {
                        throw this.setRow(dbException, n, this.getSQL(valueArray));
                    }
                }
                this.merge(row);
            }
            resultInterface.close();
            this.table.fire(this.session, 3, false);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void merge(Row row) {
        Parameter parameter;
        Value value;
        Column column;
        int n;
        ArrayList<Parameter> arrayList = this.update.getParameters();
        for (n = 0; n < this.columns.length; ++n) {
            column = this.columns[n];
            value = row.getValue(column.getColumnId());
            parameter = arrayList.get(n);
            parameter.setValue(value);
        }
        for (n = 0; n < this.keys.length; ++n) {
            column = this.keys[n];
            value = row.getValue(column.getColumnId());
            if (value == null) {
                throw DbException.get(90081, column.getSQL());
            }
            parameter = arrayList.get(this.columns.length + n);
            parameter.setValue(value);
        }
        n = this.update.update();
        if (n == 0) {
            try {
                this.table.validateConvertUpdateSequence(this.session, row);
                boolean bl = this.table.fireBeforeRow(this.session, null, row);
                if (bl) return;
                this.table.lock(this.session, true, false);
                this.table.addRow(this.session, row);
                this.session.log(this.table, (short)0, row);
                this.table.fireAfterRow(this.session, null, row, false);
                return;
            }
            catch (DbException dbException) {
                if (dbException.getErrorCode() != 23001) throw dbException;
                throw DbException.get(90131, this.table.getName());
            }
        } else {
            if (n == 1) return;
            throw DbException.get(23001, this.table.getSQL());
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("MERGE INTO ");
        statementBuilder.append(this.table.getSQL()).append('(');
        for (Column expressionArray : this.columns) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expressionArray.getSQL());
        }
        statementBuilder.append(')');
        if (this.keys != null) {
            statementBuilder.append(" KEY(");
            statementBuilder.resetCount();
            for (Column column : this.keys) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        }
        statementBuilder.append('\n');
        if (this.list.size() > 0) {
            statementBuilder.append("VALUES ");
            int n = 0;
            for (Expression[] expressionArray : this.list) {
                if (n++ > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (Expression expression : expressionArray) {
                    statementBuilder.appendExceptFirst(", ");
                    if (expression == null) {
                        statementBuilder.append("DEFAULT");
                        continue;
                    }
                    statementBuilder.append(expression.getSQL());
                }
                statementBuilder.append(')');
            }
        } else {
            statementBuilder.append(this.query.getPlanSQL());
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        Object object;
        if (this.columns == null) {
            this.columns = this.list.size() > 0 && this.list.get(0).length == 0 ? new Column[0] : this.table.getColumns();
        }
        if (this.list.size() > 0) {
            for (Expression[] object22 : this.list) {
                if (object22.length != this.columns.length) {
                    throw DbException.get(21002);
                }
                for (int i = 0; i < object22.length; ++i) {
                    Expression expression = object22[i];
                    if (expression == null) continue;
                    object22[i] = expression.optimize(this.session);
                }
            }
        } else {
            this.query.prepare();
            if (this.query.getColumnCount() != this.columns.length) {
                throw DbException.get(21002);
            }
        }
        if (this.keys == null) {
            object = this.table.getPrimaryKey();
            if (object == null) {
                throw DbException.get(90057, "PRIMARY KEY");
            }
            this.keys = object.getColumns();
        }
        object = new StatementBuilder("UPDATE ");
        ((StatementBuilder)object).append(this.table.getSQL()).append(" SET ");
        for (Column column : this.columns) {
            ((StatementBuilder)object).appendExceptFirst(", ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        ((StatementBuilder)object).append(" WHERE ");
        ((StatementBuilder)object).resetCount();
        for (Column column : this.keys) {
            ((StatementBuilder)object).appendExceptFirst(" AND ");
            ((StatementBuilder)object).append(column.getSQL()).append("=?");
        }
        String string = ((StatementBuilder)object).toString();
        this.update = this.session.prepare(string);
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }
}

