/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.securevault;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.secret.SecretCallbackHandler;
import org.wso2.securevault.secret.SecretCallbackHandlerFactory;
import org.wso2.securevault.secret.SecretManager;

public class SecretResolverFactory {
    public static SecretResolver create(Element configuration, boolean isCapLetter) {
        NodeList nodeList;
        SecretResolver secretResolver = new SecretResolver();
        String passwordProvider = SecretManager.getInstance().getGlobalSecretProvider();
        String secureVaultNamespace = null;
        String secureVaultNamespacePrefix = null;
        String secureVaultElementName = isCapLetter ? "SecureVault" : "secureVault";
        NamedNodeMap nodeMap = configuration.getAttributes();
        String namespaceUri = null;
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            String nodeName = nodeMap.item(i).getNodeName();
            secureVaultNamespacePrefix = nodeName.substring(nodeName.indexOf(":") + 1);
            namespaceUri = nodeMap.item(i).getNodeValue();
            if (!namespaceUri.startsWith("http://org.wso2.securevault")) continue;
            secureVaultNamespace = namespaceUri;
            break;
        }
        if (secureVaultNamespace != null && (nodeList = configuration.getElementsByTagName(secureVaultNamespacePrefix + ":" + secureVaultElementName)).item(0) != null) {
            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                namedNodeMap.item(i).getPrefix();
                String attributeName = namedNodeMap.item(i).getNodeName();
                if (!attributeName.equals("provider")) continue;
                passwordProvider = namedNodeMap.item(i).getNodeValue();
                break;
            }
        }
        SecretResolverFactory.initPasswordManager(secretResolver, passwordProvider);
        if (secretResolver.isInitialized()) {
            SecretResolverFactory.addProtectedTokens(configuration, secretResolver, secureVaultNamespacePrefix);
        }
        return secretResolver;
    }

    public static SecretResolver create(OMElement configuration, boolean isCapLetter) {
        SecretResolver secretResolver = new SecretResolver();
        String passwordProvider = SecretManager.getInstance().getGlobalSecretProvider();
        OMNamespace secureVaultNamespace = null;
        String secureVaultElementName = isCapLetter ? "SecureVault" : "secureVault";
        while (configuration != null && configuration.getParent() != null && configuration.getParent() instanceof OMElement) {
            configuration = (OMElement)configuration.getParent();
        }
        if (configuration != null) {
            Iterator iterator = configuration.getAllDeclaredNamespaces();
            while (iterator.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)iterator.next();
                if (!omNamespace.getNamespaceURI().startsWith("http://org.wso2.securevault")) continue;
                secureVaultNamespace = omNamespace;
                break;
            }
        }
        if (secureVaultNamespace != null) {
            Iterator itr = configuration.getChildrenWithName(new QName(secureVaultNamespace.getNamespaceURI(), secureVaultElementName, secureVaultNamespace.getPrefix()));
            if (itr.hasNext()) {
                passwordProvider = ((OMElement)itr.next()).getAttributeValue(new QName("provider"));
            }
            SecretResolverFactory.initPasswordManager(secretResolver, passwordProvider);
            if (secretResolver.isInitialized()) {
                SecretResolverFactory.addProtectedTokens(configuration, secureVaultNamespace, secretResolver);
            }
        }
        return secretResolver;
    }

    public static SecretResolver create(Properties properties, String propertyPrefix) {
        String protectedTokens;
        SecretResolver secretResolver = new SecretResolver();
        String prefix = propertyPrefix;
        if (propertyPrefix != null && !"".equals(propertyPrefix) && !propertyPrefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        SecretResolverFactory.initPasswordManager(secretResolver, properties.getProperty(prefix + "secretProvider"));
        if (secretResolver.isInitialized() && (protectedTokens = properties.getProperty(prefix + "protectedTokens")) != null && !"".equals(protectedTokens.trim())) {
            ArrayList<String> tokens = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : tokens) {
                secretResolver.addProtectedToken(token);
            }
        }
        return secretResolver;
    }

    public static SecretResolver create(NamedNodeMap namedNodeMap) {
        String protectedTokens;
        Node protectedTokenAttr;
        SecretResolver secretResolver = new SecretResolver();
        String passwordProvider = SecretManager.getInstance().getGlobalSecretProvider();
        Node namedItem = namedNodeMap.getNamedItem("passwordProvider");
        if (namedItem != null && (passwordProvider = namedItem.getNodeValue()) != null && passwordProvider.trim().length() > 0) {
            SecretResolverFactory.initPasswordManager(secretResolver, passwordProvider);
        }
        if (secretResolver.isInitialized() && (protectedTokenAttr = namedNodeMap.getNamedItem("protectedTokens")) != null && (protectedTokens = protectedTokenAttr.getNodeValue()) != null && protectedTokens.trim().length() > 0) {
            ArrayList<String> protectedTokenList = new ArrayList<String>(Arrays.asList(protectedTokens.split(",")));
            for (String token : protectedTokenList) {
                if (token == null || "".equals(token)) continue;
                secretResolver.addProtectedToken(token);
            }
        }
        return secretResolver;
    }

    private static void initPasswordManager(SecretResolver secretResolver, String provider) {
        SecretCallbackHandler callbackHandler = SecretCallbackHandlerFactory.createSecretCallbackHandler(provider);
        if (callbackHandler != null) {
            secretResolver.init(callbackHandler);
        }
    }

    private static void addProtectedTokens(Node node, SecretResolver secretResolver, String secureVaultNamespacePrefix) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap nodeMap = nodeList.item(i).getAttributes();
            if (nodeMap != null) {
                for (int j = 0; j < nodeMap.getLength(); ++j) {
                    String attributeName = nodeMap.item(j).getNodeName();
                    if (!(secureVaultNamespacePrefix + ":" + "secretAlias").equals(attributeName)) continue;
                    secretResolver.addProtectedToken(nodeMap.item(j).getNodeValue());
                }
            }
            SecretResolverFactory.addProtectedTokens(nodeList.item(i), secretResolver, secureVaultNamespacePrefix);
        }
    }

    private static void addProtectedTokens(OMElement configuration, OMNamespace secureVaultNamespace, SecretResolver secretResolver) {
        Iterator iterator = configuration.getChildrenWithNamespaceURI(secureVaultNamespace.getNamespaceURI());
        while (iterator.hasNext()) {
            OMElement omElement = (OMElement)iterator.next();
            String attributeValue = omElement.getAttributeValue(new QName(secureVaultNamespace.getNamespaceURI(), "secretAlias", secureVaultNamespace.getPrefix()));
            if (attributeValue != null && !attributeValue.equals("")) {
                secretResolver.addProtectedToken(attributeValue);
            }
            SecretResolverFactory.addProtectedTokens(omElement, secureVaultNamespace, secretResolver);
        }
    }
}

