/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.servlet.context;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.servlet.context.ServletHeaderMap;
import org.apache.tiles.servlet.context.ServletHeaderValuesMap;
import org.apache.tiles.servlet.context.ServletParamMap;
import org.apache.tiles.servlet.context.ServletParamValuesMap;
import org.apache.tiles.servlet.context.ServletRequestScopeMap;
import org.apache.tiles.servlet.context.ServletSessionScopeMap;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTilesRequestContext
extends ServletTilesApplicationContext
implements TilesRequestContext {
    private static final Log LOG = LogFactory.getLog(ServletTilesRequestContext.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, String> header = null;
    private Map<String, String[]> headerValues = null;
    private Map<String, String> param = null;
    private Map<String, String[]> paramValues = null;
    private Map<String, Object> requestScope = null;
    private Map<String, Object> sessionScope = null;

    public ServletTilesRequestContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        super(servletContext);
        this.initialize(request, response);
    }

    @Override
    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = new ServletHeaderMap(this.request);
        }
        return this.header;
    }

    @Override
    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = new ServletHeaderValuesMap(this.request);
        }
        return this.headerValues;
    }

    @Override
    public Map<String, String> getParam() {
        if (this.param == null && this.request != null) {
            this.param = new ServletParamMap(this.request);
        }
        return this.param;
    }

    @Override
    public Map<String, String[]> getParamValues() {
        if (this.paramValues == null && this.request != null) {
            this.paramValues = new ServletParamValuesMap((ServletRequest)this.request);
        }
        return this.paramValues;
    }

    @Override
    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new ServletRequestScopeMap((ServletRequest)this.request);
        }
        return this.requestScope;
    }

    @Override
    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new ServletSessionScopeMap(this.request);
        }
        return this.sessionScope;
    }

    @Override
    public void dispatch(String path) throws IOException {
        if (this.response.isCommitted()) {
            this.include(path);
        } else {
            this.forward(path);
        }
    }

    private void forward(String path) throws IOException {
        RequestDispatcher rd = this.request.getRequestDispatcher(path);
        try {
            rd.forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException ex) {
            LOG.error((Object)"Servlet Exception while including path", (Throwable)ex);
            throw new IOException("Error including path '" + path + "'. " + ex.getMessage());
        }
    }

    @Override
    public void include(String path) throws IOException {
        RequestDispatcher rd = this.request.getRequestDispatcher(path);
        try {
            rd.include((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException ex) {
            LOG.error((Object)"Servlet Exception while including path", (Throwable)ex);
            throw new IOException("Error including path '" + path + "'. " + ex.getMessage());
        }
    }

    @Override
    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void initialize(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public void release() {
        this.header = null;
        this.headerValues = null;
        this.param = null;
        this.paramValues = null;
        this.requestScope = null;
        this.sessionScope = null;
        this.request = null;
        this.response = null;
        super.release();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }
}

