/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.coordination.core.sync.impl;

import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Queue;
import org.wso2.carbon.coordination.core.sync.impl.ZKSyncPrimitive;

public class ZKQueue
extends ZKSyncPrimitive
implements Queue {
    public ZKQueue(ZooKeeper zooKeeper, String queueId, int waitTimeout) throws CoordinationException {
        super(zooKeeper, ZKQueue.class.getCanonicalName(), queueId, waitTimeout);
    }

    @Override
    public void enqueue(byte[] data) throws CoordinationException {
        try {
            this.getZooKeeper().create(this.getRootPath() + "/b", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL);
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public void enqueue(byte[] data, int priority) throws CoordinationException {
        try {
            this.getZooKeeper().create(this.getRootPath() + "/a" + new Formatter().format("%010d", priority), data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    private byte[] extractEntry(List<String> entries) throws CoordinationException {
        Collections.sort(entries);
        for (String entryPath : entries) {
            String fullPath = this.getRootPath() + "/" + entryPath;
            try {
                byte[] content = this.getZooKeeper().getData(fullPath, false, null);
                this.getZooKeeper().delete(fullPath, -1);
                return content;
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NONODE) continue;
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)((Object)e));
            }
            catch (InterruptedException e) {
                throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, (Exception)e);
            }
        }
        return null;
    }

    @Override
    public byte[] dequeue() throws CoordinationException {
        try {
            List entries;
            byte[] content;
            do {
                if ((entries = this.getZooKeeper().getChildren(this.getRootPath(), false)).size() != 0) continue;
                return null;
            } while ((content = this.extractEntry(entries)) == null);
            return content;
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public byte[] blockingDequeue() throws CoordinationException {
        try {
            List entries = this.getZooKeeper().getChildren(this.getRootPath(), (Watcher)this);
            byte[] content = this.extractEntry(entries);
            if (content != null) {
                return content;
            }
            do {
                this.takeQueuedEvent();
            } while ((content = this.extractEntry(entries = this.getZooKeeper().getChildren(this.getRootPath(), (Watcher)this))) == null);
            return content;
        }
        catch (Exception e) {
            throw new CoordinationException(CoordinationException.ExceptionCode.GENERIC_ERROR, e);
        }
    }

    @Override
    public void close() {
        this.releaseResources();
    }

    @Override
    public String getQueueId() {
        return this.getId();
    }
}

