/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadCommittedEntry
implements MVCCEntry {
    private static final Log log = LogFactory.getLog(ReadCommittedEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected Object value;
    protected Object oldValue;
    protected byte flags = 0;
    private long lifespan = -1L;
    private long maxIdle = -1L;

    protected ReadCommittedEntry() {
        this.setValid(true);
    }

    public ReadCommittedEntry(Object key, Object value, EntryVersion version, long lifespan) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.lifespan = lifespan;
    }

    protected final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    protected final void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return this.lifespan;
    }

    @Override
    public final long getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public final void setMaxIdle(long maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public final void setLifespan(long lifespan) {
        this.lifespan = lifespan;
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Object setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public void copyForUpdate(DataContainer container, boolean writeSkewCheck) {
        if (this.isChanged()) {
            return;
        }
        this.setChanged();
        if (!this.isCreated()) {
            this.oldValue = this.value;
        }
    }

    @Override
    public void setLockPlaceholder(boolean placeholder) {
        if (placeholder) {
            this.setFlag(Flags.LOCK_PLACEHOLDER);
        } else {
            this.unsetFlag(Flags.LOCK_PLACEHOLDER);
        }
    }

    @Override
    public final void commit(DataContainer container, EntryVersion newVersion) {
        if (this.isChanged()) {
            if (trace) {
                log.tracef("Updating entry (key=%s removed=%s valid=%s changed=%s created=%s value=%s]", new Object[]{this.getKey(), this.isRemoved(), this.isValid(), this.isChanged(), this.isCreated(), this.value});
            }
            if (this.value instanceof AtomicHashMap) {
                AtomicHashMap ahm = (AtomicHashMap)this.value;
                ahm.commit();
                if (this.isRemoved() && !this.isEvicted()) {
                    ahm.markRemoved(true);
                }
            }
            if (this.isRemoved()) {
                container.remove(this.key);
            } else if (this.value != null) {
                container.put(this.key, this.value, newVersion, this.lifespan, this.maxIdle);
            }
            this.reset();
        }
    }

    private void reset() {
        this.oldValue = null;
        this.flags = 0;
        this.setValid(true);
    }

    @Override
    public final void rollback() {
        if (this.isChanged()) {
            this.value = this.oldValue;
            this.reset();
        }
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    protected final void setChanged() {
        this.setFlag(Flags.CHANGED);
    }

    @Override
    public boolean isValid() {
        return this.isFlagSet(Flags.VALID);
    }

    @Override
    public final void setValid(boolean valid) {
        if (valid) {
            this.setFlag(Flags.VALID);
        } else {
            this.unsetFlag(Flags.VALID);
        }
    }

    @Override
    public boolean isLockPlaceholder() {
        return this.isFlagSet(Flags.LOCK_PLACEHOLDER);
    }

    @Override
    public EntryVersion getVersion() {
        return null;
    }

    @Override
    public void setVersion(EntryVersion version) {
    }

    @Override
    public final boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        if (created) {
            this.setFlag(Flags.CREATED);
        } else {
            this.unsetFlag(Flags.CREATED);
        }
    }

    @Override
    public boolean isRemoved() {
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public final void setRemoved(boolean removed) {
        if (removed) {
            this.setFlag(Flags.REMOVED);
        } else {
            this.unsetFlag(Flags.REMOVED);
        }
    }

    @Override
    public void setEvicted(boolean evicted) {
        if (evicted) {
            this.setFlag(Flags.EVICTED);
        } else {
            this.unsetFlag(Flags.EVICTED);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode(this) + "){" + "key=" + this.key + ", value=" + this.value + ", oldValue=" + this.oldValue + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + '}';
    }

    @Override
    public boolean undelete(boolean doUndelete) {
        if (this.isRemoved() && doUndelete) {
            if (trace) {
                log.trace("Entry is deleted in current scope.  Un-deleting.");
            }
            this.setRemoved(false);
            this.setValid(true);
            return true;
        }
        return false;
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8),
        LOCK_PLACEHOLDER(16),
        EVICTED(32);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

