/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.logging;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.FormattingInfo;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.utils.logging.TenantAwareLoggingEvent;
import org.wso2.carbon.utils.multitenancy.CarbonApplicationContextHolder;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class TenantAwarePatternLayout
extends PatternLayout {
    public static final String DEFAULT_TENANT_PATTERN = "%U%@%D [%T][%S]";
    private static String tenantPattern = "%U%@%D [%T][%S]";
    private static String superTenantText = null;

    public TenantAwarePatternLayout() {
    }

    public TenantAwarePatternLayout(String pattern) {
        super(pattern);
    }

    protected PatternParser createPatternParser(String pattern) {
        return new TenantAwarePatternParser(pattern);
    }

    public synchronized void setTenantPattern(String tenantPattern) {
        TenantAwarePatternLayout.tenantPattern = tenantPattern;
    }

    public static void setSuperTenantText(String superTenantText) {
        TenantAwarePatternLayout.superTenantText = superTenantText;
    }

    private static class TenantAwarePatternParser
    extends PatternParser {
        public TenantAwarePatternParser(String pattern) {
            super(pattern);
        }

        protected void finalizeConverter(char c) {
            TenantAwareNamedPatternConverter pc = null;
            switch (c) {
                case 'D': {
                    pc = new TenantDomainPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case '@': {
                    pc = new AtSignPatternConverter(this.formattingInfo);
                    break;
                }
                case 'P': {
                    pc = new TenantPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'T': {
                    pc = new TenantIdPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'S': {
                    pc = new ServiceNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'U': {
                    pc = new UserNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'A': {
                    pc = new AppNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'H': {
                    pc = new HostNamePatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                case 'I': {
                    pc = new InstanceIdPatternConverter(this.formattingInfo, this.extractPrecisionOption());
                    break;
                }
                default: {
                    super.finalizeConverter(c);
                }
            }
            if (pc != null) {
                this.currentLiteral.setLength(0);
                this.addConverter(pc);
            }
        }

        private static class TenantPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId() != -1 && CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId() != -1234) {
                    return new TenantAwarePatternLayout(tenantPattern).format(event);
                }
                return superTenantText;
            }
        }

        private static class AtSignPatternConverter
        extends TenantAwareNamedPatternConverter {
            public AtSignPatternConverter(FormattingInfo formattingInfo) {
                super(formattingInfo, -1);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain() != null) {
                    return "@";
                }
                return null;
            }
        }

        private static class AppNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public AppNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder().getApplicationName();
            }
        }

        private static class InstanceIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            public InstanceIdPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                String stratosInstance = System.getProperty("stratos.instance");
                if (stratosInstance != null) {
                    return stratosInstance;
                }
                return "";
            }
        }

        private static class HostNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public HostNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    return inetAddress.getHostAddress();
                }
                catch (UnknownHostException e) {
                    return "0.0.0.0";
                }
            }
        }

        private static class ServiceNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public ServiceNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return ServerConfiguration.getInstance().getFirstProperty("Name");
            }
        }

        private static class TenantDomainPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantDomainPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain();
            }
        }

        private static class UserNamePatternConverter
        extends TenantAwareNamedPatternConverter {
            public UserNamePatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                return CarbonContextHolder.getCurrentCarbonContextHolder().getUsername();
            }
        }

        private static class TenantIdPatternConverter
        extends TenantAwareNamedPatternConverter {
            public TenantIdPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo, precision);
            }

            @Override
            public String getFullyQualifiedName(LoggingEvent event) {
                if (event instanceof TenantAwareLoggingEvent) {
                    return ((TenantAwareLoggingEvent)event).getTenantId();
                }
                if (CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId() != -1) {
                    return Integer.toString(CarbonContextHolder.getCurrentCarbonContextHolder().getTenantId());
                }
                return null;
            }
        }

        private static abstract class TenantAwareNamedPatternConverter
        extends PatternConverter {
            private int precision;

            public TenantAwareNamedPatternConverter(FormattingInfo formattingInfo, int precision) {
                super(formattingInfo);
                this.precision = precision;
            }

            protected abstract String getFullyQualifiedName(LoggingEvent var1);

            public String convert(LoggingEvent event) {
                String n = this.getFullyQualifiedName(event);
                if (n == null) {
                    return "";
                }
                if (this.precision <= 0) {
                    return n;
                }
                int len = n.length();
                int end = len - 1;
                for (int i = this.precision; i > 0; --i) {
                    if ((end = n.lastIndexOf(46, end - 1)) != -1) continue;
                    return n;
                }
                return n.substring(end + 1, len);
            }
        }
    }
}

