/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.bulkimport.CSVUserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.ExcelUserBulkImport;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserStoreInfo;
import org.wso2.carbon.user.mgt.permission.ManagementPermissionUtil;

public class UserRealmProxy {
    private static Log log = LogFactory.getLog(UserRealmProxy.class);
    private UserRealm realm = null;

    public UserRealmProxy(UserRealm userRealm) {
        this.realm = userRealm;
    }

    public String[] listUsers(String filter) throws UserAdminException {
        try {
            return this.realm.getUserStoreManager().listUsers(filter, -1);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getAllRolesNames() throws UserAdminException {
        try {
            UserStoreManager userStoreMan = this.realm.getUserStoreManager();
            String[] roleNames = userStoreMan.getRoleNames();
            Object[] hybridRoles = userStoreMan.getHybridRoles();
            Arrays.sort(hybridRoles);
            FlaggedName[] flaggedNames = new FlaggedName[roleNames.length];
            for (int i = 0; i < roleNames.length; ++i) {
                FlaggedName fName = new FlaggedName();
                fName.setItemName(roleNames[i]);
                fName.setEditable(true);
                if (Arrays.binarySearch(hybridRoles, roleNames[i]) < 0) {
                    fName.setRoleType("External");
                } else {
                    fName.setRoleType("Internal");
                }
                if (userStoreMan.isReadOnly() && Arrays.binarySearch(hybridRoles, roleNames[i]) < 0 || "false".equals(this.realm.getRealmConfiguration().getUserStoreProperty("WriteLDAPGroups")) && Arrays.binarySearch(hybridRoles, roleNames[i]) < 0) {
                    fName.setEditable(false);
                }
                flaggedNames[i] = fName;
            }
            return flaggedNames;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UserStoreInfo getUserStoreInfo() throws UserAdminException {
        try {
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            UserStoreInfo info = new UserStoreInfo();
            if ("true".equals(realmConfig.getUserStoreProperty("ReadOnly"))) {
                info.setReadOnly(true);
            } else {
                info.setReadOnly(false);
            }
            info.setPasswordsExternallyManaged(realmConfig.isPasswordsExternallyManaged());
            info.setJsRegEx(realmConfig.getUserStoreProperty("PasswordJavaScriptRegEx"));
            info.setUserNameRegEx(realmConfig.getUserStoreProperty("UsernameJavaScriptRegEx"));
            info.setRoleNameRegEx(realmConfig.getUserStoreProperty("RolenameJavaScriptRegEx"));
            info.setExternalIdP(realmConfig.getUserStoreProperty("ExternalIdP"));
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
                if (this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/configure/security", "ui.execute")) {
                    info.setAdminRole(realmConfig.getAdminRoleName());
                    info.setAdminUser(realmConfig.getAdminUserName());
                    info.setEveryOneRole(realmConfig.getEveryOneRoleName());
                    info.setMaxUserListCount(Integer.parseInt(realmConfig.getUserStoreProperty("MaxUserNameListLength")));
                }
            }
            info.setBulkImportSupported(this.isBulkImportSupported());
            return info;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private boolean isBulkImportSupported() throws UserAdminException {
        try {
            UserStoreManager userStoreManager = this.realm.getUserStoreManager();
            if (userStoreManager != null) {
                return userStoreManager.isBulkImportSupported();
            }
            throw new UserAdminException("Unable to retrieve user store manager from realm.");
        }
        catch (UserStoreException e) {
            throw new UserAdminException("An error occurred while retrieving user store from realm.", e);
        }
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        try {
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (realmConfig.getUserStoreProperty("ExternalIdP") != null) {
                throw new UserAdminException("Please contact your external Identity Provider to add users");
            }
            if (roles != null) {
                boolean isContained = false;
                String[] temp = new String[roles.length + 1];
                for (int i = 0; i < roles.length; ++i) {
                    temp[i] = roles[i];
                    if (!roles[i].equals(realmConfig.getEveryOneRoleName())) continue;
                    isContained = true;
                    break;
                }
                if (!isContained) {
                    temp[roles.length] = realmConfig.getEveryOneRoleName();
                    roles = temp;
                }
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            HashMap<String, String> claimMap = new HashMap<String, String>();
            if (claims != null) {
                for (ClaimValue claimValue : claims) {
                    claimMap.put(claimValue.getClaimURI(), claimValue.getValue());
                }
            }
            admin.addUser(userName, (Object)password, roles, claimMap, profileName, false);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        try {
            this.realm.getUserStoreManager().updateCredentialByAdmin(userName, (Object)newPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName, Registry registry) throws UserAdminException {
        try {
            this.realm.getUserStoreManager().deleteUser(userName);
            String path = "/users/" + userName;
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error deleting user from registry, " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UserAdminException(msg, e);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        try {
            UserStoreManager usAdmin = this.realm.getUserStoreManager();
            usAdmin.addRole(roleName, userList, null);
            ManagementPermissionUtil.updateRoleUIPermission(roleName, permissions);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        try {
            UserStoreManager usAdmin = this.realm.getUserStoreManager();
            usAdmin.updateRoleName(roleName, newRoleName);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        try {
            this.realm.getUserStoreManager().deleteRole(roleName);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter) throws UserAdminException {
        try {
            UserStoreManager usMan = this.realm.getUserStoreManager();
            String[] userNames = usMan.listUsers(filter, -1);
            Object[] usersOfRole = usMan.getUserListOfRole(roleName);
            Arrays.sort(usersOfRole);
            FlaggedName[] flaggedNames = new FlaggedName[userNames.length];
            for (int i = 0; i < userNames.length; ++i) {
                FlaggedName fName = new FlaggedName();
                fName.setItemName(userNames[i]);
                if (Arrays.binarySearch(usersOfRole, userNames[i]) > -1) {
                    fName.setSelected(true);
                }
                flaggedNames[i] = fName;
            }
            return flaggedNames;
        }
        catch (Exception e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        try {
            if ("wso2.anonymous.role".equals(roleName)) {
                log.error((Object)"Security Alert! Carbon anonymous role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            if (this.realm.getRealmConfiguration().getEveryOneRoleName().equals(roleName)) {
                log.error((Object)"Security Alert! Carbon Everyone role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldUserList = admin.getUserListOfRole(roleName);
            Arrays.sort(oldUserList);
            ArrayList<String> delUsers = new ArrayList<String>();
            ArrayList<String> addUsers = new ArrayList<String>();
            for (FlaggedName fName : userList) {
                boolean isSelected = fName.isSelected();
                String userName = fName.getItemName();
                if ("wso2.anonymous.user".equals(userName)) {
                    log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                    return;
                }
                int oldindex = Arrays.binarySearch(oldUserList, userName);
                if (oldindex > -1 && !isSelected) {
                    delUsers.add(userName);
                    continue;
                }
                if (oldindex >= 0 || !isSelected) continue;
                addUsers.add(userName);
            }
            admin.updateUserListOfRole(roleName, delUsers.toArray(new String[delUsers.size()]), addUsers.toArray(new String[addUsers.size()]));
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getRolesOfUser(String userName) throws UserAdminException {
        try {
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] userroles = admin.getRoleListOfUser(userName);
            String[] allRoles = admin.getRoleNames();
            FlaggedName[] flaggedNames = new FlaggedName[allRoles.length];
            Arrays.sort(userroles);
            for (int i = 0; i < allRoles.length; ++i) {
                String role = allRoles[i];
                FlaggedName fname = new FlaggedName();
                fname.setItemName(role);
                if (Arrays.binarySearch(userroles, role) > -1) {
                    fname.setSelected(true);
                }
                flaggedNames[i] = fname;
            }
            return flaggedNames;
        }
        catch (Exception e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRolesOfUser(String userName, String[] roleList) throws UserAdminException {
        try {
            if ("wso2.anonymous.user".equals(userName)) {
                log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                throw new UserAdminException("Invalid data");
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldRoleList = admin.getRoleListOfUser(userName);
            Arrays.sort(roleList);
            Arrays.sort(oldRoleList);
            ArrayList<Object> delRoles = new ArrayList<Object>();
            ArrayList<String> addRoles = new ArrayList<String>();
            for (String string : roleList) {
                int oldindex = Arrays.binarySearch(oldRoleList, string);
                if (oldindex >= 0) continue;
                addRoles.add(string);
            }
            for (Object object : oldRoleList) {
                int newindex = Arrays.binarySearch(roleList, object);
                if (newindex >= 0) continue;
                if (this.realm.getRealmConfiguration().getEveryOneRoleName().equals(object)) {
                    log.error((Object)"Security Alert! Carbon everyone role is being manipulated");
                    throw new UserAdminException("Invalid data");
                }
                delRoles.add(object);
            }
            admin.updateRoleListOfUser(userName, delRoles.toArray(new String[delRoles.size()]), addRoles.toArray(new String[addRoles.size()]));
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getAllUIPermissions(int tenantId, Registry registry) throws UserAdminException {
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            if (tenantId == -1234) {
                if (CarbonContext.getCurrentContext().getTenantId() != -1234) {
                    log.error((Object)"Illegal access attempt");
                    throw new UserStoreException("Illegal access attempt");
                }
                regRoot = (Collection)registry.get("/permission/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/", displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            this.buildUIPermissionNode(regRoot, nodeRoot, registry, null, null, null);
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getRolePermissions(String roleName, int tenantId, Registry registry) throws UserAdminException {
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            if (tenantId == -1234) {
                regRoot = (Collection)registry.get("/permission/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/", displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            this.buildUIPermissionNode(regRoot, nodeRoot, registry, this.realm.getAuthorizationManager(), roleName, null);
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        try {
            if (this.realm.getRealmConfiguration().getAdminRoleName().equals(roleName)) {
                String msg = "UI permissions of Admin is not allowed to change";
                log.error((Object)msg);
                throw new UserAdminException(msg);
            }
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawResources);
            AuthorizationManager authMan = this.realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            for (String path : optimizedList) {
                authMan.authorizeRole(roleName, path, "ui.execute");
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void bulkImportUsers(String fileName, InputStream inStream, String defaultPassword) throws UserAdminException {
        block5: {
            try {
                BulkImportConfig config = new BulkImportConfig(inStream, fileName);
                if (defaultPassword != null && defaultPassword.trim().length() > 0) {
                    config.setDefaultPassword(defaultPassword.trim());
                }
                UserStoreManager userStore = this.realm.getUserStoreManager();
                if (fileName.endsWith("csv")) {
                    CSVUserBulkImport csvAdder = new CSVUserBulkImport(config);
                    csvAdder.addUserList(userStore);
                    break block5;
                }
                if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
                    ExcelUserBulkImport excelAdder = new ExcelUserBulkImport(config);
                    excelAdder.addUserList(userStore);
                    break block5;
                }
                throw new UserAdminException("Unsupported format");
            }
            catch (UserStoreException e) {
                throw new UserAdminException(e.getMessage(), e);
            }
        }
    }

    public void changePasswordByUser(String oldPassword, String newPassword) throws UserAdminException {
        try {
            UserStoreManager userStore = this.realm.getUserStoreManager();
            HttpServletRequest request = (HttpServletRequest)MessageContext.getCurrentMessageContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            userStore.updateCredential(userName, (Object)newPassword, (Object)oldPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private void buildUIPermissionNode(Collection parent, UIPermissionNode parentNode, Registry registry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        boolean isSelected = false;
        if (roleName != null) {
            isSelected = authMan.isRoleAuthorized(roleName, parentNode.getResourcePath(), "ui.execute");
        } else if (userName != null) {
            isSelected = authMan.isUserAuthorized(userName, parentNode.getResourcePath(), "ui.execute");
        }
        if (isSelected) {
            this.buildUIPermissionNodeAllSelected(parent, parentNode, registry);
            parentNode.setSelected(true);
        } else {
            this.buildUIPermissionNodeNotAllSelected(parent, parentNode, registry, authMan, roleName, userName);
        }
    }

    private void buildUIPermissionNodeAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = registry.get(child);
            childNodes[i] = this.getUIPermissionNode(resource, registry, true);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeAllSelected((Collection)resource, childNodes[i], registry);
        }
        parentNode.setNodeList(childNodes);
    }

    private void buildUIPermissionNodeNotAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = registry.get(child);
            boolean isSelected = false;
            if (roleName != null) {
                isSelected = authMan.isRoleAuthorized(roleName, child, "ui.execute");
            } else if (userName != null) {
                isSelected = authMan.isUserAuthorized(userName, child, "ui.execute");
            }
            childNodes[i] = this.getUIPermissionNode(resource, registry, isSelected);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeNotAllSelected((Collection)resource, childNodes[i], registry, authMan, roleName, userName);
        }
        parentNode.setNodeList(childNodes);
    }

    private UIPermissionNode getUIPermissionNode(Resource resource, Registry registry, boolean isSelected) throws RegistryException {
        String displayName = resource.getProperty("name");
        return new UIPermissionNode(resource.getPath(), displayName, isSelected);
    }
}

