/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.LogManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Catalina {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean await = false;
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    private static final Log log = LogFactory.getLog(Catalina.class);

    public Catalina() {
        this.setSecurityProtection();
    }

    public void setConfig(String file) {
        this.configFile = file;
    }

    public void setConfigFile(String file) {
        this.configFile = file;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        this.useNaming = useNaming;
    }

    public void setAwait(boolean b) {
        this.await = b;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("configtest")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long t1 = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        digester.setClassLoader(StandardServer.class.getClassLoader());
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", new SetAllPropertiesRule(new String[]{"executor"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet(new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet(new EngineRuleSet("Server/Service/"));
        digester.addRuleSet(new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet(new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet(new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digester for server.xml created " + (t2 - t1)));
        }
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String prefix) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("org.apache.catalina.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(prefix);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("catalina.noCluster", e.getClass().getName() + ": " + e.getMessage()), (Throwable)e);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)sm.getString("catalina.noCluster", e.getClass().getName() + ": " + e.getMessage()));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer(String[] arguments) {
        Server s;
        if (arguments != null) {
            this.arguments(arguments);
        }
        if ((s = this.getServer()) == null) {
            Digester digester = this.createStopDigester();
            digester.setClassLoader(Thread.currentThread().getContextClassLoader());
            File file = this.configFile();
            FileInputStream fis = null;
            try {
                InputSource is = new InputSource("file://" + file.getAbsolutePath());
                fis = new FileInputStream(file);
                is.setByteStream(fis);
                digester.push(this);
                digester.parse(is);
            }
            catch (Exception e) {
                log.error((Object)"Catalina.stop: ", (Throwable)e);
                System.exit(1);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            try {
                s.stop();
            }
            catch (LifecycleException e) {
                log.error((Object)"Catalina.stop: ", (Throwable)e);
            }
            return;
        }
        s = this.getServer();
        if (s.getPort() > 0) {
            Socket socket = null;
            OutputStream stream = null;
            try {
                socket = new Socket(s.getAddress(), s.getPort());
                stream = socket.getOutputStream();
                String shutdown = s.getShutdown();
                for (int i = 0; i < shutdown.length(); ++i) {
                    stream.write(shutdown.charAt(i));
                }
                stream.flush();
            }
            catch (IOException e) {
                log.error((Object)"Catalina.stop: ", (Throwable)e);
                System.exit(1);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            log.error((Object)sm.getString("catalina.stopServer"));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        File file;
        InputStream inputStream;
        InputSource inputSource;
        Digester digester;
        long t1;
        block33: {
            block32: {
                block31: {
                    t1 = System.nanoTime();
                    this.initDirs();
                    this.initNaming();
                    digester = this.createStartDigester();
                    inputSource = null;
                    inputStream = null;
                    file = null;
                    try {
                        file = this.configFile();
                        inputStream = new FileInputStream(file);
                        inputSource = new InputSource("file://" + file.getAbsolutePath());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block31;
                        log.debug((Object)sm.getString("catalina.configFail", file), (Throwable)e);
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                        inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block32;
                        log.debug((Object)sm.getString("catalina.configFail", this.getConfigFile()), (Throwable)e);
                    }
                }
            }
            if (inputStream == null) {
                try {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                    inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block33;
                    log.debug((Object)sm.getString("catalina.configFail", "server-embed.xml"), (Throwable)e);
                }
            }
        }
        if (inputStream == null || inputSource == null) {
            if (file == null) {
                log.warn((Object)sm.getString("catalina.configFail", this.getConfigFile() + "] or [server-embed.xml]"));
            } else {
                log.warn((Object)sm.getString("catalina.configFail", file.getAbsolutePath()));
                if (file.exists() && !file.canRead()) {
                    log.warn((Object)"Permissions incorrect, read permission is not allowed on the file.");
                }
            }
            return;
        }
        try {
            inputSource.setByteStream(inputStream);
            digester.push(this);
            digester.parse(inputSource);
        }
        catch (SAXParseException spe) {
            log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": " + spe.getMessage()));
            return;
        }
        catch (Exception e) {
            log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": "), (Throwable)e);
            return;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
        this.getServer().setCatalina(this);
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException e) {
            if (Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) {
                throw new Error(e);
            }
            log.error((Object)"Catalina.start", (Throwable)e);
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("Initialization processed in " + (t2 - t1) / 1000000L + " ms"));
        }
    }

    public void load(String[] args) {
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal((Object)"Cannot start server. Server instance is not configured.");
            return;
        }
        long t1 = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException e) {
            log.error((Object)"Catalina.start: ", (Throwable)e);
        }
        long t2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("Server startup in " + (t2 - t1) / 1000000L + " ms"));
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new CatalinaShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        try {
            Server s = this.getServer();
            LifecycleState state = s.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(state) > 0 || LifecycleState.DESTROYED.compareTo(state) < 0) {
                s.stop();
                s.destroy();
            }
        }
        catch (LifecycleException e) {
            log.error((Object)"Catalina.stop", (Throwable)e);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -nonaming ]  { -help | start | stop }");
    }

    protected void initDirs() {
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome == null) {
            String j2eeHome = System.getProperty("com.sun.enterprise.home");
            if (j2eeHome != null) {
                catalinaHome = System.getProperty("com.sun.enterprise.home");
            } else if (System.getProperty("catalina.base") != null) {
                catalinaHome = System.getProperty("catalina.base");
            }
        }
        if (catalinaHome == null) {
            catalinaHome = System.getProperty("user.dir");
        }
        if (catalinaHome != null) {
            File home = new File(catalinaHome);
            if (!home.isAbsolute()) {
                try {
                    catalinaHome = home.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaHome = home.getAbsolutePath();
                }
            }
            System.setProperty("catalina.home", catalinaHome);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", catalinaHome);
        } else {
            String catalinaBase = System.getProperty("catalina.base");
            File base = new File(catalinaBase);
            if (!base.isAbsolute()) {
                try {
                    catalinaBase = base.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaBase = base.getAbsolutePath();
                }
            }
            System.setProperty("catalina.base", catalinaBase);
        }
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null || !new File(temp).exists() || !new File(temp).isDirectory()) {
            log.error((Object)sm.getString("embedded.notmp", temp));
        }
    }

    protected void initStreams() {
        System.setOut(new SystemLogHandler(System.out));
        System.setErr(new SystemLogHandler(System.err));
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info((Object)"Catalina naming disabled");
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", value);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting naming prefix=" + value));
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.debug((Object)("INITIAL_CONTEXT_FACTORY alread set " + value));
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Catalina.this.getServer() != null) {
                    Catalina.this.stop();
                }
            }
            catch (Throwable ex) {
                ExceptionUtils.handleThrowable(ex);
                log.error((Object)sm.getString("catalina.shutdownHookFail"), ex);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

