/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class LDAPConnectionContext {
    private Hashtable environment;
    private static Log log = LogFactory.getLog(LDAPConnectionContext.class);

    public LDAPConnectionContext(RealmConfiguration realmConfig) {
        String rawConnectionURL = realmConfig.getUserStoreProperty("ConnectionURL");
        String portInfo = rawConnectionURL.split(":")[2];
        String connectionURL = null;
        String port = null;
        if (portInfo.contains("${") && portInfo.contains("}")) {
            port = Integer.toString(CarbonUtils.getPortFromServerConfig((String)portInfo));
        }
        connectionURL = port != null ? rawConnectionURL.replace(portInfo, port) : realmConfig.getUserStoreProperty("ConnectionURL");
        String connectionName = realmConfig.getUserStoreProperty("ConnectionName");
        String connectionPassword = realmConfig.getUserStoreProperty("ConnectionPassword");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection Name :: " + connectionName + "," + "Connection Password :: " + connectionPassword + "," + "Connection URL :: " + connectionURL));
        }
        this.environment = new Hashtable();
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environment.put("java.naming.security.authentication", "simple");
        this.environment.put("org.wso2.carbon.context.RequestBaseContext", "true");
        if (connectionName != null) {
            this.environment.put("java.naming.security.principal", connectionName);
        }
        if (connectionPassword != null) {
            this.environment.put("java.naming.security.credentials", connectionPassword);
        }
        if (connectionURL != null) {
            this.environment.put("java.naming.provider.url", connectionURL);
        }
        this.environment.put("com.sun.jndi.ldap.connect.pool", "true");
        if (realmConfig.getUserStoreProperty("Referral") != null) {
            this.environment.put("java.naming.referral", realmConfig.getUserStoreProperty("Referral"));
        }
    }

    public DirContext getContext() throws UserStoreException {
        InitialDirContext context = null;
        try {
            context = new InitialDirContext(this.environment);
        }
        catch (NamingException e) {
            log.error((Object)("Error obtaining connection. " + e.getMessage()), (Throwable)e);
            log.error((Object)"Trying again to get connection.");
            try {
                context = new InitialDirContext(this.environment);
            }
            catch (Exception e1) {
                log.error((Object)("Error obtaining connection for the second time" + e.getMessage()), (Throwable)e);
                throw new UserStoreException("Error obtaining connection. " + e.getMessage(), e);
            }
        }
        return context;
    }

    public void updateCredential(String connectionPassword) {
        this.environment.put("java.naming.security.credentials", connectionPassword);
    }
}

