/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.ldap.LDAPConstants;
import org.wso2.carbon.user.core.ldap.ReadWriteLDAPUserStoreManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;
import org.wso2.carbon.user.core.util.JNDIUtil;

public class ActiveDirectoryUserStoreManager
extends ReadWriteLDAPUserStoreManager {
    private static Log logger = LogFactory.getLog(ActiveDirectoryUserStoreManager.class);
    private boolean isADLDSRole = false;
    private boolean isSSLConnection = false;

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, Map<String, Object> properties, ClaimManager claimManager, ProfileConfigurationManager profileManager, UserRealm realm, Integer tenantId) throws UserStoreException {
        super(realmConfig, properties, claimManager, profileManager, realm, tenantId);
        this.checkRequiredUserStoreConfigurations();
    }

    public ActiveDirectoryUserStoreManager(RealmConfiguration realmConfig, ClaimManager claimManager, ProfileConfigurationManager profileManager) throws UserStoreException {
        super(realmConfig, claimManager, profileManager);
        this.checkRequiredUserStoreConfigurations();
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        this.addUser(userName, credential, roleList, claims, profileName, false);
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        this.doAddUserValidityChecks(userName, credential);
        DirContext dirContext = this.getSearchBaseDirectoryContext();
        BasicAttributes basicAttributes = this.getAddUserBasicAttributes(userName);
        if (!this.isADLDSRole) {
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            userAccountControl.add("514");
            basicAttributes.put(userAccountControl);
        }
        this.setUserClaims(claims, basicAttributes);
        try {
            NameParser ldapParser = dirContext.getNameParser("");
            Name compoundName = ldapParser.parse(this.realmConfig.getUserStoreProperty("UserNameAttribute") + "=" + userName);
            dirContext.bind(compoundName, null, (Attributes)basicAttributes);
            logger.info((Object)("User " + userName + "added successfully"));
            this.updateUserRoles(userName, roleList);
            if (!this.isSSLConnection) {
                logger.warn((Object)"Unsecured connection is being used. Enabling user account operation will fail");
            }
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword((String)credential))), this.isADLDSRole ? new ModificationItem(2, new BasicAttribute("msDS-UserAccountDisabled", "FALSE")) : new ModificationItem(2, new BasicAttribute("userAccountControl", LDAPConstants.ACTIVE_DIRECTORY_ENABLED_NORMAL_ACCOUNT))};
            dirContext.modifyAttributes(compoundName, mods);
        }
        catch (NamingException e) {
            String errorMessage = "Can not access the directory context or user already exists in the system";
            logger.error((Object)errorMessage, (Throwable)e);
            throw new UserStoreException(errorMessage, e);
        }
        finally {
            JNDIUtil.closeContext(dirContext);
        }
    }

    protected void setUserClaims(Map<String, String> claims, BasicAttributes basicAttributes) throws UserStoreException {
        for (Map.Entry<String, String> entry : claims.entrySet()) {
            if ("".equals(entry.getValue())) continue;
            String claimURI = entry.getKey();
            ClaimMapping claimMapping = null;
            try {
                claimMapping = (ClaimMapping)this.claimManager.getClaimMapping(claimURI);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                String errorMessage = "Error in obtaining claim mapping.";
                logger.error((Object)errorMessage, (Throwable)e);
                throw new UserStoreException(errorMessage, e);
            }
            if (claimURI.equals("profileConfiguration")) continue;
            String attributeName = claimMapping != null ? claimMapping.getMappedAttribute() : claimURI;
            BasicAttribute claim = new BasicAttribute(attributeName);
            claim.add(claims.get(entry.getKey()));
            basicAttributes.put(claim);
        }
    }

    @Override
    public void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        this.doUpdateCredentialsValidityChecks(userName, newCredential);
        DirContext dirContext = this.connectionSource.getContext();
        String searchBase = this.realmConfig.getUserStoreProperty("UserSearchBase");
        String usernameAttribute = this.realmConfig.getUserStoreProperty("UserNameAttribute");
        DirContext subDirContext = null;
        try {
            subDirContext = (DirContext)dirContext.lookup(searchBase);
            ModificationItem[] mods = null;
            if (oldCredential != null && newCredential != null) {
                mods = new ModificationItem[2];
                byte[] oldUnicodePassword = this.createUnicodePassword((String)oldCredential);
                byte[] newUnicodePassword = this.createUnicodePassword((String)newCredential);
                mods[0] = new ModificationItem(3, new BasicAttribute("unicodePwd", oldUnicodePassword));
                mods[1] = new ModificationItem(1, new BasicAttribute("unicodePwd", newUnicodePassword));
            } else {
                mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", this.createUnicodePassword((String)newCredential)))};
            }
            subDirContext.modifyAttributes(usernameAttribute + "=" + userName, mods);
        }
        catch (NamingException e) {
            try {
                String error = "Can not access the directory service";
                logger.error((Object)error, (Throwable)e);
                throw new UserStoreException(error, e);
            }
            catch (Throwable throwable) {
                JNDIUtil.closeContext(subDirContext);
                JNDIUtil.closeContext(dirContext);
                throw throwable;
            }
        }
        JNDIUtil.closeContext(subDirContext);
        JNDIUtil.closeContext(dirContext);
    }

    @Override
    protected void doUpdateCredentialsValidityChecks(String userName, Object newCredential) throws UserStoreException {
        super.doUpdateCredentialsValidityChecks(userName, newCredential);
        if (!this.isSSLConnection) {
            logger.warn((Object)"Unsecured connection is being used. Password operations will fail");
        }
    }

    @Override
    protected void checkRequiredUserStoreConfigurations() throws UserStoreException {
        super.checkRequiredUserStoreConfigurations();
        String is_ADLDSRole = this.realmConfig.getUserStoreProperty("isADLDSRole");
        if (is_ADLDSRole == null || is_ADLDSRole.equals("")) {
            throw new UserStoreException("Required PasswordHashMethod property is not set at the LDAP configurations");
        }
        this.isADLDSRole = Boolean.parseBoolean(is_ADLDSRole);
        String connectionURL = this.realmConfig.getUserStoreProperty("ConnectionURL");
        String[] array = connectionURL.split(":");
        if (!array[0].equals("ldaps")) {
            logger.warn((Object)"Connection to the Active Directory is not secure. Passowrd involved operations such as update credentials and adduser operations will fail");
        } else {
            this.isSSLConnection = true;
        }
    }

    private byte[] createUnicodePassword(String password) {
        String newQuotedPassword = "\"" + password + "\"";
        byte[] encodedPwd = null;
        try {
            encodedPwd = newQuotedPassword.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Error while encoding the given password", (Throwable)e);
        }
        return encodedPwd;
    }
}

