/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.hybrid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.jdbc.JDBCUserStoreManager;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class HybridRoleManager {
    private static Log log = LogFactory.getLog(JDBCUserStoreManager.class);
    private DataSource dataSource;
    int tenantId;
    private RealmConfiguration realmConfig;
    protected UserRealm userRealm = null;

    public HybridRoleManager(DataSource dataSource, int tenantId, RealmConfiguration realmConfig, UserRealm realm) {
        this.dataSource = dataSource;
        this.tenantId = tenantId;
        this.realmConfig = realmConfig;
        this.userRealm = realm;
    }

    public void addHybridRole(String roleName, String[] userList) throws UserStoreException {
        Connection dbConnection = null;
        try {
            if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
                return;
            }
            dbConnection = this.getDBConnection();
            if (!this.isExistingRole(roleName)) {
                DatabaseUtil.updateDatabase(dbConnection, "INSERT INTO UM_HYBRID_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", roleName, this.tenantId);
            }
            if (userList != null) {
                String sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)";
                String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
                if ("mssql".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?)";
                }
                if ("openedge".equals(type)) {
                    sql = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sql, userList, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sql, userList, roleName, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isExistingRole(String roleName) throws UserStoreException {
        boolean value;
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            return true;
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME =? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, this.tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public String[] getHybridRoles() throws UserStoreException {
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_HYBRID_ROLE WHERE UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            Object[] roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, this.tenantId);
            if (Arrays.binarySearch(roles, this.realmConfig.getEveryOneRoleName()) < 0) {
                Arrays.sort(roles);
                String[] allRoles = new String[roles.length + 1];
                int i = 0;
                Object[] arr$ = roles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Object role;
                    allRoles[i] = role = arr$[i$];
                    ++i;
                }
                allRoles[i] = this.realmConfig.getEveryOneRoleName();
                String[] stringArray = allRoles;
                return stringArray;
            }
            Object[] objectArray = roles;
            return objectArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public String[] getUserListOfHybridRole(String roleName) throws UserStoreException {
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            throw new UserStoreException("Invalid operation. You are trying to retrieve all users from the external userstore.");
        }
        String sqlStmt = "SELECT UM_USER_NAME FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            String[] names;
            dbConnection = this.getDBConnection();
            String[] stringArray = names = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, roleName, this.tenantId, this.tenantId);
            return stringArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public void updateUserListOfHybridRole(String roleName, String[] deletedUsers, String[] newUsers) throws UserStoreException {
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            throw new UserStoreException("Everyone role is not updatable");
        }
        if (deletedUsers != null) {
            Arrays.sort(deletedUsers);
            if (this.realmConfig.getAdminRoleName().equals(roleName) && Arrays.binarySearch(deletedUsers, this.realmConfig.getAdminUserName()) > -1) {
                log.error((Object)"An attempt to remove Admin user from Admin role ");
                throw new UserStoreException("Cannot remove Admin user from Admin role");
            }
        }
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) VALUES (?,(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)";
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT (?),(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?)";
            }
            if (deletedUsers != null && deletedUsers.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedUsers, roleName, this.tenantId, this.tenantId);
                for (String deletedUser : deletedUsers) {
                    this.userRealm.getAuthorizationManager().clearUserAuthorization(deletedUser);
                }
            }
            if (newUsers != null && newUsers.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_USER_NAME, UM_ROLE_ID, UM_TENANT_ID) SELECT ?, UM_ID, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, this.tenantId, roleName, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, newUsers, roleName, this.tenantId, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public String[] getHybridRoleListOfUser(String userName) throws UserStoreException {
        String sqlStmt = "SELECT UM_ROLE_NAME FROM UM_HYBRID_USER_ROLE, UM_HYBRID_ROLE WHERE UM_USER_NAME=? AND UM_HYBRID_USER_ROLE.UM_ROLE_ID=UM_HYBRID_ROLE.UM_ID AND UM_HYBRID_USER_ROLE.UM_TENANT_ID=? AND UM_HYBRID_ROLE.UM_TENANT_ID=?";
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String[] roles = DatabaseUtil.getStringValuesFromDatabase(dbConnection, sqlStmt, userName, this.tenantId, this.tenantId);
            if (!"wso2.anonymous.user".equals(userName)) {
                String[] allRoles = new String[roles.length + 1];
                int i = 0;
                String[] arr$ = roles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String role;
                    allRoles[i] = role = arr$[i$];
                    ++i;
                }
                allRoles[i] = this.realmConfig.getEveryOneRoleName();
                String[] stringArray = allRoles;
                return stringArray;
            }
            String[] stringArray = roles;
            return stringArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public void updateHybridRoleListOfUser(String user, String[] deletedRoles, String[] addRoles) throws UserStoreException {
        if (deletedRoles != null) {
            Arrays.sort(deletedRoles);
            if (this.realmConfig.getAdminUserName().equals(user) && Arrays.binarySearch(deletedRoles, this.realmConfig.getAdminRoleName()) > -1) {
                log.error((Object)"An attempt to remove Admin user from Admin role ");
                throw new UserStoreException("Cannot remove Admin user from Admin role");
            }
        }
        String sqlStmt1 = "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_NAME=? AND UM_TENANT_ID=?";
        String sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?, ?)";
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            String type = DatabaseCreator.getDatabaseType((Connection)dbConnection);
            if ("mssql".equals(type)) {
                sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), (?), (?)";
            }
            if (deletedRoles != null && deletedRoles.length > 0) {
                DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt1, deletedRoles, this.tenantId, user, this.tenantId);
            }
            if (addRoles != null && addRoles.length > 0) {
                if ("openedge".equals(type)) {
                    sqlStmt2 = "INSERT INTO UM_HYBRID_USER_ROLE (UM_ROLE_ID, UM_USER_NAME, UM_TENANT_ID) SELECT UM_ID, ?, ? FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?";
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, user, this.tenantId, addRoles, this.tenantId);
                } else {
                    DatabaseUtil.udpateUserRoleMappingInBatchMode(dbConnection, sqlStmt2, addRoles, this.tenantId, user, this.tenantId);
                }
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        if (deletedRoles != null && deletedRoles.length > 0) {
            this.userRealm.getAuthorizationManager().clearUserAuthorization(user);
        }
    }

    public void deleteHybridRole(String roleName) throws UserStoreException {
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            throw new UserStoreException("Invalid operation");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", roleName, this.tenantId, this.tenantId);
            DatabaseUtil.updateDatabase(dbConnection, "DELETE FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", roleName, this.tenantId);
            dbConnection.commit();
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
        this.userRealm.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    public void updateHybridRoleName(String roleName, String newRoleName) throws UserStoreException {
        if (this.realmConfig.getAdminRoleName().equals(roleName)) {
            throw new UserStoreException("Cannot rename admin role");
        }
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            throw new UserStoreException("Cannot rename everyone role");
        }
        if (this.isExistingRole(newRoleName)) {
            throw new UserStoreException("Role name: " + newRoleName + " in the system. Please pick another role name.");
        }
        String sqlStmt = "UPDATE UM_HYBRID_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?";
        if (sqlStmt == null) {
            throw new UserStoreException("The sql statement for update hybrid role name is null");
        }
        Connection dbConnection = null;
        try {
            dbConnection = this.getDBConnection();
            if (sqlStmt.contains("UM_TENANT_ID")) {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName, this.tenantId);
            } else {
                DatabaseUtil.updateDatabase(dbConnection, sqlStmt, newRoleName, roleName);
            }
            dbConnection.commit();
            this.userRealm.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            log.error((Object)("Using sql : " + sqlStmt));
            throw new UserStoreException(e.getMessage(), e);
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    public boolean isUserInRole(String userName, String roleName) throws UserStoreException {
        if (this.realmConfig.getEveryOneRoleName().equals(roleName)) {
            return true;
        }
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isUserInRole = false;
        try {
            int value;
            dbConnection = this.getDBConnection();
            prepStmt = dbConnection.prepareStatement("SELECT UM_ROLE_ID FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=? AND UM_ROLE_ID=(SELECT UM_ID FROM UM_HYBRID_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?");
            prepStmt.setString(1, userName);
            prepStmt.setString(2, roleName);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) != -1) {
                isUserInRole = true;
            }
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return isUserInRole;
    }

    public void deleteUser(String userName) throws UserStoreException {
        Connection dbConnection = null;
        PreparedStatement preparedStatement = null;
        try {
            dbConnection = this.getDBConnection();
            preparedStatement = dbConnection.prepareStatement("DELETE FROM UM_HYBRID_USER_ROLE WHERE UM_USER_NAME=?");
            preparedStatement.setString(1, userName);
            preparedStatement.execute();
            this.userRealm.getAuthorizationManager().clearUserAuthorization(userName);
            dbConnection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, preparedStatement);
    }

    private Connection getDBConnection() throws SQLException {
        Connection dbConnection = this.dataSource.getConnection();
        dbConnection.setAutoCommit(false);
        return dbConnection;
    }
}

