/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.config.multitenancy;

import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.TenantMgtConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.config.multitenancy.MultiTenantRealmConfigBuilder;
import org.wso2.carbon.user.core.tenant.Tenant;

public class SimpleRealmConfigBuilder
implements MultiTenantRealmConfigBuilder {
    private static Log log = LogFactory.getLog(SimpleRealmConfigBuilder.class);

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealm(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToCreateRealmOnTenantCreation(RealmConfiguration bootStrapConfig, RealmConfiguration persistedConfig, int tenantId) throws UserStoreException {
        return persistedConfig;
    }

    @Override
    public RealmConfiguration getRealmConfigForTenantToPersist(RealmConfiguration bootStrapConfig, TenantMgtConfiguration tenantMgtConfiguration, Tenant tenantInfo, int tenantId) throws UserStoreException {
        try {
            RealmConfiguration realmConfig = bootStrapConfig.cloneRealmConfiguration();
            realmConfig.setAdminPassword(UUIDGenerator.getUUID());
            realmConfig.setAdminUserName(tenantInfo.getAdminName());
            realmConfig.setTenantId(tenantId);
            Map authz = realmConfig.getAuthzProperties();
            authz.put("AdminRoleManagementPermissions", "/permission/admin");
            realmConfig.getRealmProperties().remove("driverName");
            realmConfig.getRealmProperties().remove("url");
            realmConfig.getRealmProperties().remove("userName");
            realmConfig.getRealmProperties().remove("password");
            realmConfig.getRealmProperties().remove("maxActive");
            realmConfig.getRealmProperties().remove("minIdle");
            realmConfig.getRealmProperties().remove("maxWait");
            realmConfig.getRealmProperties().remove("dataSource");
            return realmConfig;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserStoreException(e.getMessage(), e);
        }
    }
}

