/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.core.authorization.AuthorizationCache;
import org.wso2.carbon.caching.core.rolesofuser.UserRolesCache;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.hybrid.HybridRoleManager;
import org.wso2.carbon.user.core.internal.UMListenerServiceComponent;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.listener.UserStoreManagerListener;
import org.wso2.carbon.user.core.profile.ProfileConfiguration;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public abstract class AbstractUserStoreManager
implements UserStoreManager {
    private static Log log = LogFactory.getLog(AbstractUserStoreManager.class);
    protected DataSource dataSource = null;
    protected RealmConfiguration realmConfig = null;
    protected ClaimManager claimManager = null;
    protected ProfileConfigurationManager profileManager = null;
    protected UserRealm userRealm = null;
    protected HybridRoleManager hybridRoleManager = null;
    protected UserRolesCache userRolesCache = null;
    private boolean userRolesCacheEnabled = true;
    private boolean replaceEscapeCharactersAtUserLogin = true;

    @Override
    public String getUserClaimValue(String userName, String claim, String profileName) throws UserStoreException {
        List<String> overridden;
        List<String> hidden;
        ProfileConfiguration profileConfig;
        String profileConfiguration = "default";
        String property = null;
        try {
            property = this.claimManager.getAttributeName(claim);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        try {
            profileConfig = (ProfileConfiguration)this.profileManager.getProfileConfig(profileConfiguration);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        if (profileConfig != null && (hidden = this.getMappingAttributeList(profileConfig.getHiddenClaims())).contains(property)) {
            return null;
        }
        String value = this.getUserPropertyValues(userName, new String[]{property}, profileName).get(property);
        if (!(value != null && value.trim().length() != 0 || "default".equals(profileName) || profileConfig == null || (overridden = this.getMappingAttributeList(profileConfig.getOverriddenClaims())).contains(property))) {
            value = this.getUserPropertyValues(userName, new String[]{property}, "default").get(property);
        }
        return value;
    }

    @Override
    public Claim[] getUserClaimValues(String userName, String profileName) throws UserStoreException {
        String[] claims;
        if (profileName == null) {
            profileName = "default";
        }
        try {
            claims = this.claimManager.getAllClaimUris();
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        Map<String, String> values = this.getUserClaimValues(userName, claims, profileName);
        Claim[] finalValues = new Claim[values.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String displayTag;
            Claim claim = new Claim();
            claim.setValue(entry.getValue());
            claim.setClaimUri(entry.getKey());
            try {
                displayTag = this.claimManager.getClaim(entry.getKey()).getDisplayTag();
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            claim.setDisplayTag(displayTag);
            finalValues[i] = claim;
            ++i;
        }
        return finalValues;
    }

    @Override
    public Map<String, String> getUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        ProfileConfiguration profileConfig;
        if (profileName == null) {
            profileName = "default";
        }
        String profileConfigurationName = null;
        boolean isPofileCnfigurationRequested = false;
        HashSet<String> propertySet = new HashSet<String>();
        for (String claim : claims) {
            ClaimMapping mapping = null;
            try {
                mapping = (ClaimMapping)this.claimManager.getClaimMapping(claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (mapping != null) {
                propertySet.add(mapping.getMappedAttribute());
            }
            if (!"profileConfiguration".equals(claim)) continue;
            isPofileCnfigurationRequested = true;
        }
        propertySet.add("profileConfiguration");
        String[] properties = propertySet.toArray(new String[propertySet.size()]);
        Map<String, String> uerProperties = this.getUserPropertyValues(userName, properties, profileName);
        profileConfigurationName = uerProperties.get("profileConfiguration");
        if (profileConfigurationName == null) {
            profileConfigurationName = "default";
        }
        try {
            profileConfig = (ProfileConfiguration)this.profileManager.getProfileConfig(profileConfigurationName);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        List<String> hidden = null;
        if (profileConfig != null) {
            hidden = this.getMappingAttributeList(profileConfig.getHiddenClaims());
        }
        List<String> overridden = null;
        if (profileConfig != null) {
            overridden = this.getMappingAttributeList(profileConfig.getOverriddenClaims());
        }
        ArrayList<String> getAgain = new ArrayList<String>();
        HashMap<String, String> finalValues = new HashMap<String, String>();
        if (isPofileCnfigurationRequested) {
            finalValues.put("profileConfiguration", profileConfigurationName);
        }
        for (String claim : claims) {
            ClaimMapping mapping;
            try {
                mapping = (ClaimMapping)this.claimManager.getClaimMapping(claim);
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
            if (mapping == null) continue;
            String property = mapping.getMappedAttribute();
            String value = uerProperties.get(property);
            if (hidden != null && hidden.contains(property)) continue;
            if (profileName.equals("default")) {
                if (value == null || value.trim().length() <= 0) continue;
                finalValues.put(claim, value);
                continue;
            }
            if (profileConfig != null && (value == null || value.equals(""))) {
                if (overridden != null && overridden.contains(property)) {
                    finalValues.put(claim, value);
                    continue;
                }
                getAgain.add(claim);
                continue;
            }
            if (value == null || value.trim().length() <= 0) continue;
            finalValues.put(claim, value);
        }
        if (getAgain.size() > 0) {
            Map<String, String> mapClaimValues = this.getUserClaimValues(userName, getAgain.toArray(new String[getAgain.size()]), "default");
            for (Map.Entry<String, String> entry : mapClaimValues.entrySet()) {
                if (entry.getValue() == null) continue;
                finalValues.put(entry.getKey(), entry.getValue());
            }
        }
        return finalValues;
    }

    protected List<String> getMappingAttributeList(List<String> claimList) throws UserStoreException {
        ArrayList<String> attributeList = null;
        Iterator<String> claimIter = null;
        attributeList = new ArrayList<String>();
        if (claimList == null) {
            return attributeList;
        }
        claimIter = claimList.iterator();
        while (claimIter.hasNext()) {
            try {
                attributeList.add(this.claimManager.getAttributeName(claimIter.next()));
            }
            catch (org.wso2.carbon.user.api.UserStoreException e) {
                throw new UserStoreException(e);
            }
        }
        return attributeList;
    }

    public abstract Map<String, String> getUserPropertyValues(String var1, String[] var2, String var3) throws UserStoreException;

    protected boolean checkUserPasswordValid(Object credential) throws UserStoreException {
        if (credential == null) {
            return false;
        }
        if (!(credential instanceof String)) {
            throw new UserStoreException("Can handle only string type credentials");
        }
        String password = ((String)credential).trim();
        if (password.length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("PasswordJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, password);
    }

    protected boolean checkUserNameValid(String userName) throws UserStoreException {
        if (userName == null || "wso2.system.user".equals(userName)) {
            return false;
        }
        if ((userName = userName.trim()).length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("UsernameJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, userName);
    }

    protected boolean roleNameValid(String roleName) {
        if (roleName == null) {
            return false;
        }
        if (roleName.length() < 1) {
            return false;
        }
        String regularExpression = this.realmConfig.getUserStoreProperty("RolenameJavaRegEx");
        return regularExpression == null || this.isFormatCorrect(regularExpression, roleName);
    }

    protected String[] getRoleListOfUserFromCache(int tenantID, String userName) {
        if (this.userRolesCache != null) {
            return this.userRolesCache.getRolesListOfUser(tenantID, userName);
        }
        return null;
    }

    protected void clearUserRolesCacheByTenant(int tenantID) {
        if (this.userRolesCache != null) {
            this.userRolesCache.clearCacheByTenant(tenantID);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByTenant(tenantID);
        }
    }

    protected void addToUserRolesCache(int tenantID, String userName, String[] roleList) {
        if (this.userRolesCache != null) {
            this.userRolesCache.addToCache(tenantID, userName, roleList);
            AuthorizationCache authorizationCache = AuthorizationCache.getInstance();
            authorizationCache.clearCacheByUser(tenantID, userName);
        }
    }

    protected void initUserRolesCache() {
        String userRolesCacheEnabledString = this.realmConfig.getUserStoreProperty("UserRolesCacheEnabled");
        if (userRolesCacheEnabledString != null && userRolesCacheEnabledString.equals("")) {
            this.userRolesCacheEnabled = Boolean.parseBoolean(userRolesCacheEnabledString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User Roles Cache is configured to:" + userRolesCacheEnabledString));
            }
        } else if (log.isDebugEnabled()) {
            log.info((Object)("User Roles Cache is not configured. Default value: " + this.userRolesCacheEnabled + " is taken."));
        }
        if (this.userRolesCacheEnabled) {
            this.userRolesCache = UserRolesCache.getUserRolesCacheInstance();
        }
    }

    private boolean isFormatCorrect(String regularExpression, String attribute) {
        Pattern p = Pattern.compile(regularExpression);
        Matcher m = p.matcher(attribute);
        return m.matches();
    }

    protected String replaceEscapeCharacters(String userName) {
        String replaceEscapeCharactersAtUserLoginString = this.realmConfig.getUserStoreProperty("ReplaceEscapeCharactersAtUserLogin");
        if (replaceEscapeCharactersAtUserLoginString != null) {
            this.replaceEscapeCharactersAtUserLogin = Boolean.parseBoolean(replaceEscapeCharactersAtUserLoginString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Replace escape characters at userlogin is condifured to: " + replaceEscapeCharactersAtUserLoginString));
            }
            if (this.replaceEscapeCharactersAtUserLogin) {
                return userName.replaceAll("\\\\", "\\\\\\\\");
            }
        }
        return userName;
    }

    @Override
    public String[] getUserList(String claim, String claimValue, String profileName) throws UserStoreException {
        String property;
        try {
            property = this.claimManager.getAttributeName(claim);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new UserStoreException(e);
        }
        return this.getUserListFromProperties(property, claimValue, profileName);
    }

    @Override
    public void updateCredential(String userName, Object newCredential, Object oldCredential) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.updateCredential(userName, newCredential, oldCredential, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreUpdateCredential(userName, newCredential, oldCredential, this)) continue;
            return;
        }
        this.doUpdateCredential(userName, newCredential, oldCredential);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostUpdateCredential(userName, this)) continue;
            return;
        }
    }

    @Override
    public void updateCredentialByAdmin(String userName, Object newCredential) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.updateCredentialByAdmin(userName, newCredential, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreUpdateCredentialByAdmin(userName, newCredential, this)) continue;
            return;
        }
        this.doUpdateCredentialByAdmin(userName, newCredential);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostUpdateCredentialByAdmin(userName, this)) continue;
            return;
        }
    }

    @Override
    public void deleteUser(String userName) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.deleteUser(userName, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreDeleteUser(userName, this)) continue;
            return;
        }
        this.doDeleteUser(userName);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostDeleteUser(userName, this)) continue;
            return;
        }
    }

    @Override
    public void setUserClaimValue(String userName, String claimURI, String claimValue, String profileName) throws UserStoreException {
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreSetUserClaimValue(userName, claimURI, claimValue, profileName, this)) continue;
            return;
        }
        this.doSetUserClaimValue(userName, claimURI, claimValue, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostSetUserClaimValue(userName, this)) continue;
            return;
        }
    }

    @Override
    public void setUserClaimValues(String userName, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreSetUserClaimValues(userName, claims, profileName, this)) continue;
            return;
        }
        this.doSetUserClaimValues(userName, claims, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostSetUserClaimValues(userName, this)) continue;
            return;
        }
    }

    @Override
    public void deleteUserClaimValue(String userName, String claimURI, String profileName) throws UserStoreException {
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreDeleteUserClaimValue(userName, claimURI, profileName, this)) continue;
            return;
        }
        this.doDeleteUserClaimValue(userName, claimURI, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostDeleteUserClaimValue(userName, this)) continue;
            return;
        }
    }

    @Override
    public void deleteUserClaimValues(String userName, String[] claims, String profileName) throws UserStoreException {
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPreDeleteUserClaimValues(userName, claims, profileName, this)) continue;
            return;
        }
        this.doDeleteUserClaimValues(userName, claims, profileName);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostDeleteUserClaimValues(userName, this)) continue;
            return;
        }
    }

    @Override
    public boolean authenticate(String userName, Object credential) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.authenticate(userName, credential, this)) continue;
            return true;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreAuthenticate(userName, credential, this)) continue;
            return false;
        }
        boolean authenticated = this.doAuthenticate(userName, credential);
        for (UserOperationEventListener listener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (listener.doPostAuthenticate(userName, authenticated, this)) continue;
            return false;
        }
        return authenticated;
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName, boolean requirePasswordChange) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.addUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreAddUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
        this.doAddUser(userName, credential, roleList, claims, profileName, requirePasswordChange);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostAddUser(userName, this)) continue;
            return;
        }
    }

    @Override
    public void addUser(String userName, Object credential, String[] roleList, Map<String, String> claims, String profileName) throws UserStoreException {
        for (UserStoreManagerListener userStoreManagerListener : UMListenerServiceComponent.getUserStoreManagerListeners()) {
            if (userStoreManagerListener.addUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPreAddUser(userName, credential, roleList, claims, profileName, this)) continue;
            return;
        }
        this.doAddUser(userName, credential, roleList, claims, profileName);
        for (UserOperationEventListener userOperationEventListener : UMListenerServiceComponent.getUserOperationEventListeners()) {
            if (userOperationEventListener.doPostAddUser(userName, this)) continue;
            return;
        }
    }

    public abstract String[] getUserListFromProperties(String var1, String var2, String var3) throws UserStoreException;

    public abstract boolean doAuthenticate(String var1, Object var2) throws UserStoreException;

    public abstract void doAddUser(String var1, Object var2, String[] var3, Map<String, String> var4, String var5) throws UserStoreException;

    public abstract void doAddUser(String var1, Object var2, String[] var3, Map<String, String> var4, String var5, boolean var6) throws UserStoreException;

    public abstract void doUpdateCredential(String var1, Object var2, Object var3) throws UserStoreException;

    public abstract void doUpdateCredentialByAdmin(String var1, Object var2) throws UserStoreException;

    public abstract void doDeleteUser(String var1) throws UserStoreException;

    public abstract void doSetUserClaimValue(String var1, String var2, String var3, String var4) throws UserStoreException;

    public abstract void doSetUserClaimValues(String var1, Map<String, String> var2, String var3) throws UserStoreException;

    public abstract void doDeleteUserClaimValue(String var1, String var2, String var3) throws UserStoreException;

    public abstract void doDeleteUserClaimValues(String var1, String[] var2, String var3) throws UserStoreException;
}

