/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.caching.core.rolesofuser;

import java.io.Serializable;
import org.wso2.carbon.caching.core.CacheKey;

public class UserRolesCacheKey
extends CacheKey
implements Serializable {
    private static final long serialVersionUID = 987045632165409867L;
    private String userName;
    private int tenantId;

    public UserRolesCacheKey(int tenantId, String userName) {
        this.tenantId = tenantId;
        this.userName = userName;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof UserRolesCacheKey)) {
            return false;
        }
        UserRolesCacheKey userRolesCacheKey = (UserRolesCacheKey)otherObject;
        return this.checkKeyAttributesEqual(userRolesCacheKey.getTenantId(), userRolesCacheKey.getUserName());
    }

    @Override
    public int hashCode() {
        return this.getAttributeHashCode();
    }

    public boolean checkKeyAttributesEqual(int tenantId, String userName) {
        return this.tenantId == tenantId && this.userName.equals(userName);
    }

    public int getAttributeHashCode() {
        return (this.tenantId == -1234 ? 0 : this.tenantId) + this.userName.hashCode() * 7;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public String getUserName() {
        return this.userName;
    }
}

