/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.internal.Utils;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class SecureTheWorldValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(SecureTheWorldValve.class);

    public void invoke(Request req, Response res) throws IOException, ServletException {
        String carbonWebContext = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
        String contextPath = req.getContextPath();
        String requestPath = req.getCoyoteRequest().toString();
        if (!requestPath.contains("/services/t/") && (carbonWebContext.equals("/") && contextPath.equals("") || carbonWebContext.equals(contextPath))) {
            this.getNext().invoke(req, res);
            return;
        }
        if (this.authenticate((HttpServletRequest)req)) {
            this.getNext().invoke(req, res);
        } else {
            res.setHeader("WWW-Authenticate", "Basic realm=\"WSO2 Carbon Authentication\"");
            res.sendError(401, "");
        }
    }

    private boolean authenticate(HttpServletRequest req) {
        String authhead = req.getHeader("Authorization");
        if (authhead != null) {
            String usernpass = SecureTheWorldValve.decode(authhead.substring(6));
            String userName = usernpass.substring(0, usernpass.indexOf(":"));
            String tenantLessUserName = userName.lastIndexOf(64) > -1 ? userName.substring(0, userName.lastIndexOf(64)) : userName;
            String tenantFromUserName = "";
            if (userName.lastIndexOf(64) > -1) {
                tenantFromUserName = userName.substring(userName.indexOf(64) + 1);
            }
            String password = usernpass.substring(usernpass.indexOf(":") + 1);
            String requestTenantDomain = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain();
            String tenantDomain = Utils.getTenantDomain(req);
            if (tenantDomain != null && !tenantDomain.equals(requestTenantDomain) || (!tenantFromUserName.equals("") || tenantDomain != null) && !tenantFromUserName.equals(requestTenantDomain)) {
                if (requestTenantDomain == null || requestTenantDomain.trim().length() == 0) {
                    requestTenantDomain = "0";
                }
                log.warn((Object)("Illegal access attempt by " + userName + " to secured resource hosted by tenant " + requestTenantDomain));
                return false;
            }
            RealmService realmService = CarbonRealmServiceHolder.getRealmService();
            try {
                int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                if (tenantId == -1) {
                    return false;
                }
                UserRealm userRealm = realmService.getTenantUserRealm(tenantId);
                if (realmService.getTenantUserRealm(tenantId).getUserStoreManager().authenticate(tenantLessUserName, (Object)password)) {
                    return true;
                }
            }
            catch (UserStoreException e) {
                log.error((Object)"Error occurred while authenticating", (Throwable)e);
            }
        }
        return false;
    }

    public static String decode(String encoded) {
        StringBuilder sb = new StringBuilder();
        int maxturns = encoded.length() % 3 == 0 ? encoded.length() : encoded.length() + (3 - encoded.length() % 3);
        byte[] unenc = new byte[4];
        int j = 0;
        for (int i = 0; i < maxturns; ++i) {
            boolean skip = false;
            byte b = i < encoded.length() ? (byte)encoded.charAt(i) : (byte)0;
            if (b >= 65 && b < 91) {
                unenc[j] = (byte)(b - 65);
            } else if (b >= 97 && b < 123) {
                unenc[j] = (byte)(b - 71);
            } else if (b >= 48 && b < 58) {
                unenc[j] = (byte)(b + 4);
            } else if (b == 43) {
                unenc[j] = 62;
            } else if (b == 47) {
                unenc[j] = 63;
            } else if (b == 61) {
                unenc[j] = 0;
            } else {
                char c = (char)b;
                if (c == '\n' || c == '\r' || c == ' ' || c == '\t') {
                    skip = true;
                }
            }
            if (skip || ++j != 4) continue;
            int res = (unenc[0] << 18) + (unenc[1] << 12) + (unenc[2] << 6) + unenc[3];
            for (int k = 16; k >= 0; k -= 8) {
                byte c = (byte)(res >> k);
                if (c <= 0) continue;
                sb.append((char)c);
            }
            j = 0;
            unenc[0] = 0;
            unenc[1] = 0;
            unenc[2] = 0;
            unenc[3] = 0;
        }
        return sb.toString();
    }
}

