/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.registry.core.ghostregistry.GhostRegistry;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.internal.Utils;
import org.wso2.carbon.user.api.TenantManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.CarbonApplicationContextHolder;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class CarbonContextCreatorValve
extends ValveBase {
    private static Log log = LogFactory.getLog(CarbonContextCreatorValve.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        try {
            this.initCarbonContext(request);
            this.getNext().invoke(request, response);
        }
        catch (Exception e) {
            log.error((Object)("Could not handle request: " + request.getRequestURI()), (Throwable)e);
        }
        finally {
            if (!request.getContext().getName().equals("/")) {
                CarbonApplicationContextHolder.destroyCurrentCarbonAppContextHolder();
            }
            CarbonContextHolder.destroyCurrentCarbonContextHolder();
        }
    }

    public void initCarbonContext(Request request) throws Exception {
        String tenantDomain = Utils.getTenantDomain((HttpServletRequest)request);
        CarbonContextHolder carbonContextHolder = CarbonContextHolder.getThreadLocalCarbonContextHolder();
        carbonContextHolder.setTenantDomain(tenantDomain);
        if (!request.getContext().getName().equals("/")) {
            CarbonApplicationContextHolder currentCarbonAppContextHolder = CarbonApplicationContextHolder.getCurrentCarbonAppContextHolder();
            currentCarbonAppContextHolder.startApplicationFlow();
            currentCarbonAppContextHolder.setApplicationName(request.getContext().getBaseName());
        }
        if (tenantDomain != null) {
            RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
            TenantManager tenantManager = userRealmService.getTenantManager();
            int tenantId = tenantManager.getTenantId(tenantDomain);
            carbonContextHolder.setTenantId(tenantId);
            carbonContextHolder.setProperty("userRealm", (Object)userRealmService.getTenantUserRealm(tenantId));
            org.wso2.carbon.registry.core.service.RegistryService registryService = CarbonRealmServiceHolder.getRegistryService();
            carbonContextHolder.setProperty("configSystemRegistry", (Object)new GhostRegistry((RegistryService)registryService, tenantId, RegistryType.SYSTEM_CONFIGURATION));
            carbonContextHolder.setProperty("governanceSystemRegistry", (Object)new GhostRegistry((RegistryService)registryService, tenantId, RegistryType.SYSTEM_GOVERNANCE));
        }
    }
}

