/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.ext.realms;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.ext.internal.CarbonRealmServiceHolder;
import org.wso2.carbon.tomcat.ext.saas.TenantSaaSRules;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonTomcatRealm
extends RealmBase {
    private static Log log = LogFactory.getLog(CarbonTomcatRealm.class);
    private static ThreadLocal<HashMap> tenantSaaSRulesMap = new ThreadLocal();
    private static ThreadLocal<Boolean> isSaaSEnabled = new ThreadLocal();

    public boolean isSaaSEnabled() {
        return isSaaSEnabled.get();
    }

    public void setSaaSEnabled(boolean saaSEnabled) {
        isSaaSEnabled.set(saaSEnabled);
    }

    public void setSaaSRules(HashMap<String, TenantSaaSRules> tenantSaaSRulesMap) {
        CarbonTomcatRealm.tenantSaaSRulesMap.set(tenantSaaSRulesMap);
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getPassword(String username) {
        throw new IllegalStateException("When CarbonTomcatRealm is in operation this method getPassword(String) should never be called");
    }

    public Principal authenticate(String username, String response, String nonce, String nc, String cNonce, String qop, String realmName, String md5) {
        throw new IllegalStateException("Carbon doesn't use MD5 hashes. Can't do digest authentication");
    }

    public Principal authenticate(String userName, String credential) {
        String tenantLessUserName;
        String tenantDomain = null;
        tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
        if (userName.lastIndexOf(64) > -1) {
            tenantLessUserName = userName.substring(0, userName.lastIndexOf(64));
        } else if ("carbon.super".equals(tenantDomain)) {
            tenantLessUserName = userName;
            userName = userName + "@" + "carbon.super";
        } else {
            tenantLessUserName = userName;
        }
        try {
            RealmService userRealmService = CarbonRealmServiceHolder.getRealmService();
            int tenantId = userRealmService.getTenantManager().getTenantId(tenantDomain);
            if (tenantId == -1) {
                return null;
            }
            String[] roles = userRealmService.getTenantUserRealm(tenantId).getUserStoreManager().getRoleListOfUser(tenantLessUserName);
            if (!this.checkSaasAccess(tenantDomain, tenantLessUserName, roles)) {
                String requestTenantDomain = CarbonContextHolder.getCurrentCarbonContextHolder().getTenantDomain();
                if (tenantDomain != null && !tenantDomain.equals(requestTenantDomain)) {
                    if (requestTenantDomain.trim().length() == 0) {
                        requestTenantDomain = "0";
                    }
                    log.warn((Object)("Illegal access attempt by " + userName + " to secured resource hosted by tenant " + requestTenantDomain));
                    return null;
                }
            }
            if (!userRealmService.getTenantUserRealm(tenantId).getUserStoreManager().authenticate(tenantLessUserName, (Object)credential)) {
                return null;
            }
            return this.getPrincipal(userName);
        }
        catch (UserStoreException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean checkSaasAccess(String tenantDomain, String userName, String[] userRoles) {
        if (!this.isSaaSEnabled()) {
            return false;
        }
        HashMap tenantSaaSRulesMap = CarbonTomcatRealm.tenantSaaSRulesMap.get();
        Set saaSTenants = tenantSaaSRulesMap.keySet();
        List<String> userRolesList = Arrays.asList(userRoles);
        boolean isUserAccepted = false;
        boolean isRoleAccepted = false;
        boolean isTenantAccepted = false;
        if (userName == null || tenantDomain == null) {
            return false;
        }
        if (saaSTenants.contains("!".concat(tenantDomain))) {
            return false;
        }
        if (saaSTenants.contains(tenantDomain)) {
            TenantSaaSRules tenantSaaSRules = (TenantSaaSRules)tenantSaaSRulesMap.get(tenantDomain);
            ArrayList<String> users = tenantSaaSRules.getUsers();
            ArrayList<String> roles = tenantSaaSRules.getRoles();
            if (users != null && users.contains("!".concat(userName))) {
                return false;
            }
            if (roles != null && userRolesList != null) {
                boolean contains = false;
                for (String userRole : userRolesList) {
                    if (roles.contains("!".concat(userRole))) {
                        return false;
                    }
                    if (!roles.contains(userRole)) continue;
                    contains = true;
                }
                if (contains || roles.contains("*")) {
                    isRoleAccepted = true;
                }
            } else if (users != null && (users.contains(userName) || users.contains("*"))) {
                isUserAccepted = true;
            }
        } else if (saaSTenants.contains(tenantDomain) && !((TenantSaaSRules)tenantSaaSRulesMap.get(tenantDomain)).isTenantRulesDefined() || saaSTenants.contains("*")) {
            isTenantAccepted = true;
        }
        return isUserAccepted || isTenantAccepted || isRoleAccepted;
    }

    protected Principal getPrincipal(String userNameWithTenant) {
        return new GenericCarbonPrincipal(userNameWithTenant);
    }

    private static class GenericCarbonPrincipal
    extends GenericPrincipal {
        private String tenantDomain = null;

        public GenericCarbonPrincipal(String name) {
            super(name, null);
            if (name.contains("@")) {
                this.tenantDomain = name.substring(name.indexOf(64) + 1);
            }
        }

        public String getPassword() {
            throw new IllegalStateException("When CarbonTomcatRealm is in operation this method Principal.getPassword() should never be called");
        }

        public boolean hasRole(String role) {
            try {
                RealmService realmService = CarbonRealmServiceHolder.getRealmService();
                int tenantId = realmService.getTenantManager().getTenantId(this.tenantDomain);
                int indexOfAt = this.name.lastIndexOf(64);
                String tenantLessUserName = indexOfAt == -1 ? this.name : this.name.substring(0, indexOfAt);
                Object[] roles = CarbonRealmServiceHolder.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager().getRoleListOfUser(tenantLessUserName);
                Arrays.sort(roles);
                return Arrays.binarySearch(roles, role) > -1;
            }
            catch (UserStoreException e) {
                log.error((Object)"Cannot check role", (Throwable)e);
                return false;
            }
        }
    }
}

