/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.feature.mgt.core.util;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.wso2.carbon.feature.mgt.core.ProvisioningException;
import org.wso2.carbon.feature.mgt.core.ResolutionResult;
import org.wso2.carbon.feature.mgt.core.internal.ServiceHolder;
import org.wso2.carbon.feature.mgt.core.operations.ProfileChangeOperation;
import org.wso2.carbon.feature.mgt.core.util.IUPropertyUtils;

public final class ProvisioningUtils {
    private ProvisioningUtils() {
    }

    public static ResolutionResult reviewProvisioningAction(ProfileChangeOperation profileModificationAction) throws ProvisioningException {
        return profileModificationAction.reviewProfileChangeAction(ProvisioningUtils.getProfile());
    }

    public static void performProvisioningAction(ResolutionResult resolutionResult, boolean applyConfiguration) throws ProvisioningException {
        int severity = resolutionResult.getSummaryStatus().getSeverity();
        if (severity != 4) {
            IStatus status = ProvisioningUtils.performProvisioningAction(resolutionResult.getProvisioningPlan(), applyConfiguration);
            if (status.getSeverity() == 4) {
                ResolutionResult rs = new ResolutionResult();
                rs.addSummaryStatus(status);
                String summaryReport = rs.getSummaryReport();
                throw new ProvisioningException(summaryReport);
            }
        } else {
            throw new ProvisioningException(resolutionResult.getSummaryReport());
        }
    }

    public static void performProvisioningAction(ResolutionResult resolutionResult) throws ProvisioningException {
        ProvisioningUtils.performProvisioningAction(resolutionResult, false);
    }

    public static ILicense[] getLicensingInformation(IProvisioningPlan provisioningPlan) throws ProvisioningException, URISyntaxException {
        IInstallableUnit[] installableUnits;
        ArrayList<ILicense> licenseArrayList = new ArrayList<ILicense>();
        for (IInstallableUnit iu : installableUnits = (IInstallableUnit[])provisioningPlan.getAdditions().query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class)) {
            boolean found = false;
            ILicense license = IUPropertyUtils.getLicense(iu);
            if (license == null) continue;
            for (ILicense addedLicense : licenseArrayList) {
                if (!addedLicense.equals(license)) continue;
                found = true;
                break;
            }
            if (found) continue;
            licenseArrayList.add(license);
        }
        return licenseArrayList.toArray(new ILicense[licenseArrayList.size()]);
    }

    public static IInstallableUnit[] getAllInstalledIUs() {
        IInstallableUnit[] groupPropertyTrueIUs = (IInstallableUnit[])ProvisioningUtils.getProfile().query(QueryUtil.createIUPropertyQuery((String)"org.eclipse.equinox.p2.type.group", (String)Boolean.TRUE.toString()), (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
        IInstallableUnit[] groupPropertyFalseIUs = (IInstallableUnit[])ProvisioningUtils.getProfile().query(QueryUtil.createIUPropertyQuery((String)"org.eclipse.equinox.p2.type.group", (String)Boolean.FALSE.toString()), (IProgressMonitor)new NullProgressMonitor()).toArray(IInstallableUnit.class);
        IInstallableUnit[] allInstalledIUs = new IInstallableUnit[groupPropertyFalseIUs.length + groupPropertyTrueIUs.length];
        System.arraycopy(groupPropertyTrueIUs, 0, allInstalledIUs, 0, groupPropertyTrueIUs.length);
        System.arraycopy(groupPropertyFalseIUs, 0, allInstalledIUs, groupPropertyTrueIUs.length, groupPropertyFalseIUs.length);
        return allInstalledIUs;
    }

    public static IProfile getProfile() {
        try {
            IProfileRegistry profileRegistry = ServiceHolder.getProfileRegistry();
            return profileRegistry.getProfile("_SELF_");
        }
        catch (ProvisioningException e) {
            return null;
        }
    }

    public static IProfile getProfile(String id, long timestamp) {
        try {
            IProfileRegistry profileRegistry = ServiceHolder.getProfileRegistry();
            return profileRegistry.getProfile(id, timestamp);
        }
        catch (ProvisioningException e) {
            return null;
        }
    }

    public static IInstallableUnit[] sort(IInstallableUnit[] ius) {
        Arrays.sort(ius, new Comparator<IInstallableUnit>(){

            @Override
            public int compare(IInstallableUnit arg0, IInstallableUnit arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        return ius;
    }

    public static boolean isIUInstalled(IInstallableUnit iu, HashMap<String, IInstallableUnit> installedIUMap) {
        IInstallableUnit installedIU = installedIUMap.get(iu.getId());
        return installedIU != null && installedIU.getVersion().compareTo((Object)iu.getVersion()) >= 0;
    }

    public static long[] getProfileTimestamps(String profileID) throws ProvisioningException {
        IProfileRegistry profileRegistry = ServiceHolder.getProfileRegistry();
        return profileRegistry.listProfileTimestamps(profileID);
    }

    private static IStatus performProvisioningAction(IProvisioningPlan provisioningPlan, boolean applyConfiguration) throws ProvisioningException {
        ProvisioningContext context = ServiceHolder.getProvisioningContext();
        IEngine engine = ServiceHolder.getP2Engine();
        context.setMetadataRepositories(ServiceHolder.getMetadataRepositoryManager().getKnownRepositories(0));
        context.setArtifactRepositories(ServiceHolder.getArtifactRepositoryManager().getKnownRepositories(0));
        IStatus status = PlanExecutionHelper.executePlan((IProvisioningPlan)provisioningPlan, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
        return status;
    }

    @Deprecated
    public static Collection<IInstallableUnit> getAllInstallableUnits(IQueryable queryable, boolean showLatest) {
        IQuery query = showLatest ? QueryUtil.createMatchQuery((String)"latest(x | x.properties[$0] == $1)", (Object[])new String[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()}) : QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new String[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()});
        return queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
    }

    public static Collection<IInstallableUnit> getCategoryTypeInstallableUnits(IQueryable queryable, boolean showLatest) {
        IQuery query = null;
        query = showLatest ? QueryUtil.createQuery((String)"latest(x | x.properties[$0] == $1)", (Object[])new String[]{"org.eclipse.equinox.p2.type.category", Boolean.TRUE.toString()}) : QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new String[]{"org.eclipse.equinox.p2.type.category", Boolean.TRUE.toString()});
        return queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
    }

    public static Collection<IInstallableUnit> getGroupTypeInstallableUnits(IQueryable queryable, boolean showLatest) {
        IQuery query = null;
        query = showLatest ? QueryUtil.createQuery((String)"latest(x | x.properties[$0] == $1)", (Object[])new String[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()}) : QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new String[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()});
        return queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
    }

    public static Collection<IInstallableUnit> getAllInstalledRootFeatures(IQueryable queryable) {
        IQuery query = QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new String[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()});
        return queryable.query(query, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
    }
}

